

<?php $__env->startSection('content'); ?>
    <p><?php echo e(__('lang.thank_order', [], $lang)); ?> <?php echo e($setting->store_name); ?>.
        <?php echo e(__('lang.order_logging', [], $lang)); ?>

        <a href="<?php echo e(env('CLIENT_BASE_URL', config('env.url.CLIENT_BASE_URL'))); ?>/user/orders" .><?php echo e(__('lang.your_account', [], $lang)); ?></a></p>

    <h3 class="mt-15"><?php echo e(__('lang.your_order', [], $lang)); ?> #<?php echo e($order->order); ?></h3>
    <p class="mb-20"><?php echo e(__('lang.placed_on', [], $lang)); ?> <?php echo e($order->created); ?></p>

    <table class="mb-10">
        <tr>
            <th class="pb-10"><?php echo e(__('lang.ship_to', [], $lang)); ?></th>
            <th class="pb-10"><?php echo e(__('lang.order_method', [], $lang)); ?></th>
        </tr>

        <tr>
            <td style="width: 50%;">
                <div style="max-width: 300px;">
                    <h5 style="margin-bottom: 5px"><?php echo e($order->address->name); ?></h5>
                    <p><?php echo e($order->formatted_address); ?></p>

                    <?php if($order->user): ?>
                        <p><?php echo e(__('lang.email', [], $lang)); ?>: <?php echo e($order->user->email); ?></p>
                    <?php elseif($order->guest_user): ?>
                        <p><?php echo e(__('lang.email', [], $lang)); ?>: <?php echo e($order->guest_user->email); ?></p>
                    <?php endif; ?>

                    <p><?php echo e(__('lang.phone', [], $lang)); ?>: <?php echo e($order->address->phone); ?></p>
                </div>
            </td>
            <td style="width: 50%;"><?php echo e($order->order_method); ?></td>
        </tr>
    </table><!--table-->


    <table style="background: #eee; border: 1px solid #ddd; border-bottom: none" class="mt-20 main-table border-tr">
        <tr>
            <th><?php echo e(__('lang.title', [], $lang)); ?></th>
            <th><?php echo e(__('lang.delivery_fee', [], $lang)); ?></th>
            <th><?php echo e(__('lang.quantity', [], $lang)); ?></th>
            <th><?php echo e(__('lang.price', [], $lang)); ?></th>
            <th><?php echo e(__('lang.total', [], $lang)); ?></th>
        </tr>

        <?php $__currentLoopData = $order->ordered_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $op): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr style="background: #fff">
                <td>
                    <b><?php echo e($op->product->title); ?></b>
                    <span class="mt-5 f-9 block"><?php echo e(\App\Models\Helper\MailHelper::generatingAttribute($op)); ?></span>
                </td>
                <td>
                    <?php echo e($setting->currency_icon); ?>

                    <?php echo e(\App\Models\Helper\MailHelper::shippingPrice($op->shipping_place, $op->shipping_type)); ?>

                </td>
                <td><?php echo e($op->quantity); ?></td>

                <td><?php echo e($setting->currency_icon); ?><?php echo e($op->selling); ?></td>
                <td><?php echo e($setting->currency_icon); ?><?php echo e($op->selling * $op->quantity); ?></td>
            </tr>

        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </table><!--table-->

    <table class="border-tr td-right-align footer-table"
           style="border: 1px solid #ddd; background: #eee; ">
        <tr>
            <td style="width: 630px" ><?php echo e(__('lang.subtotal', [], $lang)); ?></td>
            <td style="width: 70px;"><?php echo e($setting->currency_icon); ?><?php echo e($order->calculated_price['subtotal']); ?></td>
        </tr>
        <tr>
            <td><?php echo e(__('lang.shipping_cost', [], $lang)); ?></td>
            <td><?php echo e($setting->currency_icon); ?><?php echo e($order->calculated_price['shipping_price']); ?></td>
        </tr>

        <?php if((int) $order->calculated_price['bundle_offer'] > 0): ?>
            <tr>
                <td><?php echo e(__('lang.bundle_offer', [], $lang)); ?></td>
                <td><?php echo e($setting->currency_icon); ?><?php echo e($order->calculated_price['bundle_offer']); ?></td>
            </tr>
        <?php endif; ?>

        <?php if((int) $order->calculated_price['voucher_price'] > 0): ?>
            <tr>
                <td><?php echo e(__('lang.voucher', [], $lang)); ?></td>
                <td><?php echo e($setting->currency_icon); ?><?php echo e($order->calculated_price['voucher_price']); ?></td>
            </tr>
        <?php endif; ?>

        <?php if((int) $order->calculated_price['tax'] > 0): ?>
            <tr>
                <td><?php echo e(__('lang.tax', [], $lang)); ?></td>
                <td><?php echo e($setting->currency_icon); ?><?php echo e($order->calculated_price['tax']); ?></td>
            </tr>
        <?php endif; ?>

        <tr>
            <td><?php echo e(__('lang.total', [], $lang)); ?></td>
            <td><?php echo e($setting->currency_icon); ?><?php echo e($order->calculated_price['total_price']); ?></td>
        </tr>
    </table>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.email_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH G:\Full Project\Server\backend\resources\views/mail_templates/order_placed.blade.php ENDPATH**/ ?>