<html>
<head>

    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <style>
        * {
            box-sizing: border-box;
        }

        body,
        html {
            margin: 0;
            padding: 0;
            border: 0;
            font-size: 100%;
            vertical-align: baseline;
            min-height: 100%;
            max-width: 100%;
            box-sizing: border-box;
        }

        body {
            font-size: 14px;
            font-family: DejaVu Sans, sans-serif;
            font-weight: 400;
            color: #444;
        }

        h1, h2, h3, h4, h5, h6, p, ul, span, li, input, button {
            margin: 0;
            padding: 0;
            line-height: 1.4;
            box-sizing: border-box;
        }

        span {
            font-family: DejaVu Sans, sans-serif;
            line-height: inherit;
        }

        h1, h2, h3, h4, h5, h6 {
            font-weight: inherit;
        }

        p {
            line-height: 1.8;
            font-size: 1em;
            font-weight: 400;
            color: #112211;
        }

        h1 {
            font-size: 3.5em;
        }

        h2 {
            font-size: 2.5em;
        }

        h3 {
            font-size: 1.8em;
        }

        h4 {
            font-size: 1.3em;
        }

        h5 {
            font-size: 1.1em;
        }

        h6 {
            font-size: .95em;
            letter-spacing: 1px;
            line-height: 1.6;
        }

        strong {
            font-weight: 700;
        }

        img {
            width: 100%;
            height: auto;
            object-fit: cover;
        }

        li {
            display: block;
            list-style: none;
            font-size: 1em;
        }

        i, span {
            display: inline-block;
        }

        b {
            display: inline-block;
            font-weight: 500;
        }

        .p-30 {
            padding: 30px;
        }


        table {
            width: 100%;
            font-family: inherit;
        }

        table tr {
            vertical-align: top;
        }

        table td {
            font-family: inherit;
        }

        table th {
            font-family: inherit;
            text-align: left;
        }

        .table-c tr th {
            background: #486FF0;
            color: #fff;
            text-align: left;
            font-size: .9em;
            font-weight: 400;
            padding: 10px;
        }

        .border-tr tr td {
            padding: 10px;
            border-bottom: 1px solid #eee;
        }

        .border-tr tr:last-child td {
            border-bottom: none;
        }

        .table-c tr td {
            padding: 5px 10px;
        }

        .td-right-align tr td {
            text-align: right;
            padding: 5px 0;
        }

        .main-table tr td{
            padding: 15px 10px;
        }

        .mt-10 {
            margin-top: 10px;
        }

        .mb-5 {
            margin-bottom: 5px;
        }

        .mb-10 {
            margin-bottom: 10px;
        }

        .mb-20 {
            margin-bottom: 20px;
        }

        .ml-10 {
            margin-left: 10px;
        }

        .block {
            display: block;
        }

        .mt-5 {
            margin-top: 5px;
        }

        .f-9{
            font-size: .9em;
            color: #666
        }

    </style>
</head>
<body style="padding: 30px;">
<table class="mb-20">
    <tr>
        <td>
            <div style="max-width: 350px;">
                <img style="height: 25px; width: auto; margin-bottom: 10px"
                     src="data:image/png;base64,<?php echo e($setting->logo_base64); ?>">
                <h4 class="mt-10 mb-10"><?php echo e($setting->store_name); ?></h4>
                <p> <?php echo e($setting->address); ?></p>
                <p><?php echo e(__('lang.phone')); ?>: <?php echo e($setting->phone); ?></p>
            </div>
        </td>
        <td>
            <h3 class="mb-10 ml-10">Invoice</h3>
            <table style="max-width: 400px;">
                <tr>
                    <td><?php echo e(__('lang.order')); ?></td>
                    <td>#<?php echo e($order->order); ?></td>
                </tr>
                <tr>
                    <td><?php echo e(__('lang.order_date')); ?></td>
                    <td><?php echo e($order->created); ?></td>
                </tr>
                <tr>
                    <td><?php echo e(__('lang.order_amount')); ?></td>
                    <td><?php echo e($setting->currency_icon); ?><?php echo e($order->calculated_price['total_price']); ?></td>
                </tr>
            </table>
        </td>
    </tr>
</table>

<table class="mb-20 table-c">
    <tr>
        <th style="text-align: left;"><?php echo e(__('lang.ship_to')); ?></th>
        <th style="text-align: left;"><?php echo e(__('lang.order_method')); ?></th>
    </tr>

    <tr>
        <td style="width: 50%;">
            <div style="max-width: 300px;">
                <h5 class="mb-5"><?php echo e($order->address->name); ?></h5>
                <p><?php echo e($order->formatted_address); ?></p>

                <?php if($order->user): ?>
                    <p><?php echo e(__('lang.email')); ?>: <?php echo e($order->user->email); ?></p>
                <?php elseif($order->guest_user): ?>
                    <p><?php echo e(__('lang.email')); ?>: <?php echo e($order->guest_user->email); ?></p>
                <?php endif; ?>


                <p><?php echo e(__('lang.phone')); ?>: <?php echo e($order->address->phone); ?></p>
            </div>
        </td>
        <td style="width: 50%;"><?php echo e($order->order_method); ?></td>
    </tr>
</table><!--table-->

<table class="border-tr table-c main-table">
    <tr>
        <th><?php echo e(__('lang.title')); ?></th>
        <th><?php echo e(__('lang.delivery_fee')); ?></th>
        <th><?php echo e(__('lang.quantity')); ?></th>
        <th><?php echo e(__('lang.price')); ?></th>
        <th><?php echo e(__('lang.total')); ?></th>
    </tr>

    <?php $__currentLoopData = $order->ordered_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $op): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td>
               <?php echo e($op->product->title); ?>

                <span class="mt-5 f-9 block"><?php echo e(\App\Models\Helper\MailHelper::generatingAttribute($op)); ?></span>
            </td>
            <td>
                <?php echo e($setting->currency_icon); ?>

                <?php echo e(\App\Models\Helper\MailHelper::shippingPrice($op->shipping_place, $op->shipping_type)); ?>

            </td>
            <td><?php echo e($op->quantity); ?></td>

            <td><?php echo e($setting->currency_icon); ?><?php echo e($op->selling); ?></td>
            <td><?php echo e($setting->currency_icon); ?><?php echo e($op->selling * $op->quantity); ?></td>
        </tr>

    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</table><!--table-->

<div style="width: 100%; clear: both; display: block;">
    <table class="border-tr td-right-align" style="margin-left: auto; width: 180px; max-width: 180px;">
        <tr>
            <td style="min-width: 110px"><?php echo e(__('lang.subtotal')); ?></td>
            <td style="min-width: 40px"><?php echo e($setting->currency_icon); ?><?php echo e($order->calculated_price['subtotal']); ?></td>
        </tr>
        <tr>
            <td><?php echo e(__('lang.shipping_cost')); ?></td>
            <td><?php echo e($setting->currency_icon); ?><?php echo e($order->calculated_price['shipping_price']); ?></td>
        </tr>

        <?php if((int) $order->calculated_price['bundle_offer'] > 0): ?>
            <tr>
                <td><?php echo e(__('lang.bundle_offer')); ?></td>
                <td><?php echo e($setting->currency_icon); ?><?php echo e($order->calculated_price['bundle_offer']); ?></td>
            </tr>
        <?php endif; ?>

        <?php if((int) $order->calculated_price['voucher_price'] > 0): ?>
            <tr>
                <td><?php echo e(__('lang.voucher')); ?></td>
                <td><?php echo e($setting->currency_icon); ?><?php echo e($order->calculated_price['voucher_price']); ?></td>
            </tr>
        <?php endif; ?>

        <?php if((int) $order->calculated_price['tax'] > 0): ?>
            <tr>
                <td><?php echo e(__('lang.tax')); ?></td>
                <td><?php echo e($setting->currency_icon); ?><?php echo e($order->calculated_price['tax']); ?></td>
            </tr>
        <?php endif; ?>

        <tr>
            <td><?php echo e(__('lang.total')); ?></td>
            <td><?php echo e($setting->currency_icon); ?><?php echo e($order->calculated_price['total_price']); ?></td>
        </tr>
    </table>
</div>



<div style="width: 100%; clear: both; display: block; padding-top: 150px;">
    <table class="table-c" style="width: 50%;">
        <tr>
            <th><?php echo e(__('lang.notes')); ?></th>
        </tr>

        <tr>
            <td style="width: 50%;">
                <p style="margin-bottom: 10px; font-style: italic;">
                    <?php echo e(__('lang.order_number')); ?>

                </p>
                <p>
                    <?php echo e(__('lang.question_str')); ?>: <?php echo e($setting->phone); ?>

                </p>
            </td>
        </tr>
    </table><!--table-->
</div>



</body>
<?php /**PATH G:\Full Project\Server\backend\resources\views/mail_templates/order_pdf.blade.php ENDPATH**/ ?>