<?php

namespace Database\Seeders;

use App\Models\Admin;
use App\Models\Brand;
use App\Models\BundleDeal;
use App\Models\Category;
use App\Models\Helper\Utils;
use App\Models\Product;
use App\Models\ShippingRule;
use App\Models\SubCategory;
use App\Models\TaxRules;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Config;

class ProductSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $url = config('env.media.CDN_URL');
        if(config('env.media.STORAGE') == config('env.media.LOCAL')){
            $url = config('env.url.APP_URL') .  '/uploads/';

        }else if(config('env.media.STORAGE') == config('env.media.GCS')){
            $url =  config('env.media.CDN_URL') .  '/uploads/';
        }

        $descriptionImg1 = $url . 'product-description-1.webp';
        $descriptionImg2 = $url . 'product-description-2.webp';
        $descriptionImg3 = $url . 'product-description-3.webp';
        $description = "<p><img src='". $descriptionImg1 ."'></p><p><img src='". $descriptionImg2 ."'></p><p><img src='". $descriptionImg3 ."'></p>";


        $productOverview = "<ul><li>Is Discontinued ‏ : ‎&nbsp;No</li><li>Product Dimensions ‏ : ‎&nbsp;3 x 3 x 3 inches; 1.76 Ounces</li><li>Item model number ‏ : ‎&nbsp;231171045</li></ul><p><br></p>";


        $items = [
            [
                'id' => 88630111,
                'title' => "Women’s Casual Long Sleeve Lapel Zipper Sweatshirt Drawstring Loose Pullover Tops",
                'meta_title' => "Women’s Casual Long Sleeve Lapel Zipper Sweatshirt Drawstring Loose Pullover Tops",
                'description' => $description,
                'meta_description' => "Women’s Casual Long Sleeve Lapel Zipper Sweatshirt Drawstring Loose Pullover Tops",
                'overview' => $productOverview,
                'selling' => 130,
                'purchased' => 61,
                'badge' => 'New',
                'bundle_deal_id' => 1,
                'offered' => 81,
                'tax_rule_id' => 1,
                'rating' => 4.2,
                'review_count' => 5,
                'shipping_rule_id' => 1,
                'brand_id' => 9442200,
                'category_id' => 63082111,
                'subcategory_id' => 64273111,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 1,
                'refundable' => 1,
                'image' => 'product-1-1.webp'
            ],
            [
                'id' => 88630112,
                'title' => "Tops Knit Shirts Casual Ruffle Short Sleeve Top Round Neck Tunic Tank Tops Tee Blouse for Women",
                'meta_title' => "Tops Knit Shirts Casual Ruffle Short Sleeve Top Round Neck Tunic Tank Tops Tee Blouse for Women",
                'meta_description' => "Tops Knit Shirts Casual Ruffle Short Sleeve Top Round Neck Tunic Tank Tops Tee Blouse for Women",
                'description' => $description,
                 'overview' => $productOverview,
                'selling' => 100,
                'purchased' => 62,
                'offered' => 82,
                'bundle_deal_id' => 1,
                'tax_rule_id' => 1,
                'rating' => 4.5,
                'review_count' => 4,
                'shipping_rule_id' => 1,
                'brand_id' => 9442200,
                'category_id' => 63082111,
                'subcategory_id' => 64273111,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 1,
                'refundable' => 1,
                'image' => 'product-2-1.webp'
            ],

            [
                'id' => 88630113,
                'title' => "Andongnywell Casual Solid Color Ruffle Collar Long Sleeve Ruffle Shirt Blouse V Neck Short Sleeve Shirt Top",
                'meta_title' => "Andongnywell Casual Solid Color Ruffle Collar Long Sleeve Ruffle Shirt Blouse V Neck Short Sleeve Shirt Top",
                'description' => $description,
                'meta_description' => "Andongnywell Casual Solid Color Ruffle Collar Long Sleeve Ruffle Shirt Blouse V Neck Short Sleeve Shirt Top",
                'overview' => $productOverview,
                'selling' => 100,
                'purchased' => 63,
                'offered' => 83,
                'tax_rule_id' => 1,
                'rating' => 5,
                'bundle_deal_id' => 1,
                'review_count' => 3,
                'shipping_rule_id' => 1,
                'brand_id' => 9442200,
                'category_id' => 63082111,
                'subcategory_id' => 64273111,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 1,
                'refundable' => 1,
                'image' => 'product-3-1.webp'
            ],

            [
                'id' => 88630114,
                'title' => "Women's Waffle Knit Blouse Ballon Long Sleeve Lace Tops Casual Loose T Shirts",
                'meta_title' => "Women's Waffle Knit Blouse Ballon Long Sleeve Lace Tops Casual Loose T Shirts",
                'description' => $description,
                'meta_description' => "Women's Waffle Knit Blouse Ballon Long Sleeve Lace Tops Casual Loose T Shirts",
                'overview' => $productOverview,
                'selling' => 100,
                'purchased' => 64,
                'offered' => 84,
                'bundle_deal_id' => 1,
                'tax_rule_id' => 1,
                'video' => 'product-4-0.mp4',
                'video_thumb' => 'product-video-4-3.webp',
                'rating' => 4,
                'review_count' => 2,
                'shipping_rule_id' => 1,
                'brand_id' => 9442200,
                'category_id' => 63082111,
                'subcategory_id' => 64273111,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 1,
                'refundable' => 1,
                'image' => 'product-4-1.webp'
            ],


            [
                'id' => 88630115,
                'title' => "Women's Ruffle Sleeve Tops Summer Casual Blouse Crew Neck Solid Cute Tunic Shirt",
                'meta_title' => "Women's Ruffle Sleeve Tops Summer Casual Blouse Crew Neck Solid Cute Tunic Shirt",
                'description' => $description,
                'meta_description' => "Women's Ruffle Sleeve Tops Summer Casual Blouse Crew Neck Solid Cute Tunic Shirt",
                'overview' => $productOverview,
                'selling' => 100,
                'purchased' => 65,
                'bundle_deal_id' => 1,
                'offered' => 85,
                'tax_rule_id' => 1,
                'badge' => 'Featured',
                'rating' => 5,
                'review_count' => 1,
                'shipping_rule_id' => 1,
                'brand_id' => 9442200,
                'category_id' => 63082111,
                'subcategory_id' => 64273111,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 1,
                'refundable' => 1,
                'image' => 'product-5-1.webp'
            ],


            [
                'id' => 88630116,
                'title' => "Women's Floral Tunic Tops Casual Blouse V Neck Short Sleeve Buttons Up T-Shirts",
                'meta_title' => "Women's Floral Tunic Tops Casual Blouse V Neck Short Sleeve Buttons Up T-Shirts",
                'description' => $description,
                'meta_description' => "Women's Floral Tunic Tops Casual Blouse V Neck Short Sleeve Buttons Up T-Shirts",
                'overview' => $productOverview,
                'selling' => 100,
                'purchased' => 66,
                'offered' => 86,
                'tax_rule_id' => 1,
                'rating' => 3,
                'review_count' => 1,
                'bundle_deal_id' => 1,
                'shipping_rule_id' => 1,
                'brand_id' => 9442201,
                'category_id' => 63082111,
                'subcategory_id' => 64273111,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 1,
                'refundable' => 1,
                'image' => 'product-6-1.webp'
            ],

            [
                'id' => 88630117,
                'title' => "Andongnywell Women's Casual Tops Leopard Print T-Shirt Long Sleeve Soft Stretchy Camouflage Blouse Shirts",
                'meta_title' => "Andongnywell Women's Casual Tops Leopard Print T-Shirt Long Sleeve Soft Stretchy Camouflage Blouse Shirts",
                'description' => $description,
                'meta_description' => "Andongnywell Women's Casual Tops Leopard Print T-Shirt Long Sleeve Soft Stretchy Camouflage Blouse Shirts",
                'overview' => $productOverview,
                'selling' => 100,
                'purchased' => 67,
                'offered' => 87,
                'tax_rule_id' => 1,
                'rating' => 3.5,
                'bundle_deal_id' => 1,
                'review_count' => 2,
                'shipping_rule_id' => 1,
                'brand_id' => 9442201,
                'category_id' => 63082111,
                'subcategory_id' => 64273111,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 1,
                'refundable' => 1,
                'image' => 'product-7-1.webp'
            ],



            [
                'id' => 88630118,
                'title' => "Amoretu Women Summer Tunic Dress V Neck Casual Loose Flowy Swing Shift Dresses",
                'meta_title' => "Amoretu Women Summer Tunic Dress V Neck Casual Loose Flowy Swing Shift Dresses",
                'description' => $description,
                'meta_description' => "Amoretu Women Summer Tunic Dress V Neck Casual Loose Flowy Swing Shift Dresses",
                'overview' => $productOverview,
                'selling' => 100,
                'purchased' => 68,
                'offered' => 88,
                'tax_rule_id' => 1,
                'rating' => 5,
                'bundle_deal_id' => 1,
                'review_count' => 3,
                'shipping_rule_id' => 1,
                'brand_id' => 9442201,
                'category_id' => 63082111,
                'subcategory_id' => 73294112,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 1,
                'refundable' => 1,
                'image' => 'product-8-1.webp'
            ],

            [
                'id' => 88630119,
                'title' => "Simple Flavor Women's Floral Vintage Dress Elegant Midi Evening Dress 3/4 Sleeves",
                'meta_title' => "Simple Flavor Women's Floral Vintage Dress Elegant Midi Evening Dress 3/4 Sleeves",
                'description' => $description,
                'meta_description' => "Simple Flavor Women's Floral Vintage Dress Elegant Midi Evening Dress 3/4 Sleeves",
                'overview' => $productOverview,
                'selling' => 100,
                'purchased' => 69,
                'offered' => 89,
                'tax_rule_id' => 1,
                'bundle_deal_id' => 1,
                'rating' => 4.4,
                'review_count' => 4,
                'shipping_rule_id' => 1,
                'brand_id' => 9442201,
                'category_id' => 63082111,
                'subcategory_id' => 73294112,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 1,
                'refundable' => 1,
                'image' => 'product-9-1.webp'
            ],
            [
                'id' => 88630120,
                'title' => "BTFBM Women Casual Fall Dresses V Neck Tie Neck Long Sleeve High Waist Dot Ruffle Tiered A Line Solid Swing Mini Dress",
                'meta_title' => "BTFBM Women Casual Fall Dresses V Neck Tie Neck Long Sleeve High Waist Dot Ruffle Tiered A Line Solid Swing Mini Dress",
                'description' => $description,
                'meta_description' => "BTFBM Women Casual Fall Dresses V Neck Tie Neck Long Sleeve High Waist Dot Ruffle Tiered A Line Solid Swing Mini Dress",
                'overview' => $productOverview,
                'selling' => 100,
                'purchased' => 70,
                'offered' => 90,
                'tax_rule_id' => 1,
                'rating' => 4.2,
                'bundle_deal_id' => 1,
                'review_count' => 5,
                'shipping_rule_id' => 1,
                'brand_id' => 9442201,
                'category_id' => 63082111,
                'subcategory_id' => 73294112,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 1,
                'refundable' => 1,
                'image' => 'product-10-1.webp'
            ],
            [
                'id' => 88630121,
                'title' => "LYANER Women's Tunic Round Neck Ruffle Loose Flowy Babydoll Swing Mini Dresses",
                'meta_title' => "LYANER Women's Tunic Round Neck Ruffle Loose Flowy Babydoll Swing Mini Dresses",
                'description' => $description,
                 'meta_description' => "LYANER Women's Tunic Round Neck Ruffle Loose Flowy Babydoll Swing Mini Dresses",
                'overview' => $productOverview,
                'selling' => 100,
                'purchased' => 71,
                'offered' => 91,
                'tax_rule_id' => 1,
                'rating' => 4,
                'bundle_deal_id' => 1,
                'review_count' => 4,
                'shipping_rule_id' => 1,
                'badge' => 'New',
                'brand_id' => 9442201,
                'category_id' => 63082111,
                'subcategory_id' => 73294112,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 1,
                'refundable' => 1,
                'image' => 'product-11-1.webp'
            ],

            [
                'id' => 88630122,
                'title' => "PUMA Kids' 6 Pack Low Cut Socks",
                'meta_title' => "PUMA Kids' 6 Pack Low Cut Socks",
                'description' => $description,
                'meta_description' => "PUMA Kids' 6 Pack Low Cut Socks",
                'overview' => $productOverview,
                'selling' => 100,
                'purchased' => 72,
                'offered' => 92,
                'tax_rule_id' => 1,
                'bundle_deal_id' => 1,
                'rating' => 4.8,
                'review_count' => 3,
                'shipping_rule_id' => 1,
                'brand_id' => 9442202,
                'category_id' => 63082111,
                'subcategory_id' => 96323113,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 1,
                'refundable' => 1,
                'image' => 'product-12-1.webp'
            ],
            [
                'id' => 88630123,
                'title' => "3 Pairs Triple Stripe Over the Knee Socks Extra Long Opaque Thigh High Stockings",
                'meta_title' => "3 Pairs Triple Stripe Over the Knee Socks Extra Long Opaque Thigh High Stockings",
                'description' => $description,
                'meta_description' => "3 Pairs Triple Stripe Over the Knee Socks Extra Long Opaque Thigh High Stockings",
                'overview' => $productOverview,
                'selling' => 100,
                'purchased' => 73,
                'offered' => 93,
                'tax_rule_id' => 1,
                'rating' => 5,
                'review_count' => 2,
                'shipping_rule_id' => 1,
                'bundle_deal_id' => 1,
                'brand_id' => 9442202,
                'category_id' => 63082111,
                'subcategory_id' => 96323113,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 1,
                'refundable' => 1,
                'image' => 'product-13-1.webp'
            ],

            [
                'id' => 88630124,
                'title' => "4 Pack Leggings with Pockets for Women,High Waist Tummy Control Workout Yoga Pants",
                'meta_title' => "4 Pack Leggings with Pockets for Women,High Waist Tummy Control Workout Yoga Pants",
                'description' => $description,
                 'meta_description' => "4 Pack Leggings with Pockets for Women,High Waist Tummy Control Workout Yoga Pants",
                'overview' => $productOverview,
                'selling' => 100,
                'purchased' => 74,
                'offered' => 94,
                'tax_rule_id' => 1,
                'rating' => 4,
                'badge' => 'Trending',
                'bundle_deal_id' => 1,
                'review_count' => 1,
                'shipping_rule_id' => 1,
                'brand_id' => 9442202,
                'category_id' => 63082111,
                'subcategory_id' => 96765114,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 1,
                'refundable' => 1,
                'image' => 'product-14-1.webp'
            ],

            [
                'id' => 88630125,
                'title' => "Women's Regrowth Kit Plus: Shampoo, Conditioner, 2% Minoxidil, Leave-In Foamer. Anti Hair Loss and Thinning Hair Solution for Women, 1 Month",
                'meta_title' => "Women's Regrowth Kit Plus: Shampoo, Conditioner, 2% Minoxidil, Leave-In Foamer. Anti Hair Loss and Thinning Hair Solution for Women, 1 Month",
                'description' => $description,
                 'meta_description' => "Women's Regrowth Kit Plus: Shampoo, Conditioner, 2% Minoxidil, Leave-In Foamer. Anti Hair Loss and Thinning Hair Solution for Women, 1 Month",
                'overview' => $productOverview,
                'selling' => 100,
                'purchased' => 75,
                'offered' => 95,
                'tax_rule_id' => 1,
                'bundle_deal_id' => 1,
                'rating' => 4,
                'review_count' => 1,
                'shipping_rule_id' => 1,
                'brand_id' => 9442202,
                'category_id' => 63082112,
                'subcategory_id' => 97373115,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 1,
                'refundable' => 1,
                'image' => 'product-15-1.webp'
            ],


            [
                'id' => 88630126,
                'title' => "Nutrafol Women Hair Growth For Thicker, Stronger Hair (4 Capsules Per Day) (1 Month Supply)",
                'meta_title' => "Nutrafol Women Hair Growth For Thicker, Stronger Hair (4 Capsules Per Day) (1 Month Supply)",
                'description' => $description,
                'meta_description' => "Nutrafol Women Hair Growth For Thicker, Stronger Hair (4 Capsules Per Day) (1 Month Supply)",
                'overview' => $productOverview,
                'selling' => 100,
                'purchased' => 76,
                'offered' => 96,
                'bundle_deal_id' => 1,
                'tax_rule_id' => 1,
                'rating' => 4.5,
                'review_count' => 2,
                'badge' => 'New',
                'shipping_rule_id' => 1,
                'brand_id' => 9442202,
                'category_id' => 63082112,
                'subcategory_id' => 97373115,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 1,
                'refundable' => 1,
                'image' => 'product-16-1.webp'
            ],

            [
                'id' => 88630127,
                'title' => "Vagisil Anti-Itch Medicated Feminine Vaginal Wipes, Maximum Strength, Instant Relief, Pack of 3 - 60 Wipes Total (Packaging may vary)",
                'meta_title' => "Vagisil Anti-Itch Medicated Feminine Vaginal Wipes, Maximum Strength, Instant Relief, Pack of 3 - 60 Wipes Total (Packaging may vary)",
                'description' => $description,
                 'meta_description' => "Vagisil Anti-Itch Medicated Feminine Vaginal Wipes, Maximum Strength, Instant Relief, Pack of 3 - 60 Wipes Total (Packaging may vary)",
                'overview' => $productOverview,
                'selling' => 100,
                'purchased' => 77,
                'offered' => 97,
                'tax_rule_id' => 1,
                'rating' => 4,
                'review_count' => 3,
                'bundle_deal_id' => 1,
                'shipping_rule_id' => 1,
                'brand_id' => 9442203,
                'category_id' => 63082112,
                'subcategory_id' => 97373116,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 1,
                'refundable' => 1,
                'image' => 'product-17-1.webp'
            ],

            [
                'id' => 88630128,
                'title' => "Jet Set Hydration Kit, Travel Friendly Skincare Set, Cleanser, Balm, Moisturizer, Eye Cream & Night Cream",
                'meta_title' => "Jet Set Hydration Kit, Travel Friendly Skincare Set, Cleanser, Balm, Moisturizer, Eye Cream & Night Cream",
                'description' => $description,
                 'meta_description' => "Jet Set Hydration Kit, Travel Friendly Skincare Set, Cleanser, Balm, Moisturizer, Eye Cream & Night Cream",
                'overview' => $productOverview,
                'selling' => 100,
                'purchased' => 78,
                'offered' => 98,
                'tax_rule_id' => 1,
                'badge' => 'New',
                'rating' => 3.8,
                'bundle_deal_id' => 1,
                'review_count' => 4,
                'shipping_rule_id' => 1,
                'brand_id' => 9442203,
                'category_id' => 63082112,
                'subcategory_id' => 97373117,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 1,
                'refundable' => 1,
                'image' => 'product-18-1.webp'
            ],

            [
                'id' => 88630129,
                'title' => "Magic | Skin-renewing Microdermabrasion Scrub | Straight-from-the-Spa | Tightens Pores & Brightens Skin | Paraben Free, Cruelty Free",
                'meta_title' => "Magic | Skin-renewing Microdermabrasion Scrub | Straight-from-the-Spa | Tightens Pores & Brightens Skin | Paraben Free, Cruelty Free",
                'description' => $description,
                 'meta_description' => "Magic | Skin-renewing Microdermabrasion Scrub | Straight-from-the-Spa | Tightens Pores & Brightens Skin | Paraben Free, Cruelty Free",
                'overview' => $productOverview,
                'selling' => 100,
                'purchased' => 79,
                'offered' => 99,
                'tax_rule_id' => 1,
                'rating' => 5,
                'review_count' => 5,
                'bundle_deal_id' => 1,
                'shipping_rule_id' => 1,
                'brand_id' => 9442203,
                'category_id' => 63082112,
                'subcategory_id' => 97373117,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 1,
                'refundable' => 1,
                'image' => 'product-19-1.webp'
            ],

            [
                'id' => 88630130,
                'title' => "'Daily Hydrating' Duo Skin Care Starter Kit (Bio-Complex Moisturizer and Ferulic Acid + Vitamins C & E) Helps with Fine Lines, Hydration, and Uneven Skin Tone",
                'meta_title' => "'Daily Hydrating' Duo Skin Care Starter Kit (Bio-Complex Moisturizer and Ferulic Acid + Vitamins C & E) Helps with Fine Lines, Hydration, and Uneven Skin Tone",
                'description' => $description,
                'meta_description' => "'Daily Hydrating' Duo Skin Care Starter Kit (Bio-Complex Moisturizer and Ferulic Acid + Vitamins C & E) Helps with Fine Lines, Hydration, and Uneven Skin Tone",
                'overview' => $productOverview,
                'selling' => 100,
                'purchased' => 80,
                'offered' => 0,
                'tax_rule_id' => 1,
                'badge' => 'New',
                'rating' => 5,
                'review_count' => 4,
                'bundle_deal_id' => 1,
                'shipping_rule_id' => 1,
                'brand_id' => 9442203,
                'category_id' => 63082112,
                'subcategory_id' => 97373117,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 1,
                'refundable' => 1,
                'image' => 'product-20-1.webp'
            ],
            [
                'id' => 88630131,
                'title' => "Image Skincare The Max Stem Cell Facial Cleanser, 4 Fl Oz",
                'meta_title' => "Image Skincare The Max Stem Cell Facial Cleanser, 4 Fl Oz",
                'description' => $description,
                 'meta_description' => "Image Skincare The Max Stem Cell Facial Cleanser, 4 Fl Oz",
                'overview' => $productOverview,
                'selling' => 101,
                'purchased' => 81,
                'offered' => 0,
                'tax_rule_id' => 1,
                'rating' => 4.3,
                'bundle_deal_id' => 1,
                'review_count' => 3,
                'shipping_rule_id' => 1,
                'brand_id' => 9442203,
                'category_id' => 63082112,
                'subcategory_id' => 97373117,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 1,
                'refundable' => 1,
                'image' => 'product-21-1.webp'
            ],

            [
                'id' => 88630132,
                'title' => "Sling Bag Canvas Crossbody Backpack Shoulder Travel Bag Casual Daypacks",
                'meta_title' => "Sling Bag Canvas Crossbody Backpack Shoulder Travel Bag Casual Daypacks",
                'description' => $description,
                'meta_description' => "Sling Bag Canvas Crossbody Backpack Shoulder Travel Bag Casual Daypacks",
                'overview' => $productOverview,
                'selling' => 102,
                'purchased' => 82,
                'offered' => 0,
                'bundle_deal_id' => 1,
                'tax_rule_id' => 1,
                'rating' => 5,
                'review_count' => 2,
                'shipping_rule_id' => 1,
                'brand_id' => 9442204,
                'category_id' => 72531155,
                'subcategory_id' => 73294118,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 1,
                'refundable' => 1,
                'image' => 'product-22-1.webp'
            ],

            [
                'id' => 88630133,
                'title' => "Nautica Diver Nylon Small Womens Crossbody Bag Purse with Adjustable Shoulder Strap",
                'meta_title' => "Nautica Diver Nylon Small Womens Crossbody Bag Purse with Adjustable Shoulder Strap",
                'description' => $description,
                'meta_description' => "Nautica Diver Nylon Small Womens Crossbody Bag Purse with Adjustable Shoulder Strap",
                'overview' => $productOverview,
                'selling' => 150,
                'purchased' => 83,
                'offered' => 103,
                'tax_rule_id' => 1,
                'bundle_deal_id' => 1,
                'rating' => 5,
                'review_count' => 1,
                'shipping_rule_id' => 1,
                'brand_id' => 9442204,
                'category_id' => 72531155,
                'subcategory_id' => 96323119,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 1,
                'refundable' => 1,
                'image' => 'product-23-1.webp'
            ],

            [
                'id' => 88630134,
                'title' => "Anna by Anuschka Satchel Handbag | Genuine Leather",
                'meta_title' => "Anna by Anuschka Satchel Handbag | Genuine Leather",
                'description' => $description,
                'meta_description' => "Anna by Anuschka Satchel Handbag | Genuine Leather",
                'overview' => $productOverview,
                'selling' => 170,
                'purchased' => 84,
                'offered' => 104,
                'tax_rule_id' => 1,
                'bundle_deal_id' => 1,
                'rating' => 5,
                'review_count' => 1,
                'shipping_rule_id' => 1,
                'brand_id' => 9442204,
                'category_id' => 72531155,
                'subcategory_id' => 96765110,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 1,
                'refundable' => 1,
                'image' => 'product-24-1.webp'
            ],

            [
                'id' => 88630135,
                'title' => "Self Retractable ID Badge Holder Key Reel, Heavy Duty Metal Body, 30 Inches Steel Cord, Carabiner Key Chain Keychain with Belt Clip, Hold Up to 15 Keys and Tools",
                'meta_title' => "Self Retractable ID Badge Holder Key Reel, Heavy Duty Metal Body, 30 Inches Steel Cord, Carabiner Key Chain Keychain with Belt Clip, Hold Up to 15 Keys and Tools",
                'description' => $description,
                 'meta_description' => "Self Retractable ID Badge Holder Key Reel, Heavy Duty Metal Body, 30 Inches Steel Cord, Carabiner Key Chain Keychain with Belt Clip, Hold Up to 15 Keys and Tools",
                'overview' => $productOverview,
                'selling' => 200,
                'purchased' => 85,
                'offered' => 105,
                'tax_rule_id' => 1,
                'rating' => 3.5,
                'bundle_deal_id' => 1,
                'review_count' => 2,
                'shipping_rule_id' => 1,
                'brand_id' => 9442204,
                'category_id' => 72531153,
                'subcategory_id' => 97373121,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 1,
                'refundable' => 1,
                'image' => 'product-25-1.webp'
            ],

            [
                'id' => 88630136,
                'title' => "Airanes Anti Fog Safety Glasses for Women Men",
                'meta_title' => "Airanes Anti Fog Safety Glasses for Women Men",
                'description' => $description,
                'meta_description' => "Airanes Anti Fog Safety Glasses for Women Men",
                'overview' => $productOverview,
                'selling' => 170,
                'purchased' => 86,
                'offered' => 106,
                'bundle_deal_id' => 1,
                'tax_rule_id' => 1,
                'rating' => 2.7,
                'review_count' => 3,
                'shipping_rule_id' => 1,
                'brand_id' => 9442204,
                'category_id' => 72531153,
                'subcategory_id' => 99585122,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 1,
                'refundable' => 1,
                'image' => 'product-26-1.webp'
            ],

            [
                'id' => 88630137,
                'title' => "Legendary Whitetails Men's Journeyman Shirt Jacket",
                'meta_title' => "Legendary Whitetails Men's Journeyman Shirt Jacket",
                'description' => $description,
                'meta_description' => "Legendary Whitetails Men's Journeyman Shirt Jacket",
                'overview' => $productOverview,
                'selling' => 160,
                'purchased' => 87,
                'offered' => 107,
                'bundle_deal_id' => 1,
                'tax_rule_id' => 1,
                'rating' => 4.5,
                'review_count' => 4,
                'shipping_rule_id' => 1,
                'brand_id' => 9442205,
                'category_id' => 72531153,
                'subcategory_id' => 99585122,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 1,
                'refundable' => 1,
                'image' => 'product-27-1.webp'
            ],

            [
                'id' => 88630138,
                'title' => "Wrangler Men's Cowboy Cut Western Long Sleeve Snap Work Shirt Firm Finish",
                'meta_title' => "Wrangler Men's Cowboy Cut Western Long Sleeve Snap Work Shirt Firm Finish",
                'meta_description' => "Wrangler Men's Cowboy Cut Western Long Sleeve Snap Work Shirt Firm Finish",
                'description' => $description,
                'overview' => $productOverview,
                'selling' => 108,
                'purchased' => 88,
                'offered' => 0,
                'tax_rule_id' => 1,
                'bundle_deal_id' => 1,
                'rating' => 4.6,
                'review_count' => 5,
                'shipping_rule_id' => 1,
                'brand_id' => 9442205,
                'category_id' => 61952111,
                'subcategory_id' => 97373124,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 1,
                'refundable' => 1,
                'image' => 'product-28-1.webp'
            ],


            [
                'id' => 88630139,
                'title' => "Dockers Men's Long Sleeve Signature Comfort Flex Shirt",
                'meta_title' => "Dockers Men's Long Sleeve Signature Comfort Flex Shirt",
                'meta_description' => "Dockers Men's Long Sleeve Signature Comfort Flex Shirt",
                'description' => $description,
                'overview' => $productOverview,
                'selling' => 109,
                'purchased' => 89,
                'offered' => 0,
                'tax_rule_id' => 1,
                'rating' => 4,
                'badge' => 'Trending',
                'bundle_deal_id' => 1,
                'review_count' => 4,
                'shipping_rule_id' => 1,
                'brand_id' => 9442205,
                'category_id' => 61952111,
                'subcategory_id' => 97373124,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 1,
                'refundable' => 1,
                'image' => 'product-29-1.webp'
            ],

            [
                'id' => 88630140,
                'title' => "Goodthreads Men's Slim-Fit Long-Sleeve Plaid Oxford Shirt",
                'meta_title' => "Goodthreads Men's Slim-Fit Long-Sleeve Plaid Oxford Shirt",
                'meta_description' => "Goodthreads Men's Slim-Fit Long-Sleeve Plaid Oxford Shirt",
                'description' => $description,
                'overview' => $productOverview,
                'selling' => 110,
                'purchased' => 90,
                'offered' => 0,
                'tax_rule_id' => 1,
                'rating' => 3.3,
                'review_count' => 3,
                'shipping_rule_id' => 1,
                'brand_id' => 9442205,
                'category_id' => 61952111,
                'subcategory_id' => 97373124,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 1,
                'refundable' => 1,
                'image' => 'product-30-1.webp'
            ],

            [
                'id' => 88630141,
                'title' => "Dickies Men's Sanded Duck Sherpa Lined Hooded Jacket",
                'meta_title' => "Dickies Men's Sanded Duck Sherpa Lined Hooded Jacket",
                'meta_description' => "Dickies Men's Sanded Duck Sherpa Lined Hooded Jacket",
                'description' => $description,
                 'overview' => $productOverview,
                'selling' => 111,
                'purchased' => 91,
                'offered' => 0,
                'tax_rule_id' => 1,
                'badge' => 'Trending',
                'rating' => 5,
                'review_count' => 2,
                'shipping_rule_id' => 1,
                'brand_id' => 9442205,
                'category_id' => 61952111,
                'subcategory_id' => 99585125,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 1,
                'refundable' => 1,
                'image' => 'product-31-1.webp'
            ],
            [
                'id' => 88630142,
                'title' => "Carhartt Men's Thermal Lined Duck Active Jacket J131 (Regular and Big & Tall Sizes)",
                'meta_title' => "Carhartt Men's Thermal Lined Duck Active Jacket J131 (Regular and Big & Tall Sizes)",
                'meta_description' => "Carhartt Men's Thermal Lined Duck Active Jacket J131 (Regular and Big & Tall Sizes)",
                'description' => $description,
                'overview' => $productOverview,
                'selling' => 190,
                'purchased' => 92,
                'offered' => 112,
                'tax_rule_id' => 1,
                'rating' => 3.5,
                'review_count' => 2,
                'shipping_rule_id' => 1,
                'brand_id' => 9442205,
                'category_id' => 61952111,
                'subcategory_id' => 99585125,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 1,
                'refundable' => 1,
                'image' => 'product-32-1.webp'
            ],
            [
                'id' => 88630143,
                'title' => "Columbia Men's Powder Lite Jacket",
                'meta_title' => "Columbia Men's Powder Lite Jacket",
                'meta_description' => "Columbia Men's Powder Lite Jacket",
                'description' => $description,
                 'overview' => $productOverview,
                'selling' => 200,
                'purchased' => 93,
                'offered' => 113,
                'tax_rule_id' => 1,
                'rating' => 3,
                'review_count' => 1,
                'shipping_rule_id' => 1,
                'brand_id' => 9442206,
                'category_id' => 61952111,
                'subcategory_id' => 99585125,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 1,
                'refundable' => 1,
                'image' => 'product-33-1.webp'
            ],

            [
                'id' => 88630144,
                'title' => "Jack Wolfskin Women's Turbulence Jacket",
                'meta_title' => "Jack Wolfskin Women's Turbulence Jacket",
                'meta_description' => "Jack Wolfskin Women's Turbulence Jacket",
                'description' => $description,
                'overview' => $productOverview,
                'selling' => 114,
                'purchased' => 94,
                'offered' => 0,
                'tax_rule_id' => 1,
                'rating' => 5,
                'badge' => 'Trending',
                'review_count' => 1,
                'shipping_rule_id' => 1,
                'brand_id' => 9442206,
                'category_id' => 61952111,
                'subcategory_id' => 99585125,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 1,
                'refundable' => 1,
                'image' => 'product-34-1.webp'
            ],


            [
                'id' => 88630145,
                'title' => "Men's Survivor Iv Relaxed Fit Cargo Pant-Reg and Big and Tall Sizes",
                'meta_title' => "Men's Survivor Iv Relaxed Fit Cargo Pant-Reg and Big and Tall Sizes",
                'meta_description' => "Men's Survivor Iv Relaxed Fit Cargo Pant-Reg and Big and Tall Sizes",
                'description' => $description,
                'overview' => $productOverview,
                'selling' => 115,
                'purchased' => 95,
                'offered' => 0,
                'tax_rule_id' => 1,
                'rating' => 3,
                'review_count' => 2,
                'shipping_rule_id' => 1,
                'brand_id' => 9442206,
                'category_id' => 61952111,
                'subcategory_id' => 96765126,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 1,
                'refundable' => 1,
                'image' => 'product-35-1.webp'
            ],

            [
                'id' => 88630146,
                'title' => "Fossil Men's Leather Trifold with Id Window Wallet",
                'meta_title' => "Fossil Men's Leather Trifold with Id Window Wallet",
                'meta_description' => "Fossil Men's Leather Trifold with Id Window Wallet",
                'description' => $description,
                'overview' => $productOverview,
                'selling' => 140,
                'purchased' => 96,
                'offered' => 116,
                'tax_rule_id' => 1,
                'rating' => 4.7,
                'badge' => 'Trending',
                'review_count' => 3,
                'shipping_rule_id' => 1,
                'brand_id' => 9442206,
                'category_id' => 61952111,
                'subcategory_id' => 99585127,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 1,
                'refundable' => 1,
                'image' => 'product-36-1.webp'
            ],

            [
                'id' => 88630147,
                'title' => "Carhartt Legacy Deluxe Work Backpack with 17-Inch Laptop Compartment, Carhartt Brown",
                'meta_title' => "Carhartt Legacy Deluxe Work Backpack with 17-Inch Laptop Compartment, Carhartt Brown",
                'meta_description' => "Carhartt Legacy Deluxe Work Backpack with 17-Inch Laptop Compartment, Carhartt Brown",
                'description' => $description,
                'overview' => $productOverview,
                'selling' => 170,
                'purchased' => 97,
                'offered' => 117,
                'tax_rule_id' => 1,
                'rating' => 4.5,
                'review_count' => 4,
                'shipping_rule_id' => 1,
                'brand_id' => 9442206,
                'category_id' => 61952111,
                'subcategory_id' => 99585128,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 1,
                'refundable' => 1,
                'image' => 'product-37-1.webp'
            ],

            [
                'id' => 88630148,
                'title' => "Herschel Classic Backpack, Ash Rose, Mid-Volume 18.0L",
                'meta_title' => "Herschel Classic Backpack, Ash Rose, Mid-Volume 18.0L",
                'meta_description' => "Herschel Classic Backpack, Ash Rose, Mid-Volume 18.0L",
                'description' => $description,
                'overview' => $productOverview,
                'selling' => 118,
                'purchased' => 98,
                'offered' => 0,
                'tax_rule_id' => 1,
                'rating' => 4,
                'badge' => 'Trending',
                'review_count' => 5,
                'shipping_rule_id' => 1,
                'brand_id' => 9442206,
                'category_id' => 61952111,
                'subcategory_id' => 99585128,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 1,
                'refundable' => 1,
                'image' => 'product-38-1.webp'
            ],

            [
                'id' => 88630149,
                'title' => "Vera Bradley Women's Cotton Campus Backpack",
                'meta_title' => "Vera Bradley Women's Cotton Campus Backpack",
                'meta_description' => "Vera Bradley Women's Cotton Campus Backpack",
                'description' => $description,
                'overview' => $productOverview,
                'selling' => 119,
                'purchased' => 98,
                'offered' => 0,
                'tax_rule_id' => 1,
                'rating' => 4.5,
                'review_count' => 4,
                'shipping_rule_id' => 1,
                'brand_id' => 9442207,
                'category_id' => 61952111,
                'subcategory_id' => 99585128,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 1,
                'refundable' => 1,
                'image' => 'product-39-1.webp'
            ],

            [
                'id' => 88630150,
                'title' => "EaseGave 17.3 Inch Briefcase for Women,Multi-Pocket Work Bag Spacious Office Computer Bags Laptop Messenger Bag for Work Business Travel,coffee-17.3 Inch",
                'meta_title' => "EaseGave 17.3 Inch Briefcase for Women,Multi-Pocket Work Bag Spacious Office Computer Bags Laptop Messenger Bag for Work Business Travel,coffee-17.3 Inch",
                'meta_description' => "EaseGave 17.3 Inch Briefcase for Women,Multi-Pocket Work Bag Spacious Office Computer Bags Laptop Messenger Bag for Work Business Travel,coffee-17.3 Inch",
                'description' => $description,
                'overview' => $productOverview,
                'selling' => 200,
                'purchased' => 100,
                'offered' => 120,
                'tax_rule_id' => 1,
                'rating' => 4.3,
                'review_count' => 3,
                'shipping_rule_id' => 1,
                'brand_id' => 9442207,
                'category_id' => 96522110,
                'subcategory_id' => 99585130,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 1,
                'refundable' => 1,
                'image' => 'product-40-1.webp'
            ],
            [
                'id' => 88630151,
                'title' => "Eco Friendly Laptop Backpack: Made from recycled PET bottles",
                'meta_title' => "Eco Friendly Laptop Backpack: Made from recycled PET bottles",
                'meta_description' => "Eco Friendly Laptop Backpack: Made from recycled PET bottles",
                'description' => $description,
                'overview' => $productOverview,
                'selling' => 110,
                'purchased' => 90,
                'offered' => 100,
                'tax_rule_id' => 1,
                'rating' => 0,
                'review_count' => 0,
                'shipping_rule_id' => 1,
                'brand_id' => 9442207,
                'category_id' => 96522110,
                'subcategory_id' => 99585130,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 1,
                'refundable' => 1,
                'image' => 'product-41-1.webp'
            ],

            [
                'id' => 88630152,
                'title' => "Solo New York Region Laptop Backpack, Grey",
                'meta_title' => "Solo New York Region Laptop Backpack, Grey",
                'meta_description' => "Solo New York Region Laptop Backpack, Grey",
                'description' => $description,
                 'overview' => $productOverview,
                'selling' => 110,
                'purchased' => 90,
                'offered' => 100,
                'tax_rule_id' => 1,
                'rating' => 0,
                'review_count' => 0,
                'shipping_rule_id' => 1,
                'brand_id' => 9442207,
                'category_id' => 72533143,
                'subcategory_id' => 99585133,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 1,
                'refundable' => 1,
                'image' => 'product-42-1.webp'
            ],

            [
                'id' => 88630153,
                'title' => "Laptop Backpack for Women Work Backpack Purse Travel Bookbag Nurse School Bag",
                'meta_title' => "Laptop Backpack for Women Work Backpack Purse Travel Bookbag Nurse School Bag",
                'meta_description' => "Laptop Backpack for Women Work Backpack Purse Travel Bookbag Nurse School Bag",
                'description' => $description,
                 'overview' => $productOverview,
                'selling' => 110,
                'purchased' => 90,
                'offered' => 100,
                'tax_rule_id' => 1,
                'rating' => 0,
                'review_count' => 0,
                'badge' => 'Featured',
                'shipping_rule_id' => 1,
                'brand_id' => 9442207,
                'category_id' => 72533143,
                'subcategory_id' => 99585133,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 1,
                'refundable' => 1,
                'image' => 'product-43-1.webp'
            ],


            [
                'id' => 88630154,
                'title' => "Neutrogena Makeup Remover Facial Cleansing Towelette Singles, Daily Face Wipes Remove Dirt, Oil, Makeup & Waterproof Mascara, Gentle, Individually Wrapped, 100% Plant-Based Fibers, 20 ct",
                'meta_title' => "Neutrogena Makeup Remover Facial Cleansing Towelette Singles, Daily Face Wipes Remove Dirt, Oil, Makeup & Waterproof Mascara, Gentle, Individually Wrapped, 100% Plant-Based Fibers, 20 ct",
                'meta_description' => "Neutrogena Makeup Remover Facial Cleansing Towelette Singles, Daily Face Wipes Remove Dirt, Oil, Makeup & Waterproof Mascara, Gentle, Individually Wrapped, 100% Plant-Based Fibers, 20 ct",
                'description' => $description,
                'overview' => $productOverview,
                'selling' => 110,
                'purchased' => 90,
                'offered' => 100,
                'tax_rule_id' => 1,
                'rating' => 0,
                'review_count' => 0,
                'shipping_rule_id' => 1,
                'brand_id' => 9442207,
                'category_id' => 72533143,
                'subcategory_id' => 99585134,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 1,
                'refundable' => 1,
                'image' => 'product-44-1.webp'
            ],
            [
                'id' => 88630155,
                'title' => "Anker Soundcore Life Q20 Hybrid Active Noise Cancelling Headphones, Wireless Over Ear Bluetooth Headphones, 40H Playtime, Hi-Res Audio, Deep Bass, Memory Foam Ear Cups, for Travel, Home Office",
                'meta_title' => "Anker Soundcore Life Q20 Hybrid Active Noise Cancelling Headphones, Wireless Over Ear Bluetooth Headphones, 40H Playtime, Hi-Res Audio, Deep Bass, Memory Foam Ear Cups, for Travel, Home Office",
                 'meta_description' => "Anker Soundcore Life Q20 Hybrid Active Noise Cancelling Headphones, Wireless Over Ear Bluetooth Headphones, 40H Playtime, Hi-Res Audio, Deep Bass, Memory Foam Ear Cups, for Travel, Home Office",
                'description' => $description,
                'overview' => $productOverview,
                'selling' => 110,
                'purchased' => 90,
                'offered' => 100,
                'tax_rule_id' => 1,
                'rating' => 0,
                'review_count' => 0,
                'shipping_rule_id' => 1,
                'brand_id' => 9442207,
                'category_id' => 72533143,
                'subcategory_id' => 99585134,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 1,
                'refundable' => 1,
                'image' => 'product-45-1.webp'
            ],
            [
                'id' => 88630156,
                'title' => "Mama Mio Pregnancy Essentials Kit",
                'meta_title' => "Mama Mio Pregnancy Essentials Kit",
                'meta_description' => "Mama Mio Pregnancy Essentials Kit",
                'description' => $description,
                 'overview' => $productOverview,
                'selling' => 110,
                'purchased' => 90,
                'offered' => 100,
                'tax_rule_id' => 1,
                'badge' => 'Featured',
                'rating' => 0,
                'review_count' => 0,
                'shipping_rule_id' => 1,
                'brand_id' => 9442208,
                'category_id' => 96674111,
                'subcategory_id' => 99585136,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 1,
                'refundable' => 1,
                'image' => 'product-46-1.webp'
            ],

            [
                'id' => 88630157,
                'title' => "Milky Chic Gift Box for New Moms- 10 Unique Postpartum Personal Care Items for Mothers-Mommy's Pampering Surprise Basket",
                'meta_title' => "Milky Chic Gift Box for New Moms- 10 Unique Postpartum Personal Care Items for Mothers-Mommy's Pampering Surprise Basket",
                'meta_description' => "Milky Chic Gift Box for New Moms- 10 Unique Postpartum Personal Care Items for Mothers-Mommy's Pampering Surprise Basket",
                'description' => $description,
                'overview' => $productOverview,
                'selling' => 110,
                'purchased' => 90,
                'offered' => 100,
                'tax_rule_id' => 1,
                'rating' => 0,
                'review_count' => 0,
                'shipping_rule_id' => 1,
                'brand_id' => 9442208,
                'category_id' => 96674111,
                'subcategory_id' => 99585136,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 1,
                'refundable' => 1,
                'image' => 'product-47-1.webp'
            ],

            [
                'id' => 88630158,
                'title' => "Stride Rite Unisex-Child Made2play Xander Athletic Sneaker",
                'meta_title' => "Stride Rite Unisex-Child Made2play Xander Athletic Sneaker",
                'meta_description' => "Stride Rite Unisex-Child Made2play Xander Athletic Sneaker",
                'description' => $description,
                 'overview' => $productOverview,
                'selling' => 110,
                'purchased' => 90,
                'offered' => 100,
                'badge' => 'New',
                'tax_rule_id' => 1,
                'rating' => 0,
                'review_count' => 0,
                'shipping_rule_id' => 1,
                'brand_id' => 9442208,
                'category_id' => 96674111,
                'subcategory_id' => 99585136,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 1,
                'refundable' => 1,
                'image' => 'product-48-1.webp'
            ],
            [
                'id' => 88630159,
                'title' => "PUMA Women's Carina Sneaker",
                'meta_title' => "PUMA Women's Carina Sneaker",
                'meta_description' => "PUMA Women's Carina Sneaker",
                'description' => $description,
                'overview' => $productOverview,
                'selling' => 110,
                'purchased' => 90,
                'offered' => 100,
                'tax_rule_id' => 1,
                'rating' => 0,
                'review_count' => 0,
                'shipping_rule_id' => 1,
                'brand_id' => 9442208,
                'category_id' => 91202114,
                'subcategory_id' => 96765141,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 2,
                'refundable' => 1,
                'image' => 'product-49-1.webp'
            ],
            [
                'id' => 88630160,
                'title' => "CangLong Velvet Seat Chair with Metal Legs for Kitchen Dining Room,set of 2. Beige",
                'meta_title' => "CangLong Velvet Seat Chair with Metal Legs for Kitchen Dining Room,set of 2. Beige",
                'meta_description' => "CangLong Velvet Seat Chair with Metal Legs for Kitchen Dining Room,set of 2. Beige",
                'description' => $description,
                 'overview' => $productOverview,
                'selling' => 110,
                'purchased' => 90,
                'offered' => 100,
                'tax_rule_id' => 1,
                'badge' => 'Featured',
                'rating' => 0,
                'review_count' => 0,
                'shipping_rule_id' => 1,
                'brand_id' => 9442210,
                'category_id' => 92522115,
                'subcategory_id' => 99585143,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 2,
                'refundable' => 1,
                'image' => 'product-50-1.webp'
            ],
            [
                'id' => 88630161,
                'title' => "Homesick New Home Reed Diffuser",
                'meta_title' => "Homesick New Home Reed Diffuser",
                'meta_description' => "Homesick New Home Reed Diffuser",
                'description' => $description,
                 'overview' => $productOverview,
                'selling' => 110,
                'purchased' => 90,
                'offered' => 100,
                'tax_rule_id' => 1,
                'rating' => 0,
                'review_count' => 0,
                'shipping_rule_id' => 1,
                'brand_id' => 9442210,
                'category_id' => 92522115,
                'subcategory_id' => 96765144,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 2,
                'refundable' => 1,
                'image' => 'product-51-1.webp'
            ],
            [
                'id' => 88630162,
                'title' => "Brownie Brittle Sheila G's Low Calorie, Thin Sweet Crispy Snack and Treats Dessert, Healthy Chocolate Chip & Salted Caramel, 20 Oz, Pack of 20",
                'meta_title' => "Brownie Brittle Sheila G's Low Calorie, Thin Sweet Crispy Snack and Treats Dessert, Healthy Chocolate Chip & Salted Caramel, 20 Oz, Pack of 20",
                'meta_description' => "Brownie Brittle Sheila G's Low Calorie, Thin Sweet Crispy Snack and Treats Dessert, Healthy Chocolate Chip & Salted Caramel, 20 Oz, Pack of 20",
                'description' => $description,
                'overview' => $productOverview,
                'selling' => 110,
                'purchased' => 90,
                'offered' => 100,
                'tax_rule_id' => 1,
                'rating' => 0,
                'review_count' => 0,
                'shipping_rule_id' => 1,
                'brand_id' => 0,
                'category_id' => 92522115,
                'subcategory_id' => 96765144,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 2,
                'refundable' => 1,
                'image' => 'product-52-1.webp'
            ],
            [
                'id' => 88630163,
                'title' => "Non-Stick Sauté Pan, Rapid Noodles Cooker, 1.5L Mini Pot for Steak, Egg, Fried Rice, Ramen, Oatmeal, Soup with Power Adjustment, Seafoam Green",
                'meta_title' => "Non-Stick Sauté Pan, Rapid Noodles Cooker, 1.5L Mini Pot for Steak, Egg, Fried Rice, Ramen, Oatmeal, Soup with Power Adjustment, Seafoam Green",
                'meta_description' => "Non-Stick Sauté Pan, Rapid Noodles Cooker, 1.5L Mini Pot for Steak, Egg, Fried Rice, Ramen, Oatmeal, Soup with Power Adjustment, Seafoam Green",
                'description' => $description,
                 'overview' => $productOverview,
                'selling' => 110,
                'purchased' => 90,
                'offered' => 100,
                'tax_rule_id' => 1,
                'rating' => 0,
                'review_count' => 0,
                'shipping_rule_id' => 1,
                'bundle_deal_id' => 1,
                'brand_id' => 0,
                'category_id' => 91233119,
                'subcategory_id' => 99585149,
                'unit' => 'piece',
                'status' => 1,
                'admin_id' => 2,
                'refundable' => 1,
                'image' => 'product-53-1.webp'
            ],
        ];



        $admin1 = Admin::where('id', 1)->first();
        $admin2 = Admin::where('id', 2)->first();


        $sr = ShippingRule::where('id', 1)->first();

        $tr = TaxRules::where('id', 1)->first();

        $bd = BundleDeal::where('id', 1)->first();


        $cat1 = Category::where('id', '92522115')->first();
        $cat2 = Category::where('id', '96674111')->first();


        $subcat1 = SubCategory::where('id', '99585149')->first();
        $subcat2 = SubCategory::where('id', '96765144')->first();


        $brand = Brand::where('id', '9442210')->first();


        $valid = $admin1 && $admin2 && $sr && $bd && $tr && $cat1 && $cat2 && $subcat1 && $subcat2 && $brand;

        if(!Product::first() && $valid){
            foreach ($items as $i) {
                Product::create($i);
            }
        }

    }
}
