<?php

namespace Database\Seeders;

use App\Models\Product;
use App\Models\ProductLang;
use Illuminate\Database\Seeder;

class ProductLangSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $url = config('env.media.CDN_URL');

        if (config('env.media.STORAGE') == config('env.media.LOCAL')) {
            $url = config('env.url.APP_URL') . '/uploads/';

        } else if (config('env.media.STORAGE') == config('env.media.GCS')) {
            $url = config('env.media.CDN_URL') . '/uploads/';
        }

        $descriptionImg1 = $url . 'product-description-1.webp';
        $descriptionImg2 = $url . 'product-description-2.webp';
        $descriptionImg3 = $url . 'product-description-3.webp';
        $description = "<p><img src='" . $descriptionImg1 . "'></p><p><img src='" . $descriptionImg2 . "'></p><p><img src='" . $descriptionImg3 . "'></p>";

        $productOverviewTr = "<ul><li>Üretilmiyor ‏ : ‎&nbsp;Hayır</li><li>Ürün Boyutları ‏ : ‎&nbsp;3 x 3 x 3 inç; 1,76 Ons</li><li>Ürün model numarası ‏ : ‎&nbsp;231171045</li></ul><p><br></p>";

        $productOverviewFr = "<ul><li>Discontinued ‏ : ‎&nbsp;No</li><li>Dimensions du produit ‏ : ‎&nbsp;3 x 3 x 3 pouces ; 1,76 onces</li><li>Numéro de modèle de l'article : ‎&nbsp;231171045</li></ul><p><br></p>";

        $productOverviewHi = "<ul><li>बंद हो गया है: ‎&nbsp;नहीं</li><li>उत्पाद के आयाम: ‎3 x 3 x 3 इंच; 1.76 आउंस</li><li>आइटम मॉडल नंबर : ‎&nbsp;231171045</li></ul><p><br></p>";

        $productOverviewAr = "<ul> <li> توقف: لا </ li> <li> أبعاد المنتج: & nbsp ؛ 3 × 3 × 3 بوصات ؛ 1.76 أونصة </li> <li> رقم موديل السلعة: & nbsp؛ 231171045 </li> </ul> <p> <br> </p>";


        $items = [
            [
                'product_id' => 88630111,
                'title' => "Kadın Günlük Uzun Kollu Yaka Fermuarlı Sweatshirt İpli Gevşek Kazak Üstler",
                'meta_title' => "Kadın Günlük Uzun Kollu Yaka Fermuarlı Sweatshirt İpli Gevşek Kazak Üstler",
                'description' => $description,
                'meta_description' => "Kadın Günlük Uzun Kollu Yaka Fermuarlı Sweatshirt İpli Gevşek Kazak Üstler",
                'overview' => $productOverviewTr,
                'badge' => 'Yeni',
                'unit' => 'parça',
                'lang' => 'tr',
            ],
            [
                'product_id' => 88630112,
                'title' => "Örgü Gömlek Tops Casual Fırfır Kısa Kollu Üst Yuvarlak Boyun Tunik Tank Kadınlar için Tee Bluz Tops",
                'meta_title' => "Örgü Gömlek Tops Casual Fırfır Kısa Kollu Üst Yuvarlak Boyun Tunik Tank Kadınlar için Tee Bluz Tops",
                'meta_description' => "Örgü Gömlek Tops Casual Fırfır Kısa Kollu Üst Yuvarlak Boyun Tunik Tank Kadınlar için Tee Bluz Tops",
                'description' => $description,
                'overview' => $productOverviewTr,
                'unit' => 'parça',
                'lang' => 'tr',
            ],
            [
                'product_id' => 88630113,
                'title' => "Andongnywell Rahat Düz Renk Fırfırlı Yaka Uzun Kollu Fırfırlı Gömlek Bluz V Yaka Kısa Kollu Gömlek Üst",
                'meta_title' => "Andongnywell Rahat Düz Renk Fırfırlı Yaka Uzun Kollu Fırfırlı Gömlek Bluz V Yaka Kısa Kollu Gömlek Üst",
                'description' => $description,
                'meta_description' => "Andongnywell Rahat Düz Renk Fırfırlı Yaka Uzun Kollu Fırfırlı Gömlek Bluz V Yaka Kısa Kollu Gömlek Üst",
                'overview' => $productOverviewTr,
                'unit' => 'parça',
                'lang' => 'tr',
            ],
            [
                'product_id' => 88630114,
                'title' => "Kadın Waffle Örgü Bluz Balon Uzun Kollu Dantel Casual Gevşek T Shirt Tops",
                'meta_title' => "Kadın Waffle Örgü Bluz Balon Uzun Kollu Dantel Casual Gevşek T Shirt Tops",
                'description' => $description,
                'meta_description' => "Kadın Waffle Örgü Bluz Balon Uzun Kollu Dantel Casual Gevşek T Shirt Tops",
                'overview' => $productOverviewTr,
                'unit' => 'parça',
                'lang' => 'tr',
            ],
            [
                'product_id' => 88630115,
                'title' => "Kadın Fırfır Kollu Yaz Casual Bluz Bisiklet Yaka Katı Sevimli Tunik Gömlek Tops",
                'meta_title' => "Kadın Fırfır Kollu Yaz Casual Bluz Bisiklet Yaka Katı Sevimli Tunik Gömlek Tops",
                'description' => $description,
                'meta_description' => "Kadın Fırfır Kollu Yaz Casual Bluz Bisiklet Yaka Katı Sevimli Tunik Gömlek Tops",
                'overview' => $productOverviewTr,
                'badge' => 'Featured',
                'unit' => 'parça',
                'lang' => 'tr',
            ],
            [
                'product_id' => 88630116,
                'title' => "Kadın Çiçekli Tunik Üstleri Günlük Bluz V Yaka Kısa Kollu Düğmeli T-Shirt",
                'meta_title' => "Kadın Çiçekli Tunik Üstleri Günlük Bluz V Yaka Kısa Kollu Düğmeli T-Shirt",
                'description' => $description,
                'meta_description' => "Kadın Çiçekli Tunik Üstleri Günlük Bluz V Yaka Kısa Kollu Düğmeli T-Shirt",
                'overview' => $productOverviewTr,
                'unit' => 'parça',
                'lang' => 'tr',
            ],
            [
                'product_id' => 88630117,
                'title' => "Andongnywell kadın Casual Leopar Baskı T-Shirt Uzun Kollu Yumuşak Sıkı Kamuflaj Bluz Gömlek Tops",
                'meta_title' => "Andongnywell kadın Casual Leopar Baskı T-Shirt Uzun Kollu Yumuşak Sıkı Kamuflaj Bluz Gömlek Tops",
                'description' => $description,
                'meta_description' => "Andongnywell kadın Casual Leopar Baskı T-Shirt Uzun Kollu Yumuşak Sıkı Kamuflaj Bluz Gömlek Tops",
                'overview' => $productOverviewTr,
                'unit' => 'parça',
                'lang' => 'tr',
            ],
            [
                'product_id' => 88630118,
                'title' => "Amoretu Kadın Yaz Tunik Elbise V Yaka Rahat Gevşek Flowy Salıncak Shift Elbiseler",
                'meta_title' => "Amoretu Kadın Yaz Tunik Elbise V Yaka Rahat Gevşek Flowy Salıncak Shift Elbiseler",
                'description' => $description,
                'meta_description' => "Amoretu Kadın Yaz Tunik Elbise V Yaka Rahat Gevşek Flowy Salıncak Shift Elbiseler",
                'overview' => $productOverviewTr,
                'unit' => 'parça',
                'lang' => 'tr',
            ],

            [
                'product_id' => 88630119,
                'title' => "Basit Lezzet Kadın Çiçek Vintage Elbise Zarif Midi Abiye 3/4 Kollu",
                'meta_title' => "Basit Lezzet Kadın Çiçek Vintage Elbise Zarif Midi Abiye 3/4 Kollu",
                'description' => $description,
                'meta_description' => "Basit Lezzet Kadın Çiçek Vintage Elbise Zarif Midi Abiye 3/4 Kollu",
                'overview' => $productOverviewTr,
                'unit' => 'parça',
                'lang' => 'tr',
            ],
            [
                'product_id' => 88630120,
                'title' => "BTFBM Kadınlar Casual Güz Elbiseler V Yaka Kravat Boyun Uzun Kollu Yüksek Bel Nokta Fırfır Katmanlı Bir Çizgi Katı Salıncak Mini Elbise",
                'meta_title' => "BTFBM Kadınlar Casual Güz Elbiseler V Yaka Kravat Boyun Uzun Kollu Yüksek Bel Nokta Fırfır Katmanlı Bir Çizgi Katı Salıncak Mini Elbise",
                'description' => $description,
                'meta_description' => "BTFBM Kadınlar Casual Güz Elbiseler V Yaka Kravat Boyun Uzun Kollu Yüksek Bel Nokta Fırfır Katmanlı Bir Çizgi Katı Salıncak Mini Elbise",
                'overview' => $productOverviewTr,
                'unit' => 'parça',
                'lang' => 'tr',
            ],
            [
                'product_id' => 88630121,
                'title' => "LYANER Kadın Tunik Yuvarlak Yaka Fırfırlı Gevşek Dökümlü Babydoll Salıncak Mini Elbise",
                'meta_title' => "LYANER Kadın Tunik Yuvarlak Yaka Fırfırlı Gevşek Dökümlü Babydoll Salıncak Mini Elbise",
                'description' => $description,
                'meta_description' => "LYANER Kadın Tunik Yuvarlak Yaka Fırfırlı Gevşek Dökümlü Babydoll Salıncak Mini Elbise",
                'overview' => $productOverviewTr,
                'badge' => 'Yeni',
                'unit' => 'parça',
                'lang' => 'tr',
            ],
            [
                'product_id' => 88630122,
                'title' => "PUMA Çocuk 6'lı Paket Düşük Kesim Çorap",
                'meta_title' => "PUMA Çocuk 6'lı Paket Düşük Kesim Çorap",
                'description' => $description,
                'meta_description' => "PUMA Çocuk 6'lı Paket Düşük Kesim Çorap",
                'overview' => $productOverviewTr,
                'unit' => 'parça',
                'lang' => 'tr',
            ],
            [
                'product_id' => 88630123,
                'title' => "3 Çift Üçlü Çizgili Diz Üstü Çorap Ekstra Uzun Opak Uyluk Yüksek Çorap",
                'meta_title' => "3 Çift Üçlü Çizgili Diz Üstü Çorap Ekstra Uzun Opak Uyluk Yüksek Çorap",
                'description' => $description,
                'meta_description' => "3 Çift Üçlü Çizgili Diz Üstü Çorap Ekstra Uzun Opak Uyluk Yüksek Çorap",
                'overview' => $productOverviewTr,
                'unit' => 'parça',
                'lang' => 'tr',
            ],
            [
                'product_id' => 88630124,
                'title' => "4'lü Paket Kadın Cepli Tayt, Yüksek Bel Karın Kontrol Egzersiz Yoga Pantolonu",
                'meta_title' => "4'lü Paket Kadın Cepli Tayt, Yüksek Bel Karın Kontrol Egzersiz Yoga Pantolonu",
                'description' => $description,
                'meta_description' => "4'lü Paket Kadın Cepli Tayt, Yüksek Bel Karın Kontrol Egzersiz Yoga Pantolonu",
                'overview' => $productOverviewTr,
                'badge' => 'Trending',
                'unit' => 'parça',
                'lang' => 'tr',
            ],
            [
                'product_id' => 88630125,
                'title' => "Kadın Büyütme Kiti Plus: Şampuan, Saç Kremi, %2 Minoksidil, Durulanmayan Köpürtücü. Kadınlar İçin Dökülme ve Seyrelme Karşıtı Saç Çözümü, 1 Ay",
                'meta_title' => "Kadın Büyütme Kiti Plus: Şampuan, Saç Kremi, %2 Minoksidil, Durulanmayan Köpürtücü. Kadınlar İçin Dökülme ve Seyrelme Karşıtı Saç Çözümü, 1 Ay",
                'description' => $description,
                'meta_description' => "Kadın Büyütme Kiti Plus: Şampuan, Saç Kremi, %2 Minoksidil, Durulanmayan Köpürtücü. Kadınlar İçin Dökülme ve Seyrelme Karşıtı Saç Çözümü, 1 Ay",
                'overview' => $productOverviewTr,
                'unit' => 'parça',
                'lang' => 'tr',
            ],
            [
                'product_id' => 88630126,
                'title' => "Daha Kalın, Daha Güçlü Saçlar İçin Nutrafol Kadın Saç Uzatma (Günde 4 Kapsül) (1 Aylık Arz)",
                'meta_title' => "Daha Kalın, Daha Güçlü Saçlar İçin Nutrafol Kadın Saç Uzatma (Günde 4 Kapsül) (1 Aylık Arz)",
                'description' => $description,
                'meta_description' => "Daha Kalın, Daha Güçlü Saçlar İçin Nutrafol Kadın Saç Uzatma (Günde 4 Kapsül) (1 Aylık Arz)",
                'overview' => $productOverviewTr,
                'badge' => 'Yeni',
                'unit' => 'parça',
                'lang' => 'tr',
            ],
            [
                'product_id' => 88630127,
                'title' => "Vagisil Kaşıntı Önleyici İlaçlı Kadınsı Vajinal Mendil, Maksimum Güç, Anında Rahatlama, 3'lü Paket - Toplam 60 Mendil (Ambalaj değişebilir)",
                'meta_title' => "Vagisil Kaşıntı Önleyici İlaçlı Kadınsı Vajinal Mendil, Maksimum Güç, Anında Rahatlama, 3'lü Paket - Toplam 60 Mendil (Ambalaj değişebilir)",
                'description' => $description,
                'meta_description' => "Vagisil Kaşıntı Önleyici İlaçlı Kadınsı Vajinal Mendil, Maksimum Güç, Anında Rahatlama, 3'lü Paket - Toplam 60 Mendil (Ambalaj değişebilir)",
                'overview' => $productOverviewTr,
                'unit' => 'parça',
                'lang' => 'tr',
            ],
            [
                'product_id' => 88630128,
                'title' => "Jet Set Nemlendirici Kit, Seyahat Dostu Cilt Bakım Seti, Temizleyici, Balsam, Nemlendirici, Göz Kremi ve Gece Kremi",
                'meta_title' => "Jet Set Nemlendirici Kit, Seyahat Dostu Cilt Bakım Seti, Temizleyici, Balsam, Nemlendirici, Göz Kremi ve Gece Kremi",
                'description' => $description,
                'meta_description' => "Jet Set Nemlendirici Kit, Seyahat Dostu Cilt Bakım Seti, Temizleyici, Balsam, Nemlendirici, Göz Kremi ve Gece Kremi",
                'overview' => $productOverviewTr,
                'badge' => 'Yeni',
                'unit' => 'parça',
                'lang' => 'tr',
            ],
            [
                'product_id' => 88630129,
                'title' => "Büyü | Cilt Yenileyici Mikrodermabrazyon Ovalama | Doğrudan Spa'dan | Gözenekleri Sıkılaştırır ve Cildi Aydınlatır | Paraben İçermez, Zulüm İçermez",
                'meta_title' => "Büyü | Cilt Yenileyici Mikrodermabrazyon Ovalama | Doğrudan Spa'dan | Gözenekleri Sıkılaştırır ve Cildi Aydınlatır | Paraben İçermez, Zulüm İçermez",
                'description' => $description,
                'meta_description' => "Büyü | Cilt Yenileyici Mikrodermabrazyon Ovalama | Doğrudan Spa'dan | Gözenekleri Sıkılaştırır ve Cildi Aydınlatır | Paraben İçermez, Zulüm İçermez",
                'overview' => $productOverviewTr,
                'unit' => 'parça',
                'lang' => 'tr',
            ],
            [
                'product_id' => 88630130,
                'title' => "'Günlük Nemlendirici' Duo Cilt Bakımı Başlangıç Kiti (Biyo-Kompleks Nemlendirici ve Ferulik Asit + C ve E Vitaminleri) İnce Çizgiler, Nemlendirme ve Düzensiz Cilt Tonu İle İlgili Yardımcı Olur",
                'meta_title' => "'Günlük Nemlendirici' Duo Cilt Bakımı Başlangıç Kiti (Biyo-Kompleks Nemlendirici ve Ferulik Asit + C ve E Vitaminleri) İnce Çizgiler, Nemlendirme ve Düzensiz Cilt Tonu İle İlgili Yardımcı Olur",
                'description' => $description,
                'meta_description' => "'Günlük Nemlendirici' Duo Cilt Bakımı Başlangıç Kiti (Biyo-Kompleks Nemlendirici ve Ferulik Asit + C ve E Vitaminleri) İnce Çizgiler, Nemlendirme ve Düzensiz Cilt Tonu İle İlgili Yardımcı Olur",
                'overview' => $productOverviewTr,
                'badge' => 'Yeni',
                'unit' => 'parça',
                'lang' => 'tr',
            ],
            [
                'product_id' => 88630131,
                'title' => "Image Skincare The Max Stem Cell Yüz Temizleyici, 4 Fl Oz",
                'meta_title' => "Image Skincare The Max Stem Cell Yüz Temizleyici, 4 Fl Oz",
                'description' => $description,
                'meta_description' => "Image Skincare The Max Stem Cell Yüz Temizleyici, 4 Fl Oz",
                'overview' => $productOverviewTr,
                'unit' => 'parça',
                'lang' => 'tr',
            ],
            [
                'product_id' => 88630132,
                'title' => "Sling Çanta Kanvas Crossbody Sırt Çantası Omuz Seyahat Çantası Gündelik Sırt Çantaları",
                'meta_title' => "Sling Çanta Kanvas Crossbody Sırt Çantası Omuz Seyahat Çantası Gündelik Sırt Çantaları",
                'description' => $description,
                'meta_description' => "Sling Çanta Kanvas Crossbody Sırt Çantası Omuz Seyahat Çantası Gündelik Sırt Çantaları",
                'overview' => $productOverviewTr,
                'unit' => 'parça',
                'lang' => 'tr',
            ],
            [
                'product_id' => 88630133,
                'title' => "Nautica Diver Naylon Küçük Bayan Crossbody Çanta Ayarlanabilir Omuz Askılı Çanta",
                'meta_title' => "Nautica Diver Naylon Küçük Bayan Crossbody Çanta Ayarlanabilir Omuz Askılı Çanta",
                'description' => $description,
                'meta_description' => "Nautica Diver Naylon Küçük Bayan Crossbody Çanta Ayarlanabilir Omuz Askılı Çanta",
                'overview' => $productOverviewTr,
                'unit' => 'parça',
                'lang' => 'tr',
            ],
            [
                'product_id' => 88630134,
                'title' => "Anna by Anuschka Satchel El Çantası | Gerçek Deri",
                'meta_title' => "Anna by Anuschka Satchel El Çantası | Gerçek Deri",
                'description' => $description,
                'meta_description' => "Anna by Anuschka Satchel El Çantası | Gerçek Deri",
                'overview' => $productOverviewTr,
                'unit' => 'parça',
                'lang' => 'tr',
            ],
            [
                'product_id' => 88630135,
                'title' => "Kendinden Katlanır Yaka Kartı Tutucu Anahtar Makarası, Ağır Hizmet Tipi Metal Gövde, 30 İnç Çelik Kordon, Kemer Klipsli Karabina Anahtarlık Anahtarlık, 15 Adede Kadar Tutabilen Anahtar ve Aletler",
                'meta_title' => "Kendinden Katlanır Yaka Kartı Tutucu Anahtar Makarası, Ağır Hizmet Tipi Metal Gövde, 30 İnç Çelik Kordon, Kemer Klipsli Karabina Anahtarlık Anahtarlık, 15 Adede Kadar Tutabilen Anahtar ve Aletler",
                'description' => $description,
                'meta_description' => "Kendinden Katlanır Yaka Kartı Tutucu Anahtar Makarası, Ağır Hizmet Tipi Metal Gövde, 30 İnç Çelik Kordon, Kemer Klipsli Karabina Anahtarlık Anahtarlık, 15 Adede Kadar Tutabilen Anahtar ve Aletler",
                'overview' => $productOverviewTr,
                'unit' => 'parça',
                'lang' => 'tr',
            ],
            [
                'product_id' => 88630136,
                'title' => "Airanes Kadın Erkek Güvenlik Gözlükleri",
                'meta_title' => "Airanes Kadın Erkek Güvenlik Gözlükleri",
                'description' => $description,
                'meta_description' => "Airanes Kadın Erkek Güvenlik Gözlükleri",
                'overview' => $productOverviewTr,
                'unit' => 'parça',
                'lang' => 'tr',
            ],
            [
                'product_id' => 88630137,
                'title' => "Legendary Whitetails Erkek Kalfa Gömlek Ceket",
                'meta_title' => "Legendary Whitetails Erkek Kalfa Gömlek Ceket",
                'description' => $description,
                'meta_description' => "Legendary Whitetails Erkek Kalfa Gömlek Ceket",
                'overview' => $productOverviewTr,
                'unit' => 'parça',
                'lang' => 'tr',
            ],
            [
                'product_id' => 88630138,
                'title' => "Wrangler Erkek Kovboy Kesim Batı Uzun Kollu Çıtçıt İş Gömleği Sert Kaplama",
                'meta_title' => "Wrangler Erkek Kovboy Kesim Batı Uzun Kollu Çıtçıt İş Gömleği Sert Kaplama",
                'meta_description' => "Wrangler Erkek Kovboy Kesim Batı Uzun Kollu Çıtçıt İş Gömleği Sert Kaplama",
                'description' => $description,
                'overview' => $productOverviewTr,
                'unit' => 'parça',
                'lang' => 'tr',
            ],
            [
                'product_id' => 88630139,
                'title' => "Dockers Erkek Uzun Kollu Signature Comfort Flex Gömlek",
                'meta_title' => "Dockers Erkek Uzun Kollu Signature Comfort Flex Gömlek",
                'meta_description' => "Dockers Erkek Uzun Kollu Signature Comfort Flex Gömlek",
                'description' => $description,
                'overview' => $productOverviewTr,
                'badge' => 'Trending',
                'unit' => 'parça',
                'lang' => 'tr',
            ],

            [
                'product_id' => 88630140,
                'title' => "Goodthreads Erkek Slim-Fit Uzun Kollu Ekose Oxford Gömlek",
                'meta_title' => "Goodthreads Erkek Slim-Fit Uzun Kollu Ekose Oxford Gömlek",
                'meta_description' => "Goodthreads Erkek Slim-Fit Uzun Kollu Ekose Oxford Gömlek",
                'description' => $description,
                'overview' => $productOverviewTr,
                'unit' => 'parça',
                'lang' => 'tr',
            ],

            [
                'product_id' => 88630141,
                'title' => "Dickies Sanded Duck Sherpa Astarlı Erkek Kapşonlu Ceket",
                'meta_title' => "Dickies Sanded Duck Sherpa Astarlı Erkek Kapşonlu Ceket",
                'meta_description' => "Dickies Sanded Duck Sherpa Astarlı Erkek Kapşonlu Ceket",
                'description' => $description,
                'overview' => $productOverviewTr,
                'badge' => 'Trend',
                'unit' => 'parça',
                'lang' => 'tr',
            ],
            [
                'product_id' => 88630142,
                'title' => "Carhartt Erkek Termal Astarlı Duck Active Ceket J131 (Normal ve Büyük & Uzun Bedenler)",
                'meta_title' => "Carhartt Erkek Termal Astarlı Duck Active Ceket J131 (Normal ve Büyük & Uzun Bedenler)",
                'meta_description' => "Carhartt Erkek Termal Astarlı Duck Active Ceket J131 (Normal ve Büyük & Uzun Bedenler)",
                'description' => $description,
                'overview' => $productOverviewTr,
                'unit' => 'parça',
                'lang' => 'tr',
            ],
            [
                'product_id' => 88630143,
                'title' => "Columbia Erkek Pudra Lite Ceketi",
                'meta_title' => "Columbia Erkek Pudra Lite Ceket",
                'meta_description' => "Columbia Erkek Pudra Lite Ceket",
                'description' => $description,
                'overview' => $productOverviewTr,
                'unit' => 'parça',
                'lang' => 'tr',
            ],
            [
                'product_id' => 88630144,
                'title' => "Jack Wolfskin Kadın Türbülans Ceketi",
                'meta_title' => "Jack Wolfskin Kadın Türbülans Ceketi",
                'meta_description' => "Jack Wolfskin Kadın Türbülans Ceketi",
                'description' => $description,
                'overview' => $productOverviewTr,
                'badge' => 'Trend',
                'unit' => 'parça',
                'lang' => 'tr',
            ],
            [
                'product_id' => 88630145,
                'title' => "Erkekler Survivor Iv Rahat Kalıp Kargo Pantolon-Reg ve Büyük ve Uzun Bedenler",
                'meta_title' => "Erkekler Survivor Iv Rahat Kalıp Kargo Pantolon-Reg ve Büyük Bedenler",
                'meta_description' => "Erkek Survivor Iv Rahat Kalıp Kargo Pantolon-Reg ve Büyük ve Uzun Bedenler",
                'description' => $description,
                'overview' => $productOverviewTr,
                'unit' => 'parça',
                'lang' => 'tr',
            ],
            [
                'product_id' => 88630146,
                'title' => "Id Pencere Cüzdanlı Fossil Erkek Deri Üç Katlı",
                'meta_title' => "Id Pencereli Fossil Erkek Deri Üç Katlı Cüzdan",
                'meta_description' => "Id Pencereli Fossil Erkek Deri Üç Katlı Cüzdan",
                'description' => $description,
                'overview' => $productOverviewTr,
                'badge' => 'Trend',
                'unit' => 'parça',
                'lang' => 'tr',
            ],
            [
                'product_id' => 88630147,
                'title' => "Carhartt Legacy Deluxe 17 İnç Dizüstü Bilgisayar Bölmeli Sırt Çantası, Carhartt Brown",
                'meta_title' => "Carhartt Legacy Deluxe 17 İnç Dizüstü Bilgisayar Bölmeli Sırt Çantası, Carhartt Brown",
                'meta_description' => "Carhartt Legacy Deluxe 17 İnç Dizüstü Bilgisayar Bölmeli Sırt Çantası, Carhartt Brown",
                'description' => $description,
                'overview' => $productOverviewTr,
                'unit' => 'parça',
                'lang' => 'tr',
            ],
            [
                'product_id' => 88630148,
                'title' => "Herschel Classic Sırt Çantası, Ash Rose, Mid-Volume 18.0L",
                'meta_title' => "Herschel Classic Sırt Çantası, Ash Rose, Mid-Volume 18.0L",
                'meta_description' => "Herschel Classic Sırt Çantası, Ash Rose, Mid-Volume 18.0L",
                'description' => $description,
                'overview' => $productOverviewTr,
                'badge' => 'Trend',
                'unit' => 'parça',
                'lang' => 'tr',
            ],
            [
                'product_id' => 88630149,
                'title' => "Vera Bradley Pamuklu Kadın Kampüs Sırt Çantası",
                'meta_title' => "Vera Bradley Pamuklu Kadın Kampüs Sırt Çantası",
                'meta_description' => "Vera Bradley Pamuklu Kadın Kampüs Sırt Çantası",
                'description' => $description,
                'overview' => $productOverviewTr,
                'unit' => 'parça',
                'lang' => 'tr',
            ],
            [
                'product_id' => 88630150,
                'title' => "EaseGave 17.3 Inç Kadın Evrak Çantası, Çok Cepli Çalışma Çantası Geniş Ofis Bilgisayar Çantaları İş Seyahati için Dizüstü Bilgisayar Messenger Çantası, kahve-17.3 Inç",
                'meta_title' => "EaseGave 17,3 İnç Kadın Evrak Çantası, Çok Cepli Çalışma Çantası Geniş Ofis Bilgisayar Çantaları İş Seyahati için Dizüstü Bilgisayar Messenger Çantası, kahve-17,3 İnç",
                'meta_description' => "EaseGave 17.3 Inç Kadın Evrak Çantası, Çok Cepli Çalışma Çantası Geniş Ofis Bilgisayar Çantaları İş Seyahati için Laptop Messenger Çanta, kahve-17.3 Inç",
                'description' => $description,
                'overview' => $productOverviewTr,
                'unit' => 'parça',
                'lang' => 'tr',
            ],
            [
                'product_id' => 88630151,
                'title' => "Çevre Dostu Dizüstü Bilgisayar Sırt Çantası: Geri dönüştürülmüş PET şişelerden yapılmıştır",
                'meta_title' => "Çevre Dostu Dizüstü Bilgisayar Sırt Çantası: Geri dönüştürülmüş PET şişelerden yapılmıştır",
                'meta_description' => "Çevre Dostu Dizüstü Bilgisayar Sırt Çantası: Geri dönüştürülmüş PET şişelerden yapılmıştır",
                'description' => $description,
                'overview' => $productOverviewTr,
                'unit' => 'parça',
                'lang' => 'tr',
            ],
            [
                'product_id' => 88630152,
                'title' => "Solo Yeni York Bölgesi Laptop Sırt Çantası, Gri",
                'meta_title' => "Solo Yeni York Bölgesi Laptop Sırt Çantası, Gri",
                'meta_description' => "Solo Yeni York Bölgesi Laptop Sırt Çantası, Gri",
                'description' => $description,
                'overview' => $productOverviewTr,
                'unit' => 'parça',
                'lang' => 'tr',
            ],
            [
                'product_id' => 88630153,
                'title' => "Kadınlar için Dizüstü Sırt Çantası İş Sırt Çantası Çanta Seyahat Bookbag Hemşire Okul Çantası",
                'meta_title' => "Kadınlar için Dizüstü Sırt Çantası İş Sırt Çantası Çanta Seyahat Bookbag Hemşire Okul Çantası",
                'meta_description' => "Kadınlar için Dizüstü Bilgisayar Sırt Çantası Çalışma Sırt Çantası Çanta Seyahat Bookbag Hemşire Okul Çantası",
                'description' => $description,
                'overview' => $productOverviewTr,
                'badge' => 'Öne Çıkanlar',
                'unit' => 'parça',
                'lang' => 'tr',
            ],
            [
                'product_id' => 88630154,
                'title' => "Neutrogena Makeup Remover Yüz Temizleme Mendili Singles, Günlük Yüz Mendili Kiri, Yağı, Makyajı ve Suya Dayanıklı Maskarayı Giderir, Nazik, Tek Tek Sarılmış, %100 Bitki Bazlı Lifler, 20 ct",
                'meta_title' => "Neutrogena Makeup Remover Yüz Temizleme Mendili Singles, Günlük Yüz Mendilleri Kiri, Yağı, Makyajı ve Suya Dayanıklı Maskarayı Giderir, Nazik, Tek Tek Sarılmış, %100 Bitki Bazlı Lifler, 20 ct",
                'meta_description' => "Neutrogena Makeup Remover Yüz Temizleme Mendili Singles, Günlük Yüz Mendilleri Kiri, Yağı, Makyajı ve Suya Dayanıklı Maskarayı Giderir, Nazik, Tek Tek Sarılmış, %100 Bitki Bazlı Lifler, 20 ct",
                'description' => $description,
                'overview' => $productOverviewTr,
                'unit' => 'parça',
                'lang' => 'tr',
            ],
            [
                'product_id' => 88630155,
                'title' => "Anker Soundcore Life Q20 Hibrit Aktif Gürültü Önleyici Kulaklıklar, Kablosuz Kulak Üstü Bluetooth Kulaklıklar, 40 Saat Çalma Süresi, Yüksek Çözünürlüklü Ses, Derin Bas, Hafızalı Köpük Kulaklıklar, Seyahat, Ev Ofis için",
                'meta_title' => "Anker Soundcore Life Q20 Hibrit Aktif Gürültü Önleyici Kulaklık, Kablosuz Kulak Üstü Bluetooth Kulaklık, 40 Saat Çalma Süresi, Yüksek Çözünürlüklü Ses, Derin Bas, Hafızalı Köpük Kulaklık, Seyahat, Ev Ofis için",
                'meta_description' => "Anker Soundcore Life Q20 Hibrit Aktif Gürültü Önleyici Kulaklık, Kablosuz Kulak Üstü Bluetooth Kulaklık, 40 Saat Çalma Süresi, Yüksek Çözünürlüklü Ses, Derin Bas, Hafızalı Köpük Kulaklıklar, Seyahat, Ev Ofis için",
                'description' => $description,
                'overview' => $productOverviewTr,
                'unit' => 'parça',
                'lang' => 'tr',
            ],
            [
                'product_id' => 88630156,
                'title' => "Mama Mio Gebelik Temel Kiti",
                'meta_title' => "Mama Mio Gebelik Temel Kiti",
                'meta_description' => "Mama Mio Gebelik Temel Kiti",
                'description' => $description,
                'overview' => $productOverviewTr,
                'badge' => 'Öne Çıkanlar',
                'unit' => 'parça',
                'lang' => 'tr',
            ],
            [
                'product_id' => 88630157,
                'title' => "Yeni Anneler İçin Sütlü Şık Hediye Kutusu- Anneler İçin 10 Eşsiz Doğum Sonrası Kişisel Bakım Ürünü-Annenin Şımartıcı Sürpriz Sepeti",
                'meta_title' => "Yeni Anneler İçin Sütlü Şık Hediye Kutusu- Anneler için 10 Eşsiz Doğum Sonrası Kişisel Bakım Ürünü-Annenin Şımartıcı Sürpriz Sepeti",
                'meta_description' => "Yeni Anneler İçin Sütlü Şık Hediye Kutusu- Anneler İçin 10 Eşsiz Doğum Sonrası Kişisel Bakım Ürünü-Anneleri Şımartan Sürpriz Sepeti",
                'description' => $description,
                'overview' => $productOverviewTr,
                'unit' => 'parça',
                'lang' => 'tr',
            ],
            [
                'product_id' => 88630158,
                'title' => "Stride Rite Unisex-Child Made2play Xander Athletic Sneaker",
                'meta_title' => "Stride Rite Unisex-Çocuk Made2play Xander Atletik Sneaker",
                'meta_description' => "Stride Rite Unisex-Çocuk Made2play Xander Atletik Sneaker",
                'description' => $description,
                'overview' => $productOverviewTr,
                'badge' => 'Yeni',
                'unit' => 'parça',
                'lang' => 'tr',
            ],
            [
                'product_id' => 88630159,
                'title' => "PUMA Kadın Carina Sneaker",
                'meta_title' => "PUMA Kadın Carina Sneaker",
                'meta_description' => "PUMA Kadın Carina Sneaker",
                'description' => $description,
                'overview' => $productOverviewTr,
                'unit' => 'parça',
                'lang' => 'tr',
            ],
            [
                'product_id' => 88630160,
                'title' => "CangUzun Mutfak Yemek Odası Metal Ayaklı Kadife Koltuk Sandalye 2'li Set. Bej",
                'meta_title' => "CangUzun Mutfak Yemek Odası Metal Ayaklı Kadife Koltuk Sandalye 2'li Set. Bej",
                'meta_description' => "CangLong Mutfak Yemek Odası Metal Ayaklı Kadife Koltuk 2'li Takım Bej",
                'description' => $description,
                'overview' => $productOverviewTr,
                'badge' => 'Öne Çıkanlar',
                'unit' => 'parça',
                'lang' => 'tr',
            ],
            [
                'product_id' => 88630161,
                'title' => "Homesick Yeni Home Reed Difüzör",
                'meta_title' => "Homesick Yeni Home Reed Difüzör",
                'meta_description' => "Homesick Yeni Home Reed Difüzör",
                'description' => $description,
                'overview' => $productOverviewTr,
                'unit' => 'parça',
                'lang' => 'tr',
            ],
            [
                'product_id' => 88630162,
                'title' => "Brownie Brittle Sheila G's Düşük Kalorili, İnce Tatlı Çıtır Atıştırmalık ve İkramlı Tatlı, Sağlıklı Çikolata Parçacıklı ve Tuzlu Karamel, 20 Oz, 20'li Paket",
                'meta_title' => "Brownie Brittle Sheila G's Düşük Kalorili, İnce Tatlı Çıtır Atıştırmalık ve İkramlı Tatlı, Sağlıklı Çikolata Parçacıklı ve Tuzlu Karamel, 20 Oz, 20'li Paket",
                'meta_description' => "Brownie Brittle Sheila G's Düşük Kalorili, İnce Tatlı Çıtır Atıştırmalık ve İkramlı Tatlı, Sağlıklı Çikolata Parçacıklı ve Tuzlu Karamel, 20 Oz, 20'li Paket",
                'description' => $description,
                'overview' => $productOverviewTr,
                'unit' => 'parça',
                'lang' => 'tr',
            ],
            [
                'product_id' => 88630163,
                'title' => "Yapışmaz Sote Tavası, Hızlı Erişte Pişirici, Biftek, Yumurta, Kızarmış Pilav, Ramen, Yulaf Ezmesi, Güç Ayarlı Çorba, Deniz Köpüğü Yeşili için 1,5 L Mini Tencere",
                'meta_title' => "Yapışmaz Sote Tavası, Hızlı Erişte Pişirici, Biftek, Yumurta, Kızarmış Pilav, Ramen, Yulaf Ezmesi, Güç Ayarlı Çorba, Deniz Köpüğü Yeşili için 1,5 L Mini Tencere",
                'meta_description' => "Yapışmaz Sote Tavası, Hızlı Erişte Pişirici, Biftek, Yumurta, Kızarmış Pilav, Ramen, Yulaf Ezmesi, Güç Ayarlı Çorba, Deniz Köpüğü Yeşili için 1,5 L Mini Tencere",
                'description' => $description,
                'overview' => $productOverviewTr,
                'unit' => 'parça',
                'lang' => 'tr',
            ],




            [
                'product_id' => 88630111 ,
                'title' => "Sweat-shirt décontracté à manches longues pour femmes avec cordon de serrage, pull ample" ,
                'meta_title' => "Sweat-shirt décontracté à manches longues avec revers et fermeture éclair pour femme" ,
                'description' => $description ,
                'meta_description' => "Sweat-shirt décontracté à manches longues avec revers et fermeture éclair pour femmes" ,
                'overview' => $productOverviewFr ,
                'badge' => 'Nouveau' ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],
            [
                'product_id' => 88630112 ,
                'title' => "Tops Chemises en Tricot Décontracté à Volants Haut à Manches Courtes Col Rond Tunique Débardeurs Tee Blouse pour Femme" ,
                'meta_title' => "Tops Chemises en Tricot Décontracté à Volants Haut à Manches Courtes Col Rond Tunique Débardeurs Tee Blouse pour Femme" ,
                'meta_description' => "Tops Chemises en Tricot Décontracté à Volants Haut à Manches Courtes Col Rond Tunique Débardeurs Tee Blouse pour Femme" ,
                'description' => $description ,
                'overview' => $productOverviewFr ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],
            [
                'product_id' => 88630113 ,
                'title' => "Andongnywell Chemise décontractée à col en V et à manches longues à col en V et à manches courtes" ,
                'meta_title' => "Andongnywell Chemise décontractée à col en V et à manches longues à col en V et à manches courtes" ,
                'description' => $description ,
                'meta_description' => "Andongnywell Casual Couleur Unie Col À Volants À Manches Longues Chemise À Volants Blouse Col En V À Manches Courtes Chemise Top" ,
                'overview' => $productOverviewFr ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],
            [
                'product_id' => 88630114 ,
                'title' => "Chemisier en tricot gaufré pour femme Ballon à manches longues Tops en dentelle T-shirts amples décontractés" ,
                'meta_title' => "Chemisier en maille gaufrée pour femme Ballon à manches longues Tops en dentelle T-shirts amples décontractés" ,
                'description' => $description ,
                'meta_description' => "Chemisier en maille gaufrée pour femme Ballon à manches longues Tops en dentelle T-shirts amples décontractés" ,
                'overview' => $productOverviewFr ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],
            [
                'product_id' => 88630115 ,
                'title' => "Tops à manches à volants pour femmes Chemisier décontracté d'été à col rond Solid Cute Tunic Shirt" ,
                'meta_title' => "Hauts à manches volantées pour femmes Chemisier décontracté d'été à col rond Chemise tunique mignonne unie" ,
                'description' => $description ,
                'meta_description' => "Tops à manches à volants pour femmes Chemisier décontracté d'été à col rond Chemise tunique mignonne unie" ,
                'overview' => $productOverviewFr ,
                'badge' => 'En vedette' ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],
            [
                'product_id' => 88630116 ,
                'title' => "Tops tuniques à fleurs pour femmes Chemisier décontracté Col en V Manches courtes T-shirts boutonnés" ,
                'meta_title' => "Tunique à fleurs pour femme Chemisier décontracté Col en V Manches courtes T-shirts boutonnés" ,
                'description' => $description ,
                'meta_description' => "Tunique à fleurs pour femme Chemisier décontracté Col en V Manches courtes T-shirts boutonnés" ,
                'overview' => $productOverviewFr ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],
            [
                'product_id' => 88630117 ,
                'title' => "Andongnywell Hauts décontractés pour femmes T-shirt imprimé léopard à manches longues Chemises de camouflage extensibles et douces" ,
                'meta_title' => "Andongnywell Hauts décontractés pour femmes T-shirt imprimé léopard à manches longues Chemises chemisier camouflage doux et extensible" ,
                'description' => $description ,
                'meta_description' => "Andongnywell Hauts décontractés pour femmes T-shirt imprimé léopard à manches longues Chemises chemisier camouflage extensible doux" ,
                'overview' => $productOverviewFr ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],
            [
                'product_id' => 88630118 ,
                'title' => "Amoretu Femmes Robe Tunique D'été Col En V Décontracté Lâche Flowy Swing Shift Robes" ,
                'meta_title' => "Amoretu Femmes Robe Tunique D'été Col V Décontracté Lâche Flowy Swing Shift Robes" ,
                'description' => $description ,
                'meta_description' => "Amoretu Femmes Robe Tunique D'été Col En V Décontracté Lâche Flowy Swing Shift Robes" ,
                'overview' => $productOverviewFr ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],

            [
                'product_id' => 88630119 ,
                'title' => "Robe vintage florale pour femme à saveur simple Robe de soirée midi élégante à manches 3/4" ,
                'meta_title' => "Robe vintage à fleurs pour femmes Simple Flavor Robe de soirée mi-longue élégante à manches 3/4" ,
                'description' => $description ,
                'meta_description' => "Robe vintage florale pour femme à saveur simple Robe de soirée midi élégante à manches 3/4" ,
                'overview' => $productOverviewFr ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],
            [
                'product_id' => 88630120 ,
                'title' => "BTFBM Femmes Casual Automne Robes Col V Cravate Cou Manches Longues Taille Haute Dot Ruffle Tiered A Line Solid Swing Mini Dress" ,
                'meta_title' => "BTFBM Femmes Casual Automne Robes Col V Cravate Cou Manches Longues Taille Haute Dot Ruffle Tiered A Line Solid Swing Mini Dress" ,
                'description' => $description ,
                'meta_description' => "BTFBM Robes d'automne décontractées pour femmes Col en V Cravate Manches longues Taille haute Dot Ruffle Tiered A Line Solid Swing Mini Dress" ,
                'overview' => $productOverviewFr ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],
            [
                'product_id' => 88630121 ,
                'title' => "LYANER Tunique Femme Col Rond Volants Lâche Flowy Babydoll Swing Mini Robes" ,
                'meta_title' => "LYANER Tunique Femme Col Rond Volants Lâche Flowy Babydoll Swing Mini Robes" ,
                'description' => $description ,
                'meta_description' => "LYANER Tunique Femme Col Rond Volants Lâche Flowy Babydoll Swing Mini Robes" ,
                'overview' => $productOverviewFr ,
                'badge' => 'Nouveau' ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],
            [
                'product_id' => 88630122 ,
                'title' => "Lot de 6 paires de chaussettes basses PUMA pour enfant" ,
                'meta_title' => "Lot de 6 paires de chaussettes basses PUMA pour enfant" ,
                'description' => $description ,
                'meta_description' => "Lot de 6 paires de chaussettes basses PUMA pour enfant" ,
                'overview' => $productOverviewFr ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],
            [
                'product_id' => 88630123 ,
                'title' => "3 paires de chaussettes à triple rayure sur les genoux bas extra longs opaques pour la cuisse" ,
                'meta_title' => "3 Paires de Chaussettes Triple Rayures Cuissardes Extra Longues Opaques" ,
                'description' => $description ,
                'meta_description' => "3 Paires de Chaussettes Triple Rayures Cuissardes Extra Longues Opaques" ,
                'overview' => $productOverviewFr ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],
            [
                'product_id' => 88630124 ,
                'title' => "Lot de 4 leggings avec poches pour femmes, pantalons de yoga d'entraînement taille haute pour le contrôle du ventre" ,
                'meta_title' => "Lot de 4 leggings avec poches pour femmes, pantalons de yoga taille haute pour le contrôle du ventre" ,
                'description' => $description ,
                'meta_description' => "Lot de 4 leggings avec poches pour femmes, pantalons de yoga taille haute pour le contrôle du ventre" ,
                'overview' => $productOverviewFr ,
                'badge' => 'Tendance' ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],
            [
                'product_id' => 88630125 ,
                'title' => "Kit Plus pour la repousse des cheveux pour femmes : shampoing, après-shampooing, 2 % de minoxidil, mousse sans rinçage. Solution anti-chute et amincissement des cheveux pour femmes, 1 mois" ,
                'meta_title' => "Kit Plus pour la repousse des cheveux pour femmes : shampooing, après-shampooing, 2 % de minoxidil, mousse sans rinçage. Solution anti-chute et amincissement des cheveux pour femmes, 1 mois" ,
                'description' => $description ,
                'meta_description' => "Kit Plus pour la repousse des cheveux pour femmes : shampooing, après-shampooing, 2 % de minoxidil, mousse sans rinçage. Solution anti-chute et cheveux clairsemés pour femmes, 1 mois" ,
                'overview' => $productOverviewFr ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],
            [
                'product_id' => 88630126 ,
                'title' => "Nutrafol Women Hair Growth For Plus Thick, Stronger Hair (4 capsules par jour) (1 mois d'approvisionnement)" ,
                'meta_title' => "Nutrafol Women Hair Growth For Plus Thick, Stronger Hair (4 capsules par jour) (1 mois d'approvisionnement)" ,
                'description' => $description ,
                'meta_description' => "Nutrafol Femmes Croissance des cheveux pour des cheveux plus épais et plus forts (4 capsules par jour) (1 mois d'approvisionnement)" ,
                'overview' => $productOverviewFr ,
                'badge' => 'Nouveau' ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],
            [
                'product_id' => 88630127 ,
                'title' => "Lingettes vaginales médicamenteuses anti-démangeaisons Vagisil, force maximale, soulagement instantané, paquet de 3 - 60 lingettes au total (l'emballage peut varier)" ,
                'meta_title' => "Lingettes vaginales médicamenteuses anti-démangeaisons Vagisil, force maximale, soulagement instantané, paquet de 3 - 60 lingettes au total (l'emballage peut varier)" ,
                'description' => $description ,
                'meta_description' => "Lingettes vaginales médicamenteuses anti-démangeaisons Vagisil, force maximale, soulagement instantané, paquet de 3 - 60 lingettes au total (l'emballage peut varier)" ,
                'overview' => $productOverviewFr ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],
            [
                'product_id' => 88630128 ,
                'title' => "Kit d'hydratation Jet Set, kit de soins de la peau adapté aux voyages, nettoyant, baume, hydratant, crème pour les yeux et crème de nuit" ,
                'meta_title' => "Kit d'hydratation Jet Set, kit de soins de la peau adapté aux voyages, nettoyant, baume, hydratant, crème pour les yeux et crème de nuit" ,
                'description' => $description ,
                'meta_description' => "Kit d'hydratation Jet Set, kit de soins de la peau adapté aux voyages, nettoyant, baume, hydratant, crème pour les yeux et crème de nuit" ,
                'overview' => $productOverviewFr ,
                'badge' => 'Nouveau' ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],
            [
                'product_id' => 88630129 ,
                'title' => "Magic | Gommage microdermabrasion régénérant pour la peau | Tout droit sorti du spa | Resserre les pores et illumine la peau | Sans paraben, sans cruauté envers les animaux" ,
                'meta_title' => "Magic | Gommage microdermabrasion régénérant pour la peau | Tout droit sorti du spa | Resserre les pores et illumine la peau | Sans paraben, sans cruauté envers les animaux" ,
                'description' => $description ,
                'meta_description' => "Magic | Gommage microdermabrasion rénovateur pour la peau | Directement sorti du spa | Resserre les pores et illumine la peau | Sans paraben, sans cruauté envers les animaux" ,
                'overview' => $productOverviewFr ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],
            [
                'product_id' => 88630130 ,
                'title' => "Kit de démarrage duo de soins de la peau 'Daily Hydrating' (hydratant bio-complexe et acide férulique + vitamines C et E) aide à lutter contre les ridules, l'hydratation et le teint irrégulier" ,
                'meta_title' => "Kit de démarrage duo de soins de la peau 'Daily Hydrating' (hydratant bio-complexe et acide férulique + vitamines C et E) aide à lutter contre les ridules, l'hydratation et le teint irrégulier" ,
                'description' => $description ,
                'meta_description' => "Kit de démarrage duo de soins de la peau 'Daily Hydrating' (hydratant bio-complexe et acide férulique + vitamines C et E) aide à lutter contre les ridules, l'hydratation et le teint irrégulier" ,
                'overview' => $productOverviewFr ,
                'badge' => 'Nouveau' ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],
            [
                'product_id' => 88630131 ,
                'title' => "Image Skincare Le nettoyant pour le visage Max Stem Cell, 4 Fl Oz" ,
                'meta_title' => "Image Skincare Le nettoyant pour le visage Max Stem Cell, 4 Fl Oz" ,
                'description' => $description ,
                'meta_description' => "Image Skincare Le nettoyant pour le visage Max Stem Cell, 4 Fl Oz" ,
                'overview' => $productOverviewFr ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],
            [
                'product_id' => 88630132 ,
                'title' => "Sac à bandoulière en toile Sac à dos à bandoulière Sac de voyage décontracté Daypacks" ,
                'meta_title' => "Sac à bandoulière en toile Sac à dos à bandoulière Sac de voyage à bandoulière Sacs à dos décontractés" ,
                'description' => $description ,
                'meta_description' => "Sac à bandoulière en toile Sac à dos à bandoulière Sac de voyage à bandoulière Sacs à dos décontractés" ,
                'overview' => $productOverviewFr ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],
            [
                'product_id' => 88630133 ,
                'title' => "Petit sac à bandoulière Nautica Diver en nylon pour femme avec bandoulière réglable" ,
                'meta_title' => "Petit sac à bandoulière Nautica Diver en nylon pour femme avec bandoulière réglable" ,
                'description' => $description ,
                'meta_description' => "Petit sac à bandoulière Nautica Diver en nylon pour femme avec bandoulière réglable" ,
                'overview' => $productOverviewFr ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],
            [
                'product_id' => 88630134 ,
                'title' => "Sac à main Anna by Anuschka Satchel | Cuir véritable" ,
                'meta_title' => "Sac à main Anna by Anuschka Satchel | Cuir véritable" ,
                'description' => $description ,
                'meta_description' => "Sac à main Anna by Anuschka Satchel | Cuir véritable" ,
                'overview' => $productOverviewFr ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],
            [
                'product_id' => 88630135 ,
                'title' => "Bobine de clé porte-badge d'identification auto-rétractable, corps en métal robuste, cordon en acier de 30 pouces, porte-clés porte-clés mousqueton avec clip ceinture, peut contenir jusqu'à 15 clés et outils" ,
                'meta_title' => "Bobine porte-badge d'identification auto-rétractable, corps en métal robuste, cordon en acier de 30 pouces, mousqueton porte-clés avec clip de ceinture, peut contenir jusqu'à 15 clés et outils" ,
                'description' => $description ,
                'meta_description' => "Bobine porte-badge d'identification auto-rétractable, corps en métal robuste, cordon en acier de 30 pouces, mousqueton porte-clés avec clip de ceinture, peut contenir jusqu'à 15 clés et outils" ,
                'overview' => $productOverviewFr ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],
            [
                'product_id' => 88630136 ,
                'title' => "Lunettes de sécurité anti-buée Airanes pour femmes hommes" ,
                'meta_title' => "Lunettes de sécurité antibuée Airanes pour femmes hommes" ,
                'description' => $description ,
                'meta_description' => "Lunettes de sécurité antibuée Airanes pour femmes hommes" ,
                'overview' => $productOverviewFr ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],
            [
                'product_id' => 88630137 ,
                'title' => "Veste-chemise Journeyman Legendary Whitetails pour homme" ,
                'meta_title' => "Veste-chemise Journeyman Legendary Whitetails pour homme" ,
                'description' => $description ,
                'meta_description' => "Veste-chemise Journeyman Legendary Whitetails pour homme" ,
                'overview' => $productOverviewFr ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],
            [
                'product_id' => 88630138 ,
                'title' => "Chemise de travail Wrangler Cowboy Western à manches longues avec bouton-pression, finition ferme" ,
                'meta_title' => "Chemise de travail Wrangler Cowboy Western à manches longues et boutons-pression Finition ferme" ,
                'meta_description' => "Chemise de travail Wrangler Cowboy Western à manches longues avec bouton-pression Finition ferme" ,
                'description' => $description ,
                'overview' => $productOverviewFr ,

                'unit' => 'pièce' ,

                'lang' => 'fr' ,
            ],
            [
                'product_id' => 88630139 ,
                'title' => "Chemise à manches longues Signature Comfort Flex Dockers pour homme" ,
                'meta_title' => "Chemise à manches longues Signature Comfort Flex Dockers pour homme" ,
                'meta_description' => "Chemise à manches longues Signature Comfort Flex Dockers pour homme" ,
                'description' => $description ,
                'overview' => $productOverviewFr ,
                'badge' => 'Tendance' ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],

            [
                'product_id' => 88630140 ,
                'title' => "Chemise Oxford à carreaux à manches longues coupe slim Goodthreads pour homme" ,
                'meta_title' => "Chemise Oxford coupe slim à carreaux à manches longues pour homme Goodthreads" ,
                'meta_description' => "Chemise Oxford coupe slim à carreaux à manches longues pour homme Goodthreads" ,
                'description' => $description ,
                'overview' => $productOverviewFr ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],

            [
                'product_id' => 88630141 ,
                'title' => "Veste à capuche doublée Sherpa Sanded Duck pour homme" ,
                'meta_title' => "Veste à capuche Dickies Sanded Duck Sherpa pour homme" ,
                'meta_description' => "Veste à capuche Dickies Sanded Duck Sherpa pour homme" ,
                'description' => $description ,
                'overview' => $productOverviewFr ,
                'badge' => 'Tendance' ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],
            [
                'product_id' => 88630142 ,
                'title' => "Veste Active en canard doublé thermique pour homme J131 de Carhartt (tailles régulières et grandes et grandes)" ,
                'meta_title' => "Veste Active en canard doublé thermique pour homme J131 de Carhartt (tailles régulières et grandes et grandes)" ,
                'meta_description' => "Veste Carhartt Thermal Lined Duck Active J131 (Tailles régulières et grandes et grandes)" ,
                'description' => $description ,
                'overview' => $productOverviewFr ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],
            [
                'product_id' => 88630143 ,
                'title' => "Veste Columbia Powder Lite pour homme" ,
                'meta_title' => "Veste Columbia Powder Lite pour homme" ,
                'meta_description' => "Veste Columbia Powder Lite pour homme" ,
                'description' => $description ,
                'overview' => $productOverviewFr ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],
            [
                'product_id' => 88630144 ,
                'title' => "Veste Turbulence Femme Jack Wolfskin" ,
                'meta_title' => "Veste Jack Wolfskin Turbulence pour femme" ,
                'meta_description' => "Veste Jack Wolfskin Turbulence pour femme" ,
                'description' => $description ,
                'overview' => $productOverviewFr ,
                'badge' => 'Tendance' ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],
            [
                'product_id' => 88630145 ,
                'title' => "Pantalon cargo coupe décontractée Survivor Iv pour homme - Tailles régulières et grandes et grandes" ,
                'meta_title' => "Pantalon cargo Survivor Iv Relaxed Fit pour homme - Tailles régulières et grandes et grandes" ,
                'meta_description' => "Pantalon cargo Survivor Iv Relaxed Fit pour homme - Tailles régulières et grandes et grandes" ,
                'description' => $description ,
                'overview' => $productOverviewFr ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],
            [
                'product_id' => 88630146 ,
                'title' => "Portefeuille Fossil en cuir à trois volets avec fenêtre d'identité" ,
                'meta_title' => "Portefeuille Fossil en cuir à trois volets avec fenêtre d'identité" ,
                'meta_description' => "Portefeuille Fossil en cuir à trois volets avec fenêtre d'identification pour homme" ,
                'description' => $description ,
                'overview' => $productOverviewFr ,
                'badge' => 'Tendance' ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],
            [
                'product_id' => 88630147 ,
                'title' => "Sac à dos de travail Carhartt Legacy Deluxe avec compartiment pour ordinateur portable 17 pouces, Carhartt Brown" ,
                'meta_title' => "Sac à dos de travail Carhartt Legacy Deluxe avec compartiment pour ordinateur portable 17 pouces, Carhartt Brown" ,
                'meta_description' => "Sac à dos de travail Carhartt Legacy Deluxe avec compartiment pour ordinateur portable 17 pouces, Carhartt Brown" ,
                'description' => $description ,
                'overview' => $productOverviewFr ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],
            [
                'product_id' => 88630148 ,
                'title' => "Sac à dos classique Herschel, Rose cendré, Volume moyen 18,0 L" ,
                'meta_title' => "Sac à dos classique Herschel, rose cendré, volume moyen 18,0 L" ,
                'meta_description' => "Sac à dos classique Herschel, rose cendré, volume moyen 18,0 L" ,
                'description' => $description ,
                'overview' => $productOverviewFr ,
                'badge' => 'Tendance' ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],
            [
                'product_id' => 88630149 ,
                'title' => "Sac à dos Campus en coton pour femme Vera Bradley" ,
                'meta_title' => "Sac à dos Campus en coton pour femme Vera Bradley" ,
                'meta_description' => "Sac à dos Campus en coton pour femme Vera Bradley" ,
                'description' => $description ,
                'overview' => $productOverviewFr ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],
            [
                'product_id' => 88630150 ,
                'title' => "EaseGave Mallette 17,3 Pouces pour Femme, Sac de Travail Multi-Poches Sacs pour Ordinateur de Bureau Spacieux Sacoche pour Ordinateur" ,
                'meta_title' => "EaseGave 17,3 Pouces Porte-Documents pour Femmes, Sac de Travail Multi-Poches Spacieux Bureau Ordinateurs" ,
                'meta_description' => "EaseGave 17,3 Pouces Mallette pour Femme, Sac de Travail Multi-Poches Spacieux Bureau Ordinateur" ,
                'description' => $description ,
                'overview' => $productOverviewFr ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],
            [
                'product_id' => 88630151 ,
                'title' => "Sac à dos pour ordinateur portable écologique : fabriqué à partir de bouteilles en PET recyclées" ,
                'meta_title' => "Sac à dos pour ordinateur portable écologique : fabriqué à partir de bouteilles en PET recyclées" ,
                'meta_description' => "Sac à dos pour ordinateur portable écologique : fabriqué à partir de bouteilles en PET recyclées" ,
                'description' => $description ,
                'overview' => $productOverviewFr ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],
            [
                'product_id' => 88630152 ,
                'title' => "Sac à dos pour ordinateur portable Solo New York Region, Gris" ,
                'meta_title' => "Sac à dos pour ordinateur portable Solo New York Region, Gris" ,
                'meta_description' => "Sac à dos pour ordinateur portable Solo New York Region, Gris" ,
                'description' => $description ,
                'overview' => $productOverviewFr ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],
            [
                'product_id' => 88630153 ,
                'title' => "Sac à dos pour ordinateur portable pour femmes travail sac à dos sac à main voyage Bookbag infirmière sac d'école" ,
                'meta_title' => "Sac à dos pour ordinateur portable pour femmes Work Backpack Purse Travel Bookbag Nurse School Bag" ,
                'meta_description' => "Sac à dos pour ordinateur portable pour femmes Work Backpack Purse Travel Bookbag Nurse School Bag" ,
                'description' => $description ,
                'overview' => $productOverviewFr ,
                'badge' => 'En vedette' ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],
            [
                'product_id' => 88630154 ,
                'title' => "Neutrogena Makeup Remover Facial Cleansing Towelette Singles, Daily Face Washings Remove Dirt, Oil" ,
                'meta_title' => "Neutrogena Makeup Remover Facial Cleansing Towelette Singles, Daily Face Wipes Remove Dirt, Oil" ,
                'meta_description' => "Neutrogena Makeup Remover Facial Cleansing Towelette Singles, Daily Face Washings Remove Dirt, Oil" ,
                'description' => $description ,
                'overview' => $productOverviewFr ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],
            [
                'product_id' => 88630155 ,
                'title' => "Écouteurs hybrides à réduction de bruit active Soundcore Life Q20 d'Anker, écouteurs Bluetooth" ,
                'meta_title' => "Écouteurs hybrides à réduction de bruit active Soundcore Life Q20 d'Anker, écouteurs Bluetooth" ,
                'meta_description' => "Casque hybride antibruit actif Soundcore Life Q20 d'Anker, casque Bluetooth",
                'description' => $description ,
                'overview' => $productOverviewFr ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],
            [
                'product_id' => 88630156 ,
                'title' => "Kit Essentiels de Grossesse Mama Mio" ,
                'meta_title' => "Kit Essentiels de Grossesse Mama Mio" ,
                'meta_description' => "Kit Essentiels de Grossesse Mama Mio" ,
                'description' => $description ,
                'overview' => $productOverviewFr ,
                'badge' => 'En vedette' ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],
            [
                'product_id' => 88630157 ,
                'title' => "Coffret cadeau Milky Chic pour les nouvelles mamans - 10 articles de soins personnels" ,
                'meta_title' => "Coffret cadeau Milky Chic pour les nouvelles mamans - 10 articles de soins personnels" ,
                'meta_description' => "Coffret cadeau Milky Chic pour les nouvelles mamans - 10 articles de soins personnels" ,
                'description' => $description ,
                'overview' => $productOverviewFr ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],
            [
                'product_id' => 88630158 ,
                'title' => "Sneaker de sport unisexe pour enfant Made2play Xander de Stride Rite" ,
                'meta_title' => "Sneaker de sport unisexe pour enfant Made2play Xander de Stride Rite" ,
                'meta_description' => "Sneaker de sport unisexe pour enfant Made2play Xander de Stride Rite" ,
                'description' => $description ,
                'overview' => $productOverviewFr ,
                'badge' => 'Nouveau' ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],
            [
                'product_id' => 88630159 ,
                'title' => "Basket PUMA Carina pour femme" ,
                'meta_title' => "Basket PUMA Carina pour femme" ,
                'meta_description' => "Basket PUMA Carina pour femme" ,
                'description' => $description ,
                'overview' => $productOverviewFr ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],
            [
                'product_id' => 88630160 ,
                'title' => "Chaise de siège en velours CangLong avec pieds en métal pour cuisine salle à manger, lot de 2. Beige" ,
                'meta_title' => "Chaise CangLong en velours avec pieds en métal pour cuisine salle à manger, lot de 2. Beige" ,
                'meta_description' => "Chaise CangLong en velours avec pieds en métal pour cuisine salle à manger, lot de 2. Beige" ,
                'description' => $description ,
                'overview' => $productOverviewFr ,
                'badge' => 'En vedette' ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],
            [
                'product_id' => 88630161 ,
                'title' => "Diffuseur à roseaux Homesick New Home" ,
                'meta_title' => "Diffuseur à roseaux Homesick New Home" ,
                'meta_description' => "Diffuseur à roseaux Homesick New Home" ,
                'description' => $description ,
                'overview' => $productOverviewFr ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],
            [
                'product_id' => 88630162 ,
                'title' => "Brownie Brittle Sheila G's Low Calorie, Thin Sweet Crispy Snack and Treats Dessert" ,
                'meta_title' => "Brownie Brittle Sheila G's Low Calorie, Thin Sweet Crispy Snack and Treats Dessert" ,
                'meta_description' => "Brownie Brittle Sheila G's Low Calorie, Thin Sweet Crispy Snack and Treats Dessert" ,
                'description' => $description ,
                'overview' => $productOverviewFr ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],
            [
                'product_id' => 88630163 ,
                'title' => "Poêle à Sauter Antiadhésive, Cuiseur Rapide de Nouilles, Mini Marmite de 1,5 L pour Steak, Oeuf, Riz Frit, Ramen" ,
                'meta_title' => "Sauté Antiadhésive, Cuiseur Rapide de Nouilles, Mini Marmite 1.5L pour Steak, Oeuf, Riz Frit, Ramen" ,
                'meta_description' => "Sauté Antiadhésive, Cuiseur Rapide de Nouilles, Mini Marmite 1.5L pour Steak, Oeuf, Riz Frit, Ramen" ,
                'description' => $description ,
                'overview' => $productOverviewFr ,
                'unit' => 'pièce' ,
                'lang' => 'fr' ,
            ],



            [
                'product_id' => 88630111 ,
                'title' => "महिलाओं की कैज़ुअल लंबी बाजू की लैपल ज़िपर स्वेटशर्ट ड्रॉस्ट्रिंग लूज़ पुलओवर टॉप्स" ,
                'meta_title' => "महिलाओं की कैज़ुअल लंबी बाजू वाली लैपल ज़िपर स्वेटशर्ट ड्रॉस्ट्रिंग लूज़ पुलओवर टॉप्स" ,
                'description' => $description ,
                'meta_description' => "महिलाओं की कैज़ुअल लंबी बाजू वाली लैपल ज़िपर स्वेटशर्ट ड्रॉस्ट्रिंग लूज़ पुलओवर टॉप्स" ,
                'overview' => $productOverviewHi ,
                'badge' => 'नया' ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],
            [
                'product_id' => 88630112 ,
                'title' => "महिलाओं के लिए निट शर्ट्स कैज़ुअल रफ़ल शॉर्ट स्लीव टॉप राउंड नेक ट्यूनिक टैंक टॉप टी ब्लाउज़" ,
                'meta_title' => "महिलाओं के लिए निट शर्ट्स कैज़ुअल रफ़ल शॉर्ट स्लीव टॉप राउंड नेक ट्यूनिक टैंक टॉप टी ब्लाउज़",
                'meta_description' => "महिलाओं के लिए निट शर्ट्स कैज़ुअल रफ़ल शॉर्ट स्लीव टॉप राउंड नेक ट्यूनिक टैंक टॉप टी ब्लाउज़",
                'description' => $description ,
                'overview' => $productOverviewHi ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],
            [
                'product_id' => 88630113 ,
                'title' => "Andongnywell कैज़ुअल सॉलिड कलर का रफ़ल कॉलर लॉन्ग स्लीव रफ़ल शर्ट ब्लाउज वी नेक शॉर्ट स्लीव शर्ट टॉप" ,
                'meta_title' => "Andongnywell कैज़ुअल सॉलिड कलर का रफ़ल कॉलर लॉन्ग स्लीव रफ़ल शर्ट ब्लाउज वी नेक शॉर्ट स्लीव शर्ट टॉप" ,
                'description' => $description ,
                'meta_description' => "Andongnywell कैज़ुअल सॉलिड कलर का रफ़ल कॉलर लॉन्ग स्लीव रफ़ल शर्ट ब्लाउज वी नेक शॉर्ट स्लीव शर्ट टॉप" ,
                'overview' => $productOverviewHi ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],
            [
                'product_id' => 88630114 ,
                'title' => "महिलाओं की वफ़ल निट ब्लाउज बैलोन लंबी बाजू वाली लेस टॉप कैज़ुअल लूज़ टी शर्ट्स" ,
                'meta_title' => "महिलाओं की वफ़ल निट ब्लाउज बैलोन लंबी बाजू वाली लेस टॉप कैजुअल लूज़ टी शर्ट्स" ,
                'description' => $description ,
                'meta_description' => "महिलाओं की वफ़ल निट ब्लाउज बैलोन लंबी बाजू वाली लेस टॉप कैजुअल लूज़ टी शर्ट्स" ,
                'overview' => $productOverviewHi ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],
            [
                'product_id' => 88630115 ,
                'title' => "महिलाओं की रफ़ल स्लीव टॉप समर कैज़ुअल ब्लाउज क्रू नेक सॉलिड क्यूट ट्यूनिक शर्ट" ,
                'meta_title' => "महिलाओं की रफ़ल स्लीव टॉप समर कैजुअल ब्लाउज़ क्रू नेक सॉलिड क्यूट ट्यूनिक शर्ट" ,
                'description' => $description ,
                'meta_description' => "महिलाओं की रफ़ल स्लीव टॉप समर कैजुअल ब्लाउज़ क्रू नेक सॉलिड क्यूट ट्यूनिक शर्ट" ,
                'overview' => $productOverviewHi ,
                'badge' => 'फीचर्ड' ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],
            [
                'product_id' => 88630116 ,
                'title' => "महिलाओं के लिए फ्लोरल ट्यूनिक टॉप कैजुअल ब्लाउज वी नेक शॉर्ट स्लीव बटन अप टी-शर्ट्स" ,
                'meta_title' => "महिलाओं का फ्लोरल ट्यूनिक टॉप कैजुअल ब्लाउज वी नेक शॉर्ट स्लीव बटन अप टी-शर्ट्स" ,
                'description' => $description ,
                'meta_description' => "महिलाओं के लिए फ्लोरल ट्यूनिक टॉप कैजुअल ब्लाउज वी नेक शॉर्ट स्लीव बटन अप टी-शर्ट्स" ,
                'overview' => $productOverviewHi ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],
            [
                'product_id' => 88630117 ,
                'title' => "Andongnywell महिलाओं के कैज़ुअल टॉप लेपर्ड प्रिंट वाली टी-शर्ट लंबी बाजू की मुलायम खिंचाव वाली छलावरण ब्लाउज़ शर्ट" ,
                'meta_title' => "Andongnywell महिलाओं के कैज़ुअल टॉप लेपर्ड प्रिंट वाली टी-शर्ट लंबी बाजू की मुलायम खिंचाव वाली छलावरण ब्लाउज़ शर्ट" ,
                'description' => $description ,
                'meta_description' => "Andongnywell महिलाओं के कैज़ुअल टॉप लेपर्ड प्रिंट वाली टी-शर्ट लंबी बाजू की मुलायम खिंचाव वाली छलावरण ब्लाउज़ शर्ट" ,
                'overview' => $productOverviewHi ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],
            [
                'product_id' => 88630118 ,
                'title' => "Amoretu महिलाओं के लिए समर ट्यूनिक ड्रेस वी नेक कैजुअल लूज फ्लोई स्विंग शिफ्ट ड्रेसेस" ,
                'meta_title' => "Amoretu महिलाओं के लिए समर ट्यूनिक ड्रेस वी नेक कैजुअल लूज फ्लोई स्विंग शिफ्ट ड्रेसेस" ,
                'description' => $description ,
                'meta_description' => "Amoretu महिलाओं के लिए समर ट्यूनिक ड्रेस वी नेक कैजुअल लूज फ्लोई स्विंग शिफ्ट ड्रेसेस" ,
                'overview' => $productOverviewHi ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],

            [
                'product_id' => 88630119 ,
                'title' => "सिंपल फ़्लेवर महिलाओं की फ्लोरल विंटेज ड्रेस एलिगेंट मिडी इवनिंग ड्रेस 3/4 स्लीव्स" ,
                'meta_title' => "सिंपल फ़्लेवर महिलाओं की फ्लोरल विंटेज ड्रेस एलिगेंट मिडी इवनिंग ड्रेस 3/4 स्लीव्स" ,
                'description' => $description ,
                'meta_description' => "महिलाओं के लिए सिंपल फ़्लेवर फ्लोरल विंटेज ड्रेस एलिगेंट मिडी इवनिंग ड्रेस 3/4 स्लीव्स" ,
                'overview' => $productOverviewHi ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],
            [
                'product_id' => 88630120 ,
                'title' => "बीटीएफबीएम वीमेन कैजुअल फॉल ड्रेसेस वी नेक टाई नेक लॉन्ग स्लीव हाई वेस्ट डॉट रफल टियर्ड ए लाइन सॉलिड स्विंग मिनी ड्रेस" ,
                'meta_title' => "BTFBM महिलाओं के लिए कैजुअल फॉल ड्रेस V नेक टाई नेक लॉन्ग स्लीव हाई वेस्ट डॉट रफ़ल टियर्ड A लाइन सॉलिड स्विंग मिनी ड्रेस" ,
                'description' => $description ,
                'meta_description' => "BTFBM महिलाओं के लिए कैजुअल फॉल ड्रेसेज़ V नेक टाई नेक लॉन्ग स्लीव हाई वेस्ट डॉट रफ़ल टियर्ड ए लाइन सॉलिड स्विंग मिनी ड्रेस" ,
                'overview' => $productOverviewHi ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],
            [
                'product_id' => 88630121 ,
                'title' => "LYANER महिलाओं का ट्यूनिक राउंड नेक रफ़ल लूज़ फ्लोई बेबीडॉल स्विंग मिनी ड्रेसेस" ,
                'meta_title' => "LYANER महिलाओं का ट्यूनिक राउंड नेक रफ़ल लूज़ फ्लोई बेबीडॉल स्विंग मिनी ड्रेसेस" ,
                'description' => $description ,
                'meta_description' => "LYANER महिलाओं के लिए ट्यूनिक राउंड नेक रफ़ल लूज़ फ्लोई बेबीडॉल स्विंग मिनी ड्रेसेस" ,
                'overview' => $productOverviewHi ,
                'badge' => 'नया' ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],
            [
                'product_id' => 88630122 ,
                'title' => "प्यूमा किड्स के 6 पैक लो कट सॉक्स" ,
                'meta_title' => "PUMA Kids' 6 पैक लो कट सॉक्स" ,
                'description' => $description ,
                'meta_description' => "PUMA Kids' 6 पैक लो कट सॉक्स" ,
                'overview' => $productOverviewHi ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],
            [
                'product_id' => 88630123 ,
                'title' => "3 पेयर ट्रिपल स्ट्राइप ओवर द नी सॉक्स एक्स्ट्रा लॉन्ग ओपेक थाई हाई स्टॉकिंग्स" ,
                'meta_title' => "3 जोड़े ट्रिपल स्ट्राइप ओवर द नी सॉक्स एक्स्ट्रा लॉन्ग ओपेक थाई हाई स्टॉकिंग्स" ,
                'description' => $description ,
                'meta_description' => "3 जोड़े ट्रिपल स्ट्राइप ओवर द नी सॉक्स एक्स्ट्रा लॉन्ग ओपेक थाई हाई स्टॉकिंग्स" ,
                'overview' => $productOverviewHi ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],
            [
                'product_id' => 88630124 ,
                'title' => "महिलाओं के लिए पॉकेट के साथ 4 पैक लेगिंग्स, हाई वेस्ट टमी कंट्रोल वर्कआउट योगा पैन्ट्स" ,
                'meta_title' => "महिलाओं के लिए पॉकेट के साथ 4 पैक लेगिंग्स, हाई वेस्ट टमी कंट्रोल वर्कआउट योगा पैन्ट्स" ,
                'description' => $description ,
                'meta_description' => "महिलाओं के लिए पॉकेट के साथ 4 पैक लेगिंग्स, हाई वेस्ट टमी कंट्रोल वर्कआउट योगा पैन्ट्स" ,
                'overview' => $productOverviewHi ,
                'badge' => 'ट्रेंडिंग' ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],
            [
                'product_id' => 88630125 ,
                'title' => "वूमेन्स रेग्रोथ किट प्लस: शैम्पू, कंडीशनर, 2% मिनोक्सिडिल, लीव-इन फ़ोमर। महिलाओं के लिए बालों का झड़ना रोकने वाला और पतला करने वाला हेयर सॉल्यूशन, 1 महीना" ,
                'meta_title' => "महिलाओं की वृद्धि किट प्लस: शैम्पू, कंडीशनर, 2% मिनोक्सिडिल, लीव-इन फ़ोमर। महिलाओं के लिए बालों का झड़ना रोकने वाला और पतला करने वाला समाधान, 1 महीना" ,
                'description' => $description ,
                'meta_description' => "वूमेन्स रेग्रोथ किट प्लस: शैम्पू, कंडीशनर, 2% मिनोक्सिडिल, लीव-इन फ़ोमर। महिलाओं के लिए बालों का झड़ना रोकने वाला और पतला करने वाला हेयर सॉल्यूशन, 1 महीना" ,
                'overview' => $productOverviewHi ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],
            [
                'product_id' => 88630126 ,
                'title' => "Nutrafol वीमेन हेयर ग्रोथ फॉर थिक, स्ट्रांग हेयर (4 कैप्सूल प्रति दिन) (1 महीने की सप्लाई)" ,
                'meta_title' => "Nutrafol महिलाओं के बालों का विकास मोटे, मजबूत बालों के लिए (4 कैप्सूल प्रति दिन) (1 महीने की आपूर्ति)" ,
                'description' => $description ,
                'meta_description' => "Nutrafol महिलाओं के बालों की ग्रोथ मोटे, मजबूत बालों के लिए (4 कैप्सूल प्रति दिन) (1 महीने की सप्लाई)" ,
                'overview' => $productOverviewHi ,
                'badge' => 'नया' ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],
            [
                'product_id' => 88630127 ,
                'title' => "वाजिसिल एंटी-इच मेडिकेटेड फेमिनिन वेजाइनल वाइप्स, अधिकतम शक्ति, तुरंत राहत, कुल 3 - 60 वाइप्स का पैक (पैकेजिंग भिन्न हो सकती है)" ,
                'meta_title' => "वैजिसिल एंटी-इच मेडिकेटेड फेमिनिन वेजाइनल वाइप्स, अधिकतम शक्ति, तुरंत राहत, कुल 3 - 60 वाइप्स का पैक (पैकेजिंग भिन्न हो सकती है)" ,
                'description' => $description ,
                'meta_description' => "वैजिसिल एंटी-इच मेडिकेटेड फेमिनिन वेजाइनल वाइप्स, अधिकतम शक्ति, तुरंत राहत, कुल 3 - 60 वाइप्स का पैक (पैकेजिंग भिन्न हो सकती है)" ,
                'overview' => $productOverviewHi ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],
            [
                'product_id' => 88630128 ,
                'title' => "जेट सेट हाइड्रेशन किट, ट्रैवल फ्रेंडली स्किनकेयर सेट, क्लींजर, बाम, मॉइस्चराइजर, आई क्रीम और नाइट क्रीम" ,
                'meta_title' => "जेट सेट हाइड्रेशन किट, ट्रैवल फ्रेंडली स्किनकेयर सेट, क्लींजर, बाम, मॉइस्चराइजर, आई क्रीम और नाइट क्रीम" ,
                'description' => $description ,
                'meta_description' => "जेट सेट हाइड्रेशन किट, यात्रा के अनुकूल स्किनकेयर सेट, क्लींजर, बाम, मॉइस्चराइजर, आई क्रीम और नाइट क्रीम" ,
                'overview' => $productOverviewHi ,
                'badge' => 'नया' ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],
            [
                'product_id' => 88630129 ,
                'title' => "मैजिक | स्किन-रिन्यूइंग माइक्रोडर्माब्रेशन स्क्रब | स्ट्रेट-फ्रॉम-द-स्पा | पोर्स को टाइट करता है और स्किन को चमकदार बनाता है। पैराबेन फ्री, क्रुएल्टी फ्री" ,
                'meta_title' => "मैजिक | स्किन-रिन्यूइंग माइक्रोडर्माब्रेशन स्क्रब | स्पा से सीधा | पोर्स को टाइट करता है और स्किन को चमकदार बनाता है | पैराबेन फ्री, क्रुएल्टी फ्री" ,
                'description' => $description ,
                'meta_description' => "मैजिक | स्किन-रिन्यूइंग माइक्रोडर्माब्रेशन स्क्रब | स्पा से सीधा | पोर्स को टाइट करता है और स्किन को चमकदार बनाता है | पैराबेन फ्री, क्रुएल्टी फ्री" ,
                'overview' => $productOverviewHi ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],
            [
                'product_id' => 88630130 ,
                'title' => "'डेली हाइड्रेटिंग' डुओ स्किन केयर स्टार्टर किट (बायो-कॉम्प्लेक्स मॉइस्चराइजर और फेरुलिक एसिड + विटामिन सी और ई) फाइन लाइन्स, हाइड्रेशन और असमान स्किन टोन के साथ मदद करता है" ,
                'meta_title' => "'डेली हाइड्रेटिंग' डुओ स्किन केयर स्टार्टर किट (बायो-कॉम्प्लेक्स मॉइस्चराइजर और फेरुलिक एसिड + विटामिन सी और ई) फाइन लाइन्स, हाइड्रेशन और असमान स्किन टोन के साथ मदद करता है" ,
                'description' => $description ,
                'meta_description' => "'डेली हाइड्रेटिंग' डुओ स्किन केयर स्टार्टर किट (बायो-कॉम्प्लेक्स मॉइस्चराइज़र और फेरुलिक एसिड + विटामिन सी और ई) फाइन लाइन्स, हाइड्रेशन और असमान स्किन टोन के साथ मदद करता है" ,
                'overview' => $productOverviewHi ,
                'badge' => 'नया' ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],
            [
                'product_id' => 88630131 ,
                'title' => "इमेज स्किनकेयर द मैक्स स्टेम सेल फेशियल क्लींजर, 4 फ्लो ओज" ,
                'meta_title' => "इमेज स्किनकेयर द मैक्स स्टेम सेल फेशियल क्लींजर, 4 फ्लो ओज" ,
                'description' => $description ,
                'meta_description' => "इमेज स्किनकेयर द मैक्स स्टेम सेल फेशियल क्लींजर, 4 फ्लो ओज" ,
                'overview' => $productOverviewHi ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],
            [
                'product_id' => 88630132 ,
                'title' => "स्लिंग बैग कैनवस क्रॉसबॉडी बैकपैक शोल्डर ट्रैवल बैग कैजुअल डेपैक्स" ,
                'meta_title' => "स्लिंग बैग कैनवस क्रॉसबॉडी बैकपैक शोल्डर ट्रैवल बैग कैजुअल डेपैक" ,
                'description' => $description ,
                'meta_description' => "स्लिंग बैग कैनवास क्रॉसबॉडी बैकपैक शोल्डर ट्रैवल बैग कैजुअल डेपैक" ,
                'overview' => $productOverviewHi ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],
            [
                'product_id' => 88630133 ,
                'title' => "नॉटिका डाइवर नायलॉन स्मॉल वुमन क्रॉसबॉडी बैग पर्स एडजस्टेबल शोल्डर स्ट्रैप के साथ" ,
                'meta_title' => "नॉटिका डाइवर नायलॉन स्मॉल वुमन क्रॉसबॉडी बैग पर्स एडजस्टेबल शोल्डर स्ट्रैप के साथ" ,
                'description' => $description ,
                'meta_description' => "नॉटिका डाइवर नायलॉन छोटा वुमेंस क्रॉसबॉडी बैग पर्स एडजस्टेबल शोल्डर स्ट्रैप के साथ" ,
                'overview' => $productOverviewHi ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],
            [
                'product_id' => 88630134 ,
                'title' => "Anna by Anuschka Satchel Handbag | असली लेदर" ,
                'meta_title' => "Anna by Anuschka Satchel Handbag | असली लेदर" ,
                'description' => $description ,
                'meta_description' => "Anna by Anuschka Satchel Handbag | असली लेदर" ,
                'overview' => $productOverviewHi ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],
            [
                'product_id' => 88630135 ,
                'title' => "सेल्फ रिट्रेक्टेबल आईडी badge होल्डर की रील, हैवी ड्यूटी मेटल बॉडी, 30 इंच स्टील कॉर्ड, बेल्ट क्लिप के साथ कैरबिनर की चेन कीचेन, 15 चाबियां और टूल्स तक होल्ड करें" ,
                'meta_title' => "सेल्फ रिट्रेक्टेबल आईडी badge होल्डर की रील, हैवी ड्यूटी मेटल बॉडी, 30 इंच स्टील कॉर्ड, बेल्ट क्लिप के साथ कैरबिनर की चेन कीचेन, 15 चाबियां और टूल्स तक पकड़ें" ,
                'description' => $description ,
                'meta_description' => "सेल्फ रिट्रेक्टेबल आईडी badge होल्डर की रील, हेवी ड्यूटी मेटल बॉडी, 30 इंच स्टील कॉर्ड, बेल्ट क्लिप के साथ कैरबिनर की चेन कीचेन, 15 चाबियां और टूल्स तक पकड़ें" ,
                'overview' => $productOverviewHi ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],
            [
                'product_id' => 88630136 ,
                'title' => "महिला पुरुषों के लिए एयरेन्स एंटी फॉग सुरक्षा चश्मा" ,
                'meta_title' => "पुरुषों के लिए एयरेन्स एंटी फॉग सुरक्षा चश्मा" ,
                'description' => $description ,
                'meta_description' => "पुरुषों के लिए एयरेन्स एंटी फॉग सुरक्षा चश्मा" ,
                'overview' => $productOverviewHi ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],
            [
                'product_id' => 88630137 ,
                'title' => "लेजेंडरी व्हाइटटेल मेन्स जर्नीमैन शर्ट जैकेट" ,
                'meta_title' => "लेजेंडरी व्हाइटटेल मेन्स जर्नीमैन शर्ट जैकेट" ,
                'description' => $description ,
                'meta_description' => "लेजेंडरी व्हाइटटेल मेन्स जर्नीमैन शर्ट जैकेट" ,
                'overview' => $productOverviewHi ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],
            [
                'product_id' => 88630138 ,
                'title' => "रैंगलर मेन्स काउबॉय कट वेस्टर्न लॉन्ग स्लीव स्नैप वर्क शर्ट फर्म फ़िनिश" ,
                'meta_title' => "रैंगलर मेन्स काउबॉय कट वेस्टर्न लॉन्ग स्लीव स्नैप वर्क शर्ट फर्म फ़िनिश" ,
                'meta_description' => "रैंगलर मेन्स काउबॉय कट वेस्टर्न लॉन्ग स्लीव स्नैप वर्क शर्ट फर्म फ़िनिश" ,
                'description' => $description ,
                'overview' => $productOverviewHi ,

                'Unit' => 'टुकड़ा' ,

                'lang' => 'hi' ,
            ],
            [
                'product_id' => 88630139 ,
                'title' => "डॉकर्स मेन्स लॉन्ग स्लीव सिग्नेचर कम्फर्ट फ्लेक्स शर्ट" ,
                'meta_title' => "डॉकर्स मेन्स लॉन्ग स्लीव सिग्नेचर कम्फर्ट फ्लेक्स शर्ट" ,
                'meta_description' => "डॉकर्स मेन्स लॉन्ग स्लीव सिग्नेचर कम्फर्ट फ्लेक्स शर्ट" ,
                'description' => $description ,
                'overview' => $productOverviewHi ,
                'badge' => 'ट्रेंडिंग' ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],

            [
                'product_id' => 88630140 ,
                'title' => "गुडथ्रेड्स मेन्स स्लिम-फिट लॉन्ग-स्लीव प्लेड ऑक्सफ़ोर्ड शर्ट" ,
                'meta_title' => "गुडथ्रेड्स मेन्स स्लिम-फिट लॉन्ग-स्लीव प्लेड ऑक्सफोर्ड शर्ट" ,
                'meta_description' => "गुडथ्रेड्स मेन्स स्लिम-फिट लॉन्ग-स्लीव प्लेड ऑक्सफोर्ड शर्ट" ,
                'description' => $description ,
                'overview' => $productOverviewHi ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],

            [
                'product_id' => 88630141 ,
                'title' => "डिकीज़ मेन्स सैंडेड डक शेरपा लाइनेड हूडेड जैकेट" ,
                'meta_title' => "डिकीज़ मेन्स सैंडेड डक शेरपा लाइनेड हूडेड जैकेट" ,
                'meta_description' => "डिकीज़ मेन्स सैंडेड डक शेरपा लाइनेड हूडेड जैकेट" ,
                'description' => $description ,
                'overview' => $productOverviewHi ,
                'badge' => 'ट्रेंडिंग' ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],
            [
                'product_id' => 88630142 ,
                'title' => "Carhartt पुरुषों की थर्मल लाइन्ड डक एक्टिव जैकेट J131 (नियमित और बड़े और लंबे आकार)" ,
                'meta_title' => "Carhartt पुरुषों की थर्मल लाइन्ड डक एक्टिव जैकेट J131 (नियमित और बड़े और लंबे आकार)" ,
                'meta_description' => "Carhartt पुरुषों की थर्मल लाइन्ड डक एक्टिव जैकेट J131 (नियमित और बड़े और लंबे आकार)" ,
                'description' => $description ,
                'overview' => $productOverviewHi ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],
            [
                'product_id' => 88630143 ,
                'title' => "कोलंबिया मेन्स पाउडर लाइट जैकेट" ,
                'meta_title' => "कोलंबिया मेन्स पाउडर लाइट जैकेट" ,
                'meta_description' => "कोलंबिया मेन्स पाउडर लाइट जैकेट" ,
                'description' => $description ,
                'overview' => $productOverviewHi ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],
            [
                'product_id' => 88630144 ,
                'title' => "जैक वोल्फस्किन विमेंस टर्बुलेंस जैकेट" ,
                'meta_title' => "जैक वोल्फस्किन महिला टर्बुलेंस जैकेट" ,
                'meta_description' => "जैक वोल्फस्किन महिला टर्बुलेंस जैकेट" ,
                'description' => $description ,
                'overview' => $productOverviewHi ,
                'badge' => 'ट्रेंडिंग' ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],
            [
                'product_id' => 88630145 ,
                'title' => "मेन्स सर्वाइवर आइवी रिलैक्स्ड फ़िट कार्गो पैंट-रेग और बड़े और लंबे आकार" ,
                'meta_title' => "मेन्स सर्वाइवर आईवी रिलैक्स्ड फ़िट कार्गो पैंट-रेग और बड़े और लंबे आकार" ,
                'meta_description' => "मेन्स सर्वाइवर आइवी रिलैक्स्ड फ़िट कार्गो पैंट-रेग और बड़े और लंबे आकार" ,
                'description' => $description ,
                'overview' => $productOverviewHi ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],
            [
                'product_id' => 88630146 ,
                'title' => "Fossil Men's लेदर Trifold with Id Window Wallet" ,
                'meta_title' => "फॉसिल मेन्स लेदर ट्राइफोल्ड विथ आईडी विंडो वॉलेट" ,
                'meta_description' => "फॉसिल मेन्स लेदर ट्राइफोल्ड विथ आईडी विंडो वॉलेट" ,
                'description' => $description ,
                'overview' => $productOverviewHi ,
                'badge' => 'ट्रेंडिंग' ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],
            [
                'product_id' => 88630147 ,
                'title' => "Carhartt लिगेसी डीलक्स वर्क बैकपैक 17-इंच लैपटॉप कम्पार्टमेंट के साथ, Carhartt Brown" ,
                'meta_title' => "Carhartt Legacy Deluxe Work Backpack with 17-Inch Laptop Compartment, Carhartt Brown" ,
                'meta_description' => "Carhartt लीगेसी डीलक्स वर्क बैकपैक 17-इंच लैपटॉप कम्पार्टमेंट के साथ, Carhartt भूरा" ,
                'description' => $description ,
                'overview' => $productOverviewHi ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],
            [
                'product_id' => 88630148 ,
                'title' => "हर्शल क्लासिक बैकपैक, ऐश रोज़, मिड-वॉल्यूम 18.0L" ,
                'meta_title' => "हर्शेल क्लासिक बैकपैक, ऐश रोज़, मिड-वॉल्यूम 18.0L" ,
                'meta_description' => "हर्शेल क्लासिक बैकपैक, ऐश रोज़, मिड-वॉल्यूम 18.0L" ,
                'description' => $description ,
                'overview' => $productOverviewHi ,
                'badge' => 'ट्रेंडिंग' ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],
            [
                'product_id' => 88630149 ,
                'title' => "वेरा ब्राडली महिलाओं के लिए कॉटन कैंपस बैकपैक" ,
                'meta_title' => "वेरा ब्रैडली महिलाओं का कॉटन कैम्पस बैकपैक" ,
                'meta_description' => "वेरा ब्रैडली महिलाओं का कॉटन कैम्पस बैकपैक" ,
                'description' => $description ,
                'overview' => $productOverviewHi ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],
            [
                'product_id' => 88630150 ,
                'title' => "EaseGave 17.3 इंच ब्रीफकेस महिलाओं के लिए, मल्टी-पॉकेट वर्क बैग जगहदार ऑफिस कंप्यूटर बैग लैपटॉप मेसेंजर बैग वर्क बिजनेस ट्रैवल के लिए, कॉफी-17.3 इंच" ,
                'meta_title' => "EaseGave 17.3 इंच का ब्रीफ़केस महिलाओं के लिए, मल्टी-पॉकेट वर्क बैग जगहदार ऑफिस कंप्यूटर बैग लैपटॉप मेसेंजर बैग, वर्क बिज़नेस ट्रेवल के लिए, कॉफ़ी-17.3 इंच",
                'meta_description' => "EaseGave 17.3 इंच का ब्रीफ़केस महिलाओं के लिए, मल्टी-पॉकेट वर्क बैग जगहदार ऑफिस कंप्यूटर बैग लैपटॉप मेसेंजर बैग, वर्क बिज़नेस ट्रेवल के लिए, कॉफ़ी-17.3 इंच",
                'description' => $description ,
                'overview' => $productOverviewHi ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],
            [
                'product_id' => 88630151 ,
                'title' => "पर्यावरण के अनुकूल लैपटॉप बैकपैक: पुनर्चक्रित पीईटी बोतलों से निर्मित" ,
                'meta_title' => "पर्यावरण के अनुकूल लैपटॉप बैकपैक: पुनर्चक्रित पीईटी बोतलों से निर्मित" ,
                'meta_description' => "पर्यावरण के अनुकूल लैपटॉप बैकपैक: पुनर्नवीनीकरण पीईटी बोतलों से निर्मित" ,
                'description' => $description ,
                'overview' => $productOverviewHi ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],
            [
                'product_id' => 88630152 ,
                'title' => "सोलो न्यूयॉर्क रीजन लैपटॉप बैकपैक, ग्रे" ,
                'meta_title' => "न्यूयॉर्क क्षेत्र का सोलो लैपटॉप बैकपैक, ग्रे (धूसर)" ,
                'meta_description' => "न्यूयॉर्क क्षेत्र का सोलो लैपटॉप बैकपैक, ग्रे (धूसर)" ,
                'description' => $description ,
                'overview' => $productOverviewHi ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],
            [
                'product_id' => 88630153 ,
                'title' => "महिलाओं के लिए लैपटॉप बैकपैक वर्क बैकपैक पर्स ट्रैवल बुकबैग नर्स स्कूल बैग" ,
                'meta_title' => "महिलाओं के लिए लैपटॉप बैकपैक वर्क बैकपैक पर्स ट्रैवल बुकबैग नर्स स्कूल बैग" ,
                'meta_description' => "महिलाओं के काम के लिए लैपटॉप बैकपैक बैकपैक पर्स ट्रैवल बुकबैग नर्स स्कूल बैग" ,
                'description' => $description ,
                'overview' => $productOverviewHi ,
                'badge' => 'फीचर्ड' ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],
            [
                'product_id' => 88630154 ,
                'title' => "न्यूट्रोजेना मेकअप रिमूवर फेशियल क्लींजिंग टॉवेलेट सिंगल, डेली फेस वाइप्स गंदगी, तेल, मेकअप और वाटरप्रूफ मस्कारा हटाते हैं, सौम्य, व्यक्तिगत रूप से लपेटा हुआ, 100% प्लांट-आधारित फाइबर, 20 ct" ,
                'meta_title' => "न्यूट्रोजेना मेकअप रिमूवर फेशियल क्लींजिंग टॉवेलेट सिंगल, डेली फेस वाइप्स गंदगी, तेल, मेकअप और वाटरप्रूफ मस्कारा हटाते हैं, कोमल, व्यक्तिगत रूप से लपेटा हुआ, 100% प्लांट-आधारित फाइबर, 20 ct" ,
                'meta_description' => "न्यूट्रोजेना मेकअप रिमूवर फेशियल क्लींजिंग टॉवेल सिंगल, डेली फेस वाइप्स गंदगी, तेल, मेकअप और वाटरप्रूफ मस्कारा हटाते हैं, कोमल, व्यक्तिगत रूप से लपेटा हुआ, 100% प्लांट-बेस्ड फाइबर, 20 ct" ,
                'description' => $description ,
                'overview' => $productOverviewHi ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],
            [
                'product_id' => 88630155 ,
                'title' => "Anker Soundcore Life Q20 हाईब्रिड एक्टिव नॉइज़ कैंसिलिंग हेडफ़ोन, वायरलेस ओवर ईयर ब्लूटूथ हेडफ़ोन, 40H प्लेटाइम, Hi-Res ऑडियो, डीप बास, मेमोरी फ़ोम ईयर कप, यात्रा, गृह कार्यालय के लिए" ,
                'meta_title' => "Anker Soundcore Life Q20 हाईब्रिड एक्टिव नॉइज़ कैंसलिंग हेडफ़ोन, वायरलेस ओवर ईयर ब्लूटूथ हेडफ़ोन, 40H Playtime, Hi-Res ऑडियो, डीप बास, मेमोरी फ़ोम ईयर कप, यात्रा, गृह कार्यालय के लिए" ,
                'meta_description' => "Anker Soundcore Life Q20 हाईब्रिड एक्टिव नॉइज़ कैंसलिंग हेडफ़ोन, वायरलेस ओवर ईयर ब्लूटूथ हेडफ़ोन, 40H प्लेटाइम, Hi-Res ऑडियो, डीप बास, मेमोरी फ़ोम ईयर कप, यात्रा, गृह कार्यालय के लिए" ,
                'description' => $description ,
                'overview' => $productOverviewHi ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],
            [
                'product_id' => 88630156 ,
                'title' => "मामा मियो प्रेग्नेंसी एसेंशियल्स किट" ,
                'meta_title' => "मामा मियो प्रेग्नेंसी एसेंशियल्स किट" ,
                'meta_description' => "मामा मियो प्रेग्नेंसी एसेंशियल्स किट" ,
                'description' => $description ,
                'overview' => $productOverviewHi ,
                'badge' => 'फीचर्ड' ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],
            [
                'product_id' => 88630157 ,
                'title' => "नई मांओं के लिए मिल्की चिक गिफ्ट बॉक्स- मांओं के लिए 10 यूनिक पोस्टपार्टम पर्सनल केयर आइटम्स-मम्मी का लाड़ प्यार सरप्राइज बास्केट" ,
                'meta_title' => "नई माँओं के लिए मिल्की चिक गिफ्ट बॉक्स- माताओं के लिए 10 अनोखे पोस्टपार्टम पर्सनल केयर आइटम-माँ की लाड़ प्यार सरप्राइज़ बास्केट" ,
                'meta_description' => "नई मांओं के लिए मिल्की चिक गिफ्ट बॉक्स- माताओं के लिए 10 अनोखे पोस्टपार्टम पर्सनल केयर आइटम-माँ की लाड़ प्यार सरप्राइज बास्केट",
                'description' => $description ,
                'overview' => $productOverviewHi ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],
            [
                'product_id' => 88630158 ,
                'title' => "स्ट्राइड राइट यूनीसेक्स-चाइल्ड मेड2प्ले ज़ेंडर एथलेटिक स्नीकर" ,
                'meta_title' => "स्ट्राइड राइट यूनीसेक्स-चाइल्ड मेड2प्ले ज़ेंडर एथलेटिक स्नीकर" ,
                'meta_description' => "स्ट्राइड राइट यूनीसेक्स-चाइल्ड मेड2प्ले ज़ेंडर एथलेटिक स्नीकर" ,
                'description' => $description ,
                'overview' => $productOverviewHi ,
                'badge' => 'नया' ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],
            [
                'product_id' => 88630159 ,
                'title' => "प्यूमा वीमेंस कैरिना स्नीकर" ,
                'meta_title' => "प्यूमा महिला कैरिना स्नीकर" ,
                'meta_description' => "प्यूमा महिला कैरिना स्नीकर" ,
                'description' => $description ,
                'overview' => $productOverviewHi ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],
            [
                'product_id' => 88630160 ,
                'title' => "किचन डाइनिंग रूम के लिए धातु की टांगों वाली कैंगलॉन्ग वेलवेट सीट चेयर, 2. बेज का सेट" ,
                'meta_title' => "किचन डाइनिंग रूम के लिए धातु की टांगों वाली कांगलोंग वेलवेट सीट कुर्सी, 2. बेज रंग का सेट" ,
                'meta_description' => "किचन डाइनिंग रूम के लिए धातु की टांगों वाली कांगलोंग वेलवेट सीट चेयर, 2. बेज का सेट" ,
                'description' => $description ,
                'overview' => $productOverviewHi ,
                'badge' => 'फीचर्ड' ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],
            [
                'product_id' => 88630161 ,
                'title' => "होमसिक न्यू होम रीड डिफ्यूज़र" ,
                'meta_title' => "होमसिक न्यू होम रीड डिफ्यूज़र" ,
                'meta_description' => "होमसिक न्यू होम रीड डिफ्यूज़र" ,
                'description' => $description ,
                'overview' => $productOverviewHi ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],
            [
                'product_id' => 88630162 ,
                'title' => "ब्राउनी ब्रेटल शीला जी की लो कैलोरी, थिन स्वीट क्रिस्पी स्नैक एंड ट्रीट्स डेज़र्ट, हेल्दी चॉकलेट चिप और सॉल्टेड कारमेल, 20 ऑउंस, 20 का पैक" ,
                'meta_title' => "ब्राउनी ब्रेटल शीला जी की लो कैलोरी, थिन स्वीट क्रिस्पी स्नैक एंड ट्रीट्स डेजर्ट, हेल्दी चॉकलेट चिप और सॉल्टेड कैरेमल, 20 ऑउंस, 20 का पैक" ,
                'meta_description' => "ब्राउनी ब्रिटल शीला जी की लो कैलोरी, थिन स्वीट क्रिस्पी स्नैक एंड ट्रीट्स डेजर्ट, हेल्दी चॉकलेट चिप और सॉल्टेड कैरमेल, 20 ऑउंस, 20 का पैक" ,
                'description' => $description ,
                'overview' => $productOverviewHi ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],
            [
                'product_id' => 88630163 ,
                'title' => "नॉन-स्टिक सौते पैन, रैपिड नूडल्स कुकर, स्टेक, अंडा, फ्राइड राइस, रेमन, ओटमील, पावर एडजस्टमेंट वाला सूप, सीफोम ग्रीन के लिए 1.5 लीटर मिनी पॉट" ,
                'meta_title' => "नॉन-स्टिक सौते पैन, रैपिड नूडल्स कुकर, स्टेक, अंडा, फ्राइड राइस, रेमन, ओटमील, पावर एडजस्टमेंट वाला सूप, सीफोम ग्रीन के लिए 1.5 लीटर मिनी पॉट" ,
                'meta_description' => "नॉन-स्टिक सौते पैन, रैपिड नूडल्स कुकर, स्टीक, अंडा, फ्राइड राइस, रेमन, ओटमील, पावर एडजस्टमेंट वाला सूप, सीफोम ग्रीन के लिए 1.5 लीटर मिनी पॉट" ,
                'description' => $description ,
                'overview' => $productOverviewHi ,
                'Unit' => 'टुकड़ा' ,
                'lang' => 'hi' ,
            ],




            [
                'product_id' => 88630111,
                'title' => "كنزة صوفية فضفاضة للنساء بأكمام طويلة وسحّاب ورباط",
                'meta_title' => "كنزة صوفية فضفاضة للنساء بأكمام طويلة وسحّاب ورباط",
                'description' => $description,
                'meta_description' => "كنزة صوفية فضفاضة للنساء بأكمام طويلة وسحّاب ورباط",
                'overview' => $productOverviewAr,
                'badge' => 'جديد',
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],
            [
                'product_id' => 88630112,
                'title' => "بلايز قمصان متماسكة عادية كشكش بأكمام قصيرة بلوزة مستديرة الرقبة تونك تانك توب تي شيرت للنساء",
                'meta_title' => "بلايز قمصان متماسكة عادية كشكش بأكمام قصيرة بلوزة مستديرة الرقبة تونك تانك توب تي شيرت للنساء",
                'meta_description' => "بلايز قمصان متماسكة عادية كشكش بأكمام قصيرة بلوزة مستديرة الرقبة تونك تانك توب تي شيرت للنساء",
                'description' => $description,
                'overview' => $productOverviewAr,
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],
            [
                'product_id' => 88630113,
                'title' => "أندون بلوزة قميص بأكمام طويلة وياقة مكشكشة بلون سادة ورقبة على شكل V وأكمام قصيرة",
                'meta_title' => "أندون بلوزة قميص بأكمام طويلة وياقة مكشكشة بلون سادة ورقبة على شكل V وأكمام قصيرة",
                'description' => $description,
                'meta_description' => "أندون بلوزة قميص بأكمام طويلة وياقة مكشكشة بلون سادة ورقبة على شكل V وأكمام قصيرة",
                'overview' => $productOverviewAr,
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],
            [
                'product_id' => 88630114,
                'title' => "المرأة المتماسكة الهراء بلوزة بالون طويلة الأكمام الدانتيل قمم عارضة فضفاض تي شيرت",
                'meta_title' => "المرأة المتماسكة الهراء بلوزة بالون طويلة الأكمام الدانتيل قمم عارضة فضفاض تي شيرت",
                'description' => $description,
                'meta_description' => "المرأة المتماسكة الهراء بلوزة بالون طويلة الأكمام الدانتيل قمم عارضة فضفاض تي شيرت",
                'overview' => $productOverviewAr,
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],
            [
                'product_id' => 88630115,
                'title' => "المرأة الكشكشة الأكمام قمم الصيف عارضة بلوزة طاقم الرقبة الصلبة لطيف تونك القميص",
                'meta_title' => "المرأة الكشكشة الأكمام قمم الصيف عارضة بلوزة طاقم الرقبة الصلبة لطيف تونك القميص",
                'description' => $description,
                'meta_description' => "المرأة الكشكشة الأكمام قمم الصيف عارضة بلوزة طاقم الرقبة الصلبة لطيف تونك القميص",
                'overview' => $productOverviewAr,
                'badge' => 'متميز',
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],
            [
                'product_id' => 88630116,
                'title' => "تونيك الأزهار النسائية بلوزة عادية الخامس الرقبة قصيرة الأكمام أزرار حتى القمصان",
                'meta_title' => "تونيك الأزهار النسائية بلوزة عادية الخامس الرقبة قصيرة الأكمام أزرار حتى القمصان",
                'description' => $description,
                'meta_description' => "تونيك الأزهار النسائية بلوزة عادية الخامس الرقبة قصيرة الأكمام أزرار حتى القمصان",
                'overview' => $productOverviewAr,
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],
            [
                'product_id' => 88630117,
                'title' => "المرأة عارضة بلايز ليوبارد طباعة تي شيرت طويلة الأكمام لينة بسط التمويه بلوزة القمصان",
                'meta_title' => "المرأة عارضة بلايز ليوبارد طباعة تي شيرت طويلة الأكمام لينة بسط التمويه بلوزة القمصان",
                'description' => $description,
                'meta_description' => "المرأة عارضة بلايز ليوبارد طباعة تي شيرت طويلة الأكمام لينة بسط التمويه بلوزة القمصان",
                'overview' => $productOverviewAr,
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],
            [
                'product_id' => 88630118,
                'title' => "فستان تونك صيفي للسيدات من أموري برقبة على شكل حرف V فساتين متغيرة فضفاضة غير رسمية",
                'meta_title' => "فستان تونك صيفي للسيدات من أموري برقبة على شكل حرف V فساتين متغيرة فضفاضة غير رسمية",
                'description' => $description,
                'meta_description' => "فستان تونك صيفي للسيدات من أموري برقبة على شكل حرف V فساتين متغيرة فضفاضة غير رسمية",
                'overview' => $productOverviewAr,
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],

            [
                'product_id' => 88630119,
                'title' => "فستان تونك صيفي للسيدات من أموري برقبة على شكل حرف V فساتين متغيرة فضفاضة غير رسمية",
                'meta_title' => "فستان تونك صيفي للسيدات من أموري برقبة على شكل حرف V فساتين متغيرة فضفاضة غير رسمية",
                'description' => $description,
                'meta_description' => "فستان تونك صيفي للسيدات من أموري برقبة على شكل حرف V فساتين متغيرة فضفاضة غير رسمية",
                'overview' => $productOverviewAr,
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],
            [
                'product_id' => 88630120,
                'title' => "فساتين نسائية غير رسمية للخريف برقبة على شكل حرف V وربطة عنق وأكمام طويلة وخصر عالٍ ومنقط مكشكش متدرج على شكل حرف A فستان قصير سوينغ سادة",
                'meta_title' => "فساتين نسائية غير رسمية للخريف برقبة على شكل حرف V وربطة عنق وأكمام طويلة وخصر عالٍ ومنقط مكشكش متدرج على شكل حرف A فستان قصير سوينغ سادة",
                'description' => $description,
                'meta_description' => "فساتين نسائية غير رسمية للخريف برقبة على شكل حرف V وربطة عنق وأكمام طويلة وخصر عالٍ ومنقط مكشكش متدرج على شكل حرف A فستان قصير سوينغ سادة",
                'overview' => $productOverviewAr,
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],
            [
                'product_id' => 88630121,
                'title' => "طبقة نسائية تونك بياقة دائرية مكشكشة فضفاضة منفوشة بيبي دول سوينغ ميني الفساتين",
                'meta_title' => "طبقة نسائية تونك بياقة دائرية مكشكشة فضفاضة منفوشة بيبي دول سوينغ ميني الفساتين",
                'description' => $description,
                'meta_description' => "طبقة نسائية تونك بياقة دائرية مكشكشة فضفاضة منفوشة بيبي دول سوينغ ميني الفساتين",
                'overview' => $productOverviewAr,
                'badge' => 'جديد',
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],
            [
                'product_id' => 88630122,
                'title' => "6 ازواج من الجوارب المنخفضة قطع من بوما للاطفال",
                'meta_title' => "6 ازواج من الجوارب المنخفضة قطع من بوما للاطفال",
                'description' => $description,
                'meta_description' => "6 ازواج من الجوارب المنخفضة قطع من بوما للاطفال",
                'overview' => $productOverviewAr,
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],
            [
                'product_id' => 88630123,
                'title' => "3 أزواج من الجوارب ثلاثية المخططة فوق الركبة ، جوارب طويلة جدًا غير شفافة فوق الفخذ",
                'meta_title' => "3 أزواج من الجوارب ثلاثية المخططة فوق الركبة ، جوارب طويلة جدًا غير شفافة فوق الفخذ",
                'description' => $description,
                'meta_description' => "3 أزواج من الجوارب ثلاثية المخططة فوق الركبة ، جوارب طويلة جدًا غير شفافة فوق الفخذ",
                'overview' => $productOverviewAr,
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],
            [
                'product_id' => 88630124,
                'title' => "4 عبوات طماق مع جيوب للنساء ، سروال يوجا للتمارين الرياضية بخصر مرتفع للتحكم في البطن",
                'meta_title' => "4 عبوات طماق مع جيوب للنساء ، سروال يوجا للتمارين الرياضية بخصر مرتفع للتحكم في البطن",
                'description' => $description,
                'meta_description' => "4 عبوات طماق مع جيوب للنساء ، سروال يوجا للتمارين الرياضية بخصر مرتفع للتحكم في البطن",
                'overview' => $productOverviewAr,
                'badge' => 'الشائع',
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],
            [
                'product_id' => 88630125,
                'title' => "مجموعة إعادة نمو المرأة بالإضافة إلى: شامبو ، بلسم ، 2٪ مينوكسيديل ، رغوة تترك على الشعر. محلول مضاد لتساقط الشعر وترقق الشعر للنساء ، لمدة شهر",
                'meta_title' => "مجموعة إعادة نمو المرأة بالإضافة إلى: شامبو ، بلسم ، 2٪ مينوكسيديل ، رغوة تترك على الشعر. محلول مضاد لتساقط الشعر وترقق الشعر للنساء ، لمدة شهر",
                'description' => $description,
                'meta_description' => "مجموعة إعادة نمو المرأة بالإضافة إلى: شامبو ، بلسم ، 2٪ مينوكسيديل ، رغوة تترك على الشعر. محلول مضاد لتساقط الشعر وترقق الشعر للنساء ، لمدة شهر",
                'overview' => $productOverviewAr,
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],
            [
                'product_id' => 88630126,
                'title' => "نمو شعر طبيعي للنساء لشعر أقوى وأسمك (4 كبسولات في اليوم) (تكفي لمدة شهر)",
                'meta_title' => "نمو شعر طبيعي للنساء لشعر أقوى وأسمك (4 كبسولات في اليوم) (تكفي لمدة شهر)",
                'description' => $description,
                'meta_description' => "نمو شعر طبيعي للنساء لشعر أقوى وأسمك (4 كبسولات في اليوم) (تكفي لمدة شهر)",
                'overview' => $productOverviewAr,
                'badge' => 'جديد',
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],
            [
                'product_id' => 88630127,
                'title' => "مناديل مبللة مهبلية طبية مضادة للحكة من فاجيسيل ، قوة قصوى ، راحة فورية ، عبوة من 3 إلى 60 مناديل مبللة (قد تختلف العبوة)",
                'meta_title' => "مناديل مبللة مهبلية طبية مضادة للحكة من فاجيسيل ، قوة قصوى ، راحة فورية ، عبوة من 3 إلى 60 مناديل مبللة (قد تختلف العبوة)",
                'description' => $description,
                'meta_description' => "مناديل مبللة مهبلية طبية مضادة للحكة من فاجيسيل ، قوة قصوى ، راحة فورية ، عبوة من 3 إلى 60 مناديل مبللة (قد تختلف العبوة)",
                'overview' => $productOverviewAr,
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],
            [
                'product_id' => 88630128,
                'title' => "مجموعة ترطيب جيت سيت ، مجموعة العناية بالبشرة سهلة السفر ، منظف ، بلسم ، مرطب ، كريم للعين وكريم ليلي",
                'meta_title' => "مجموعة ترطيب جيت سيت ، مجموعة العناية بالبشرة سهلة السفر ، منظف ، بلسم ، مرطب ، كريم للعين وكريم ليلي",
                'description' => $description,
                'meta_description' => "مجموعة ترطيب جيت سيت ، مجموعة العناية بالبشرة سهلة السفر ، منظف ، بلسم ، مرطب ، كريم للعين وكريم ليلي",
                'overview' => $productOverviewAr,
                'badge' => 'جديد',
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],
            [
                'product_id' => 88630129,
                'title' => "السحر | مقشر لتجديد الجلد | مباشرة من السبا | يشد المسام ويفتح البشرة | خالي من البارابين ، خالي من القسوة",
                'meta_title' => "السحر | مقشر لتجديد الجلد | مباشرة من السبا | يشد المسام ويفتح البشرة | خالي من البارابين ، خالي من القسوة",
                'description' => $description,
                'meta_description' => "السحر | مقشر لتجديد الجلد | مباشرة من السبا | يشد المسام ويفتح البشرة | خالي من البارابين ، خالي من القسوة",
                'overview' => $productOverviewAr,
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],
            [
                'product_id' => 88630130,
                'title' => "مجموعة المبتدئين للعناية اليومية بالترطيب الثنائي (مرطب حيوي وحمض الفيروليك + فيتامينات C و E) يساعد في الحفاظ على الخطوط الدقيقة والترطيب وتفاوت لون البشرة.",
                'meta_title' => "مجموعة المبتدئين للعناية اليومية بالترطيب الثنائي (مرطب حيوي وحمض الفيروليك + فيتامينات C و E) يساعد في الحفاظ على الخطوط الدقيقة والترطيب وتفاوت لون البشرة.",
                'description' => $description,
                'meta_description' => "مجموعة المبتدئين للعناية اليومية بالترطيب الثنائي (مرطب حيوي وحمض الفيروليك + فيتامينات C و E) يساعد في الحفاظ على الخطوط الدقيقة والترطيب وتفاوت لون البشرة.",
                'overview' => $productOverviewAr,
                'badge' => 'جديد',
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],
            [
                'product_id' => 88630131,
                'title' => "منظف الوجه بالخلايا الجذعية من إيمج سكين كير ، 4 أونصة سائلة",
                'meta_title' => "منظف الوجه بالخلايا الجذعية من إيمج سكين كير ، 4 أونصة سائلة",
                'description' => $description,
                'meta_description' => "منظف الوجه بالخلايا الجذعية من إيمج سكين كير ، 4 أونصة سائلة",
                'overview' => $productOverviewAr,
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],
            [
                'product_id' => 88630132,
                'title' => "حقيبة حبال قماش كروس بودي حقيبة كتف حقيبة سفر حقائب نهارية عادية",
                'meta_title' => "حقيبة حبال قماش كروس بودي حقيبة كتف حقيبة سفر حقائب نهارية عادية",
                'description' => $description,
                'meta_description' => "حقيبة حبال قماش كروس بودي حقيبة كتف حقيبة سفر حقائب نهارية عادية",
                'overview' => $productOverviewAr,
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],
            [
                'product_id' => 88630133,
                'title' => "نوتيكا دايفر نايلون للنساء حقيبة كروسبودي صغيرة مع حزام كتف قابل للتعديل",
                'meta_title' => "نوتيكا دايفر نايلون للنساء حقيبة كروسبودي صغيرة مع حزام كتف قابل للتعديل",
                'description' => $description,
                'meta_description' => "نوتيكا دايفر نايلون للنساء حقيبة كروسبودي صغيرة مع حزام كتف قابل للتعديل",
                'overview' => $productOverviewAr,
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],
            [
                'product_id' => 88630134,
                'title' => "آنا من أنوشكا حقيبة يد | جلدية حقيقية",
                'meta_title' => "آنا من أنوشكا حقيبة يد | جلدية حقيقية",
                'description' => $description,
                'meta_description' => "آنا من أنوشكا حقيبة يد | جلدية حقيقية",
                'overview' => $productOverviewAr,
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],
            [
                'product_id' => 88630135,
                'title' => "حامل شارة الهوية قابل للسحب ذاتيًا ، هيكل معدني شديد التحمل ، سلك فولاذي 30 بوصة ، سلسلة مفاتيح من سلسلة مع مشبك حزام ، تحمل ما يصل إلى 15 مفتاحًا وأدوات",
                'meta_title' => "حامل شارة الهوية قابل للسحب ذاتيًا ، هيكل معدني شديد التحمل ، سلك فولاذي 30 بوصة ، سلسلة مفاتيح من سلسلة مع مشبك حزام ، تحمل ما يصل إلى 15 مفتاحًا وأدوات",
                'description' => $description,
                'meta_description' => "حامل شارة الهوية قابل للسحب ذاتيًا ، هيكل معدني شديد التحمل ، سلك فولاذي 30 بوصة ، سلسلة مفاتيح من سلسلة مع مشبك حزام ، تحمل ما يصل إلى 15 مفتاحًا وأدوات",
                'overview' => $productOverviewAr,
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],
            [
                'product_id' => 88630136,
                'title' => "نظارات حماية من الضباب للرجال والنساء",
                'meta_title' => "نظارات حماية من الضباب للرجال والنساء",
                'description' => $description,
                'meta_description' => "نظارات حماية من الضباب للرجال والنساء",
                'overview' => $productOverviewAr,
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],
            [
                'product_id' => 88630137,
                'title' => "جاكيت قميص جيرني مان الأسطوري للرجال",
                'meta_title' => "جاكيت قميص جيرني مان الأسطوري للرجال",
                'description' => $description,
                'meta_description' => "جاكيت قميص جيرني مان الأسطوري للرجال",
                'overview' => $productOverviewAr,
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],
            [
                'product_id' => 88630138,
                'title' => "قميص رانجلر الرجالي ذو قصة كاوبوي الغربية بأكمام طويلة المفاجئة بتصميم متين",
                'meta_title' => "قميص رانجلر الرجالي ذو قصة كاوبوي الغربية بأكمام طويلة المفاجئة بتصميم متين",
                'meta_description' => "قميص رانجلر الرجالي ذو قصة كاوبوي الغربية بأكمام طويلة المفاجئة بتصميم متين",
                'description' => $description,
                'overview' => $productOverviewAr,
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],
            [
                'product_id' => 88630139,
                'title' => "قميص رجالي طويل الأكمام سيغنتشر كومفورت فليكس",
                'meta_title' => "قميص رجالي طويل الأكمام سيغنتشر كومفورت فليكس",
                'meta_description' => "قميص رجالي طويل الأكمام سيغنتشر كومفورت فليكس",
                'description' => $description,
                'overview' => $productOverviewAr,
                'badge' => 'الشائع',
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],

            [
                'product_id' => 88630140,
                'title' => "قميص أكسفورد منقوش بأكمام طويلة ونحيف للرجال",
                'meta_title' => "قميص أكسفورد منقوش بأكمام طويلة ونحيف للرجال",
                'meta_description' => "قميص أكسفورد منقوش بأكمام طويلة ونحيف للرجال",
                'description' => $description,
                'overview' => $productOverviewAr,
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],

            [
                'product_id' => 88630141,
                'title' => "جاكيت شيربا مبطن بقلنسوة للرجال من ديكييس",
                'meta_title' => "جاكيت شيربا مبطن بقلنسوة للرجال من ديكييس",
                'meta_description' => "جاكيت شيربا مبطن بقلنسوة للرجال من ديكييس",
                'description' => $description,
                'overview' => $productOverviewAr,
                'badge' => 'الشائع',
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],
            [
                'product_id' => 88630142,
                'title' => "جاكيت كارهارت مبطّن حراريًا للرجال J131 (مقاسات عادية وكبيرة وطويلة)",
                'meta_title' => "جاكيت كارهارت مبطّن حراريًا للرجال J131 (مقاسات عادية وكبيرة وطويلة)",
                'meta_description' => "جاكيت كارهارت مبطّن حراريًا للرجال J131 (مقاسات عادية وكبيرة وطويلة)",
                'description' => $description,
                'overview' => $productOverviewAr,
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],
            [
                'product_id' => 88630143,
                'title' => "جاكيت باودر لايت من كولومبيا للرجال",
                'meta_title' => "جاكيت باودر لايت من كولومبيا للرجال",
                'meta_description' => "جاكيت باودر لايت من كولومبيا للرجال",
                'description' => $description,
                'overview' => $productOverviewAr,
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],
            [
                'product_id' => 88630144,
                'title' => "جاك وولفسكين المرأة المضطربة",
                'meta_title' => "جاك وولفسكين المرأة المضطربة",
                'meta_description' => "جاك وولفسكين المرأة المضطربة",
                'description' => $description,
                'overview' => $productOverviewAr,
                'badge' => 'الشائع',
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],
            [
                'product_id' => 88630145,
                'title' => "مقاس IV مريح للرجال ومقاسات كبيرة وطويلة",
                'meta_title' => "مقاس IV مريح للرجال ومقاسات كبيرة وطويلة",
                'meta_description' => "مقاس IV مريح للرجال ومقاسات كبيرة وطويلة",
                'description' => $description,
                'overview' => $productOverviewAr,
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],
            [
                'product_id' => 88630146,
                'title' => "جلد ثلاثي الطي للرجال مع محفظة نافذة الهوية",
                'meta_title' => "جلد ثلاثي الطي للرجال مع محفظة نافذة الهوية",
                'meta_description' => "جلد ثلاثي الطي للرجال مع محفظة نافذة الهوية",
                'description' => $description,
                'overview' => $productOverviewAr,
                'badge' => 'الشائع',
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],
            [
                'product_id' => 88630147,
                'title' => "حقيبة ظهر كارهارت ليجاسي ديلوكس للعمل مع حجرة كمبيوتر محمول مقاس 17 بوصة ، كارهارت براون",
                'meta_title' => "حقيبة ظهر كارهارت ليجاسي ديلوكس للعمل مع حجرة كمبيوتر محمول مقاس 17 بوصة ، كارهارت براون",
                'meta_description' => "حقيبة ظهر كارهارت ليجاسي ديلوكس للعمل مع حجرة كمبيوتر محمول مقاس 17 بوصة ، كارهارت براون",
                'description' => $description,
                'overview' => $productOverviewAr,
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],
            [
                'product_id' => 88630148,
                'title' => "حقيبة ظهر هيرشل كلاسيك ، آش روز ، حجم متوسط 18.0 لتر",
                'meta_title' => "حقيبة ظهر هيرشل كلاسيك ، آش روز ، حجم متوسط 18.0 لتر",
                'meta_description' => "حقيبة ظهر هيرشل كلاسيك ، آش روز ، حجم متوسط 18.0 لتر",
                'description' => $description,
                'overview' => $productOverviewAr,
                'badge' => 'الشائع',
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],
            [
                'product_id' => 88630149,
                'title' => "حقيبة ظهر نسائية من القطن في الحرم الجامعي",
                'meta_title' => "حقيبة ظهر نسائية من القطن في الحرم الجامعي",
                'meta_description' => "حقيبة ظهر نسائية من القطن في الحرم الجامعي",
                'description' => $description,
                'overview' => $productOverviewAr,
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],
            [
                'product_id' => 88630150,
                'title' => "حقيبة 17.3 بوصة للنساء ، حقيبة عمل متعددة الجيوب ، حقائب كمبيوتر مكتبية واسعة ، حقيبة كمبيوتر محمول ، حقيبة سفر للعمل ، قهوة - 17.3 بوصة",
                'meta_title' => "حقيبة 17.3 بوصة للنساء ، حقيبة عمل متعددة الجيوب ، حقائب كمبيوتر مكتبية واسعة ، حقيبة كمبيوتر محمول ، حقيبة سفر للعمل ، قهوة - 17.3 بوصة",
                'meta_description' => "حقيبة 17.3 بوصة للنساء ، حقيبة عمل متعددة الجيوب ، حقائب كمبيوتر مكتبية واسعة ، حقيبة كمبيوتر محمول ، حقيبة سفر للعمل ، قهوة - 17.3 بوصة",
                'description' => $description,
                'overview' => $productOverviewAr,
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],
            [
                'product_id' => 88630151,
                'title' => "حقيبة ظهر للكمبيوتر المحمول صديقة للبيئة: مصنوعة من زجاجات بلاستيك بولي ايثيلين تيريفثالات معاد تدويرها",
                'meta_title' => "حقيبة ظهر للكمبيوتر المحمول صديقة للبيئة: مصنوعة من زجاجات بلاستيك بولي ايثيلين تيريفثالات معاد تدويرها",
                'meta_description' => "حقيبة ظهر للكمبيوتر المحمول صديقة للبيئة: مصنوعة من زجاجات بلاستيك بولي ايثيلين تيريفثالات معاد تدويرها",
                'description' => $description,
                'overview' => $productOverviewAr,
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],
            [
                'product_id' => 88630152,
                'title' => "حقيبة ظهر للكمبيوتر المحمول من سولو نيو يورك ريجن ، رمادي",
                'meta_title' => "حقيبة ظهر للكمبيوتر المحمول من سولو نيو يورك ريجن ، رمادي",
                'meta_description' => "حقيبة ظهر للكمبيوتر المحمول من سولو نيو يورك ريجن ، رمادي",
                'description' => $description,
                'overview' => $productOverviewAr,
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],
            [
                'product_id' => 88630153,
                'title' => "حقيبة كمبيوتر محمول للنساء حقيبة ظهر للعمل محفظة سفر حقيبة كتب حقيبة مدرسية للممرضات",
                'meta_title' => "حقيبة كمبيوتر محمول للنساء حقيبة ظهر للعمل محفظة سفر حقيبة كتب حقيبة مدرسية للممرضات",
                'meta_description' => "حقيبة كمبيوتر محمول للنساء حقيبة ظهر للعمل محفظة سفر حقيبة كتب حقيبة مدرسية للممرضات",
                'description' => $description,
                'overview' => $productOverviewAr,
                'badge' => 'متميز',
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],
            [
                'product_id' => 88630154,
                'title' => "مناديل تنظيف الوجه لإزالة المكياج من نيوتروجينا ، مناديل يومية للوجه تزيل الأوساخ والزيوت والمكياج وماسكارا مقاومة للماء ، لطيفة ، ملفوفة بشكل فردي ، ألياف نباتية 100٪ ، 20 قيراطًا",
                'meta_title' => "مناديل تنظيف الوجه لإزالة المكياج من نيوتروجينا ، مناديل يومية للوجه تزيل الأوساخ والزيوت والمكياج وماسكارا مقاومة للماء ، لطيفة ، ملفوفة بشكل فردي ، ألياف نباتية 100٪ ، 20 قيراطًا",
                'meta_description' => "مناديل تنظيف الوجه لإزالة المكياج من نيوتروجينا ، مناديل يومية للوجه تزيل الأوساخ والزيوت والمكياج وماسكارا مقاومة للماء ، لطيفة ، ملفوفة بشكل فردي ، ألياف نباتية 100٪ ، 20 قيراطًا",
                'description' => $description,
                'overview' => $productOverviewAr,
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],
            [
                'product_id' => 88630155,
                'title' => "سماعات رأس لايف كيو 20 هايبرد بخاصية إلغاء الضوضاء النشطة ، سماعات رأس لاسلكية تعمل بالبلوتوث ، وقت تشغيل 40 ساعة ، صوت عالي الدقة ، جهير عميق ، أكواب أذن ميموري فوم ، للسفر ، والمكتب المنزلي",
                'meta_title' => "سماعات رأس لايف كيو 20 هايبرد بخاصية إلغاء الضوضاء النشطة ، سماعات رأس لاسلكية تعمل بالبلوتوث ، وقت تشغيل 40 ساعة ، صوت عالي الدقة ، جهير عميق ، أكواب أذن ميموري فوم ، للسفر ، والمكتب المنزلي",
                'meta_description' => "سماعات رأس لايف كيو 20 هايبرد بخاصية إلغاء الضوضاء النشطة ، سماعات رأس لاسلكية تعمل بالبلوتوث ، وقت تشغيل 40 ساعة ، صوت عالي الدقة ، جهير عميق ، أكواب أذن ميموري فوم ، للسفر ، والمكتب المنزلي",
                'description' => $description,
                'overview' => $productOverviewAr,
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],
            [
                'product_id' => 88630156,
                'title' => "مجموعة أساسيات الحمل من ماما ميو",
                'meta_title' => "مجموعة أساسيات الحمل من ماما ميو",
                'meta_description' => "مجموعة أساسيات الحمل من ماما ميو",
                'description' => $description,
                'overview' => $productOverviewAr,
                'badge' => 'متميز',
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],
            [
                'product_id' => 88630157,
                'title' => "صندوق هدايا أنيق للأمهات الجدد - 10 عناصر فريدة للعناية الشخصية بعد الولادة للأمهات - سلة مفاجآت التدليل للأم",
                'meta_title' => "صندوق هدايا أنيق للأمهات الجدد - 10 عناصر فريدة للعناية الشخصية بعد الولادة للأمهات - سلة مفاجآت التدليل للأم",
                'meta_description' => "صندوق هدايا أنيق للأمهات الجدد - 10 عناصر فريدة للعناية الشخصية بعد الولادة للأمهات - سلة مفاجآت التدليل للأم",
                'description' => $description,
                'overview' => $productOverviewAr,
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],
            [
                'product_id' => 88630158,
                'title' => "حذاء رياضي سترايد رايت للجنسين للأطفال",
                'meta_title' => "حذاء رياضي سترايد رايت للجنسين للأطفال",
                'meta_description' => "حذاء رياضي سترايد رايت للجنسين للأطفال",
                'description' => $description,
                'overview' => $productOverviewAr,
                'badge' => 'جديد',
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],
            [
                'product_id' => 88630159,
                'title' => "حذاء كارينا الرياضي من بوما للنساء",
                'meta_title' => "حذاء كارينا الرياضي من بوما للنساء",
                'meta_description' => "حذاء كارينا الرياضي من بوما للنساء",
                'description' => $description,
                'overview' => $productOverviewAr,
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],
            [
                'product_id' => 88630160,
                'title' => "كرسي مقعد مخملي مع أرجل معدنية لغرفة طعام المطبخ ، طقم من 2. بيج",
                'meta_title' => "كرسي مقعد مخملي مع أرجل معدنية لغرفة طعام المطبخ ، طقم من 2. بيج",
                'meta_description' => "كرسي مقعد مخملي مع أرجل معدنية لغرفة طعام المطبخ ، طقم من 2. بيج",
                'description' => $description,
                'overview' => $productOverviewAr,
                'badge' => 'متميز',
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],
            [
                'product_id' => 88630161,
                'title' => "المنزل الجديد ريد الناشر",
                'meta_title' => "المنزل الجديد ريد الناشر",
                'meta_description' => "المنزل الجديد ريد الناشر",
                'description' => $description,
                'overview' => $productOverviewAr,
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],
            [
                'product_id' => 88630162,
                'title' => "سعرات حرارية قليلة هش شيلا جي ، وجبة خفيفة مقرمشة رفيعة ورائعة وحلوى ، رقائق شوكولاتة صحية وكراميل مملح ، 20 أونصة ، عبوة من 20",
                'meta_title' => "سعرات حرارية قليلة هش شيلا جي ، وجبة خفيفة مقرمشة رفيعة ورائعة وحلوى ، رقائق شوكولاتة صحية وكراميل مملح ، 20 أونصة ، عبوة من 20",
                'meta_description' => "سعرات حرارية قليلة هش شيلا جي ، وجبة خفيفة مقرمشة رفيعة ورائعة وحلوى ، رقائق شوكولاتة صحية وكراميل مملح ، 20 أونصة ، عبوة من 20",
                'description' => $description,
                'overview' => $productOverviewAr,
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],
            [
                'product_id' => 88630163,
                'title' => "مقلاة غير لاصقة ، طباخ نودلز سريع ، وعاء صغير 1.5 لتر للستيك ، بيض ، أرز مقلي ، رامين ، دقيق الشوفان ، شوربة مع تعديل الطاقة ، أخضر",
                'meta_title' => "مقلاة غير لاصقة ، طباخ نودلز سريع ، وعاء صغير 1.5 لتر للستيك ، بيض ، أرز مقلي ، رامين ، دقيق الشوفان ، شوربة مع تعديل الطاقة ، أخضر",
                'meta_description' => "مقلاة غير لاصقة ، طباخ نودلز سريع ، وعاء صغير 1.5 لتر للستيك ، بيض ، أرز مقلي ، رامين ، دقيق الشوفان ، شوربة مع تعديل الطاقة ، أخضر",
                'description' => $description,
                'overview' => $productOverviewAr,
                'unit' => 'قطعة',
                'lang' => 'ar',
            ],

        ];



        $product1 = Product::where('id', '88630156')->first();
        $product2 = Product::where('id', '88630150')->first();
        $product3 = Product::where('id', '88630143')->first();
        $product4 = Product::where('id', '88630139')->first();

        if (!ProductLang::first() && $product1 && $product2 && $product3 && $product4) {
            foreach ($items as $i) {
                ProductLang::create($i);
            }
        }

    }
}
