'use strict';
const MANIFEST = 'flutter-app-manifest';
const TEMP = 'flutter-temp-cache';
const CACHE_NAME = 'flutter-app-cache';

const RESOURCES = {"assets/AssetManifest.bin": "c708dd3d3cab0196c2ecbc4f3c92a720",
"assets/AssetManifest.bin.json": "264e0f890256b49a46824b6b388ff822",
"assets/AssetManifest.json": "ec449ea9cac1ebcf1c17d4b6b09eaba6",
"assets/assets/images/anestesia.png": "478e235d4bae489b0331a99b08cda2ab",
"assets/assets/images/asiento.png": "4b922d65ed165d01a9566b14e5fb6af9",
"assets/assets/images/birthday.png": "657bdd9cbf90538a35ea1899165ccefd",
"assets/assets/images/calendar.ico": "91f9a1da4c6340f28f56bbff614f535e",
"assets/assets/images/cama_paciente.png": "6c9324ea266329537eede78d470c8616",
"assets/assets/images/cargos.png": "38ad5e67ed9eb93aab680352962ca36c",
"assets/assets/images/carguito.png": "481550aeacfc6e6d6cb4d07fa4cac64f",
"assets/assets/images/carpeta.png": "369f9fc3bb56d8b1a1abd57a7eee294b",
"assets/assets/images/chart.png": "066a4309f69f893f27e62b299c3d0835",
"assets/assets/images/cliente123.png": "89605b4f1712fbe09653d3f244ffb96e",
"assets/assets/images/consulta.png": "9b6b80d80d8ad9238e723d3aff717a86",
"assets/assets/images/diagrama.jpg": "fc44c4632d08f2c725b37764bec00a0a",
"assets/assets/images/enfermera.png": "44ef45e45fb98b8e7c77b35d4d0a53d4",
"assets/assets/images/espera.png": "16b26b6a9c404565557ff92e0dfe6834",
"assets/assets/images/femenino.png": "3e9d45d1596cb2a6b3cf55b987aaf1f6",
"assets/assets/images/ficha.png": "f4b1a08fba4b20e9e1ec8403e14620e9",
"assets/assets/images/files.png": "3cabe14c75347965e33e57c09b1eacf6",
"assets/assets/images/files.svg": "993f9c54ca901c6445652e0d2da56e6c",
"assets/assets/images/folder.png": "cfcad851f8e1006f7bddc4ca653be3a5",
"assets/assets/images/folder2.ico": "453aeab00600c196d000f73af3b86e47",
"assets/assets/images/globos.png": "93d2cf27c9ef41b0410a06373658ab63",
"assets/assets/images/glucometro.png": "81433750f395880475eec88264257fe8",
"assets/assets/images/hospital.jpg": "3c8702dad392834d58c44f09adc519c3",
"assets/assets/images/lista.png": "044dcf1f02ea350e24b4b45bf00884c5",
"assets/assets/images/llamada.png": "4a7cba4952e800b051d8908f52ae45df",
"assets/assets/images/lock.png": "4143a2e4e2805d154de5300d0d936057",
"assets/assets/images/logo.png": "6009ec858783b33d626c4a8ca5ecd054",
"assets/assets/images/logoblanco.png": "15aeec232a4c8cf9b4238803e0630e58",
"assets/assets/images/masculino.png": "650b17c5b059aa899fd5513d802f65ed",
"assets/assets/images/medical.png": "d5d1e8f435350d72efa55b63ac87452e",
"assets/assets/images/micro.png": "5f753b3b03c2cb65ae40eeb4f710950a",
"assets/assets/images/monitor.png": "29b6a4adecc09e36bdaa58d92875debe",
"assets/assets/images/olivia.jpg": "4cdcd080fdd00244b5db3e33a86ab1c2",
"assets/assets/images/paciente.png": "295e453a8af69c597a4e2c7576b8fb92",
"assets/assets/images/phone.png": "2be89a4a8afe9bec63b402f2ded2272e",
"assets/assets/images/photo.png": "f6d40b7d2dc015165eeed0143e4b4b23",
"assets/assets/images/receta.png": "233a44504a5567db1e9902a9a4d1acee",
"assets/assets/images/sala.png": "f93963ec0546a4d0949848793f00ee33",
"assets/assets/images/schedule.png": "c19877bc83d2576664b6cef9a112103e",
"assets/assets/images/stats.png": "ab137abdae8f4e1259b4b1c7ead2530f",
"assets/assets/images/unknown.jpg": "467b62b7cac1d80ad81bacd771b58ecb",
"assets/assets/images/whatsapp.png": "9ff342815b1ad7805aa9b876f551ce6e",
"assets/FontManifest.json": "dc3d03800ccca4601324923c0b1d6d57",
"assets/fonts/MaterialIcons-Regular.otf": "bbc6988ea060a0451c943e7f0abe3b58",
"assets/NOTICES": "114b2131964dca5eb1a4eb595fd5b560",
"assets/packages/cool_alert/assets/flare/error_check.flr": "d9f54791d0d79935d22206966707e4b3",
"assets/packages/cool_alert/assets/flare/info_check.flr": "f6b81c2aa3ae36418c13bfd36d11ac04",
"assets/packages/cool_alert/assets/flare/loading.flr": "b6987a8e6de74062b8c002539d2d043e",
"assets/packages/cool_alert/assets/flare/success_check.flr": "9d163bcc6f6b58566e0abde7761a67a0",
"assets/packages/cool_alert/assets/flare/warning_check.flr": "ff4a110b8d905dedb4d4639a17399703",
"assets/packages/cupertino_icons/assets/CupertinoIcons.ttf": "87ce58930aec188b602582520c201bbf",
"assets/packages/fluttertoast/assets/toastify.css": "910ddaaf9712a0b0392cf7975a3b7fb5",
"assets/packages/fluttertoast/assets/toastify.js": "18cfdd77033aa55d215e8a78c090ba89",
"assets/shaders/ink_sparkle.frag": "ecc85a2e95f5e9f53123dcaf8cb9b6ce",
"canvaskit/canvaskit.js": "738255d00768497e86aa4ca510cce1e1",
"canvaskit/canvaskit.js.symbols": "74a84c23f5ada42fe063514c587968c6",
"canvaskit/canvaskit.wasm": "9251bb81ae8464c4df3b072f84aa969b",
"canvaskit/chromium/canvaskit.js": "901bb9e28fac643b7da75ecfd3339f3f",
"canvaskit/chromium/canvaskit.js.symbols": "ee7e331f7f5bbf5ec937737542112372",
"canvaskit/chromium/canvaskit.wasm": "399e2344480862e2dfa26f12fa5891d7",
"canvaskit/skwasm.js": "5d4f9263ec93efeb022bb14a3881d240",
"canvaskit/skwasm.js.symbols": "c3c05bd50bdf59da8626bbe446ce65a3",
"canvaskit/skwasm.wasm": "4051bfc27ba29bf420d17aa0c3a98bce",
"canvaskit/skwasm.worker.js": "bfb704a6c714a75da9ef320991e88b03",
"favicon.png": "5dcef449791fa27946b3d35ad8803796",
"flutter.js": "383e55f7f3cce5be08fcf1f3881f585c",
"flutter_bootstrap.js": "5957f51436292209b037776e17431fdd",
"icons/Icon-192.png": "ac9a721a12bbc803b44f645561ecb1e1",
"icons/Icon-512.png": "96e752610906ba2a93c65f8abe1645f1",
"icons/Icon-maskable-192.png": "c457ef57daa1d16f64b27b786ec2ea3c",
"icons/Icon-maskable-512.png": "301a7604d45b3e739efc881eb04896ea",
"index.html": "8b8586f8a2ab64de3d7d1dc30d3d69af",
"/": "8b8586f8a2ab64de3d7d1dc30d3d69af",
"main.dart.js": "067db6ff790d84f85e70e67861de34a2",
"manifest.json": "0c8d47b8bae7f1567154fbce20c688d0",
"version.json": "37a50795f33e3fa36fb41548fb804f39"};
// The application shell files that are downloaded before a service worker can
// start.
const CORE = ["main.dart.js",
"index.html",
"flutter_bootstrap.js",
"assets/AssetManifest.bin.json",
"assets/FontManifest.json"];

// During install, the TEMP cache is populated with the application shell files.
self.addEventListener("install", (event) => {
  self.skipWaiting();
  return event.waitUntil(
    caches.open(TEMP).then((cache) => {
      return cache.addAll(
        CORE.map((value) => new Request(value, {'cache': 'reload'})));
    })
  );
});
// During activate, the cache is populated with the temp files downloaded in
// install. If this service worker is upgrading from one with a saved
// MANIFEST, then use this to retain unchanged resource files.
self.addEventListener("activate", function(event) {
  return event.waitUntil(async function() {
    try {
      var contentCache = await caches.open(CACHE_NAME);
      var tempCache = await caches.open(TEMP);
      var manifestCache = await caches.open(MANIFEST);
      var manifest = await manifestCache.match('manifest');
      // When there is no prior manifest, clear the entire cache.
      if (!manifest) {
        await caches.delete(CACHE_NAME);
        contentCache = await caches.open(CACHE_NAME);
        for (var request of await tempCache.keys()) {
          var response = await tempCache.match(request);
          await contentCache.put(request, response);
        }
        await caches.delete(TEMP);
        // Save the manifest to make future upgrades efficient.
        await manifestCache.put('manifest', new Response(JSON.stringify(RESOURCES)));
        // Claim client to enable caching on first launch
        self.clients.claim();
        return;
      }
      var oldManifest = await manifest.json();
      var origin = self.location.origin;
      for (var request of await contentCache.keys()) {
        var key = request.url.substring(origin.length + 1);
        if (key == "") {
          key = "/";
        }
        // If a resource from the old manifest is not in the new cache, or if
        // the MD5 sum has changed, delete it. Otherwise the resource is left
        // in the cache and can be reused by the new service worker.
        if (!RESOURCES[key] || RESOURCES[key] != oldManifest[key]) {
          await contentCache.delete(request);
        }
      }
      // Populate the cache with the app shell TEMP files, potentially overwriting
      // cache files preserved above.
      for (var request of await tempCache.keys()) {
        var response = await tempCache.match(request);
        await contentCache.put(request, response);
      }
      await caches.delete(TEMP);
      // Save the manifest to make future upgrades efficient.
      await manifestCache.put('manifest', new Response(JSON.stringify(RESOURCES)));
      // Claim client to enable caching on first launch
      self.clients.claim();
      return;
    } catch (err) {
      // On an unhandled exception the state of the cache cannot be guaranteed.
      console.error('Failed to upgrade service worker: ' + err);
      await caches.delete(CACHE_NAME);
      await caches.delete(TEMP);
      await caches.delete(MANIFEST);
    }
  }());
});
// The fetch handler redirects requests for RESOURCE files to the service
// worker cache.
self.addEventListener("fetch", (event) => {
  if (event.request.method !== 'GET') {
    return;
  }
  var origin = self.location.origin;
  var key = event.request.url.substring(origin.length + 1);
  // Redirect URLs to the index.html
  if (key.indexOf('?v=') != -1) {
    key = key.split('?v=')[0];
  }
  if (event.request.url == origin || event.request.url.startsWith(origin + '/#') || key == '') {
    key = '/';
  }
  // If the URL is not the RESOURCE list then return to signal that the
  // browser should take over.
  if (!RESOURCES[key]) {
    return;
  }
  // If the URL is the index.html, perform an online-first request.
  if (key == '/') {
    return onlineFirst(event);
  }
  event.respondWith(caches.open(CACHE_NAME)
    .then((cache) =>  {
      return cache.match(event.request).then((response) => {
        // Either respond with the cached resource, or perform a fetch and
        // lazily populate the cache only if the resource was successfully fetched.
        return response || fetch(event.request).then((response) => {
          if (response && Boolean(response.ok)) {
            cache.put(event.request, response.clone());
          }
          return response;
        });
      })
    })
  );
});
self.addEventListener('message', (event) => {
  // SkipWaiting can be used to immediately activate a waiting service worker.
  // This will also require a page refresh triggered by the main worker.
  if (event.data === 'skipWaiting') {
    self.skipWaiting();
    return;
  }
  if (event.data === 'downloadOffline') {
    downloadOffline();
    return;
  }
});
// Download offline will check the RESOURCES for all files not in the cache
// and populate them.
async function downloadOffline() {
  var resources = [];
  var contentCache = await caches.open(CACHE_NAME);
  var currentContent = {};
  for (var request of await contentCache.keys()) {
    var key = request.url.substring(origin.length + 1);
    if (key == "") {
      key = "/";
    }
    currentContent[key] = true;
  }
  for (var resourceKey of Object.keys(RESOURCES)) {
    if (!currentContent[resourceKey]) {
      resources.push(resourceKey);
    }
  }
  return contentCache.addAll(resources);
}
// Attempt to download the resource online before falling back to
// the offline cache.
function onlineFirst(event) {
  return event.respondWith(
    fetch(event.request).then((response) => {
      return caches.open(CACHE_NAME).then((cache) => {
        cache.put(event.request, response.clone());
        return response;
      });
    }).catch((error) => {
      return caches.open(CACHE_NAME).then((cache) => {
        return cache.match(event.request).then((response) => {
          if (response != null) {
            return response;
          }
          throw error;
        });
      });
    })
  );
}
