/*
 * Decompiled with CFR 0.152.
 */
package com.app.clisist.controllers;

import com.app.clisist.Models.VitalesGravesModel;
import com.app.clisist.Services.VitalesGravesService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/v1/graves"})
public class VitalesGravesController {
    private final VitalesGravesService service;

    @Autowired
    public VitalesGravesController(VitalesGravesService service) {
        this.service = service;
    }

    @PostMapping(value={"/insertar"})
    ResponseEntity<VitalesGravesModel> insertarNota(@RequestBody VitalesGravesModel model) {
        return ResponseEntity.ok((Object)((VitalesGravesModel)this.service.save((Object)model)));
    }

    @GetMapping(value={"/nota/{idingreso}"})
    ResponseEntity<List<VitalesGravesModel>> getNotasGravesByIdPaciente(@PathVariable int idingreso) {
        Optional model = this.service.getVitalesGravesByIdIngreso(idingreso);
        return model.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build());
    }

    @PutMapping(value={"/update"})
    public ResponseEntity<VitalesGravesModel> EditarNota(@RequestBody VitalesGravesModel model) {
        try {
            this.service.updateVitalesGraves(model.getIdvitales_grave(), model.getObservaciones(), model.getFc(), model.getFr(), model.getPa(), model.getTemp(), model.getSaturacion(), model.getDiuresis(), model.getVomitos(), model.getIdmedico(), model.getTurno());
            return ResponseEntity.ok((Object)model);
        }
        catch (Exception e) {
            return ResponseEntity.status((int)500).body(null);
        }
    }
}

