/*
 * Decompiled with CFR 0.152.
 */
package com.app.clisist.controllers;

import com.app.clisist.Models.PacientesInternosPojo;
import com.app.clisist.Services.IngresoPacienteService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"api/v1/internamiento"})
public class PacientesInternosController {
    private final IngresoPacienteService service;

    @Autowired
    public PacientesInternosController(IngresoPacienteService service) {
        this.service = service;
    }

    @GetMapping(value={"/internados/{idtipo}"})
    ResponseEntity<List<PacientesInternosPojo>> getPacientesInternados(@PathVariable int idtipo) {
        Optional resultados = this.service.getPacientesInternados(idtipo);
        return resultados.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build());
    }

    @GetMapping(value={"/internados/nombre/{nombre}/{idtipo}"})
    ResponseEntity<List<PacientesInternosPojo>> getPacientesInternadosByNombre(@PathVariable String nombre, @PathVariable int idtipo) {
        Optional resultados = this.service.getPacientesInternadosByNombre(nombre, idtipo);
        return resultados.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build());
    }

    @GetMapping(value={"/internados_historial/nombre/{nombre}"})
    ResponseEntity<List<PacientesInternosPojo>> getPacientesInternadosHistorialByNombre(@PathVariable String nombre) {
        Optional resultados = this.service.getPacientesInternadosHistorialByNombre(nombre);
        return resultados.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build());
    }

    @PutMapping(value={"/update/grave/{grave}/{idingreso}"})
    public ResponseEntity<String> EditarGraves(@PathVariable int grave, @PathVariable int idingreso) {
        try {
            this.service.updateGraves(grave, idingreso);
            return ResponseEntity.ok((Object)"Actualizado correctamente");
        }
        catch (Exception e) {
            return ResponseEntity.status((int)500).body(null);
        }
    }
}

