/*
 * Decompiled with CFR 0.152.
 */
package com.app.clisist.controllers;

import com.app.clisist.Models.PacienteModel;
import com.app.clisist.Models.SalaEspera;
import com.app.clisist.Services.PacienteService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/v1/pacientes"})
public class PacienteController {
    private PacienteService service;

    @Autowired
    public PacienteController(PacienteService service) {
        this.service = service;
    }

    @GetMapping(value={"/limite/{limit}"})
    public ResponseEntity<List<PacienteModel>> retornarPacientesConLimite(@PathVariable(value="limit") int limit) {
        List pacientes = this.service.retornarPacientesConLimite(limit);
        if (pacientes.isEmpty()) {
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.ok((Object)pacientes);
    }

    @GetMapping(value={"/busqueda/{nombre}"})
    public ResponseEntity<List<PacienteModel>> buscarPacientePorNombre(@PathVariable(value="nombre") String nombre) {
        List pacientes = this.service.buscarPacientePorNombre(nombre);
        if (pacientes.isEmpty()) {
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.ok((Object)pacientes);
    }

    @GetMapping(value={"/obtener/sala/{idmedico}"})
    ResponseEntity<List<SalaEspera>> getConsultaByHoy(@PathVariable int idmedico) {
        Optional resultados = this.service.getSalaEsperaByidMedico(idmedico);
        return resultados.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build());
    }
}

