/*
 * Decompiled with CFR 0.152.
 */
package com.app.clisist.controllers;

import com.app.clisist.Models.MyTelegramBot;
import com.app.clisist.Models.NotaEvolucionModel;
import com.app.clisist.Models.PlanesPojo;
import com.app.clisist.Services.HabitacionService;
import com.app.clisist.Services.NotaEvolucionService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/v1/evolucion"})
public class NotaEvolucionController {
    @Autowired
    private MyTelegramBot myTelegramBot;
    private final NotaEvolucionService service;
    private final HabitacionService habitacionService;

    @Autowired
    public NotaEvolucionController(NotaEvolucionService service, HabitacionService habitacionService) {
        this.service = service;
        this.habitacionService = habitacionService;
    }

    @GetMapping(value={"/planes/{idingreso}"})
    ResponseEntity<List<PlanesPojo>> obtenerPlanes(@PathVariable int idingreso) {
        Optional model = this.service.obtenerPlanes(idingreso);
        return model.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build());
    }

    @GetMapping(value={"/nota/{idingreso}"})
    ResponseEntity<List<NotaEvolucionModel>> getNotaEvolucionByIdPaciente(@PathVariable int idingreso) {
        Optional model = this.service.getNotasByIdIngreso(idingreso);
        return model.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build());
    }

    @PostMapping(value={"/insertar/{medico}/{paciente}/{nrohab}/{alta}/{idingreso}"})
    ResponseEntity<NotaEvolucionModel> insertarNota(@RequestBody NotaEvolucionModel model, @PathVariable String medico, @PathVariable String paciente, @PathVariable String nrohab, @PathVariable int alta, @PathVariable int idingreso) {
        String chatId = "7366108718";
        String messageText = "Nueva nota de evolucion de :" + medico + "\nPaciente:" + paciente + "\nHabitacion nro:" + nrohab;
        this.myTelegramBot.sendNotification(chatId, messageText);
        if (alta == 1) {
            this.habitacionService.updateHabitacionV2(idingreso, "Alta");
        }
        return ResponseEntity.ok((Object)((NotaEvolucionModel)this.service.save((Object)model)));
    }

    @PutMapping(value={"/update"})
    public ResponseEntity<NotaEvolucionModel> EditarNota(@RequestBody NotaEvolucionModel model) {
        try {
            this.service.updateNotaEvolucion(model.getIdNotaEvolucion(), model.getSubjetivo(), model.getObjetivo(), model.getAnalisis(), model.getPlan(), model.getPronostico(), model.getLaboratorios(), model.getTemp(), model.getFc(), model.getPa(), model.getFr(), model.getOximetria(), model.getGlucosa(), model.getAlta());
            return ResponseEntity.ok((Object)model);
        }
        catch (Exception e) {
            return ResponseEntity.status((int)500).body(null);
        }
    }
}

