/*
 * Decompiled with CFR 0.152.
 */
package com.app.clisist.controllers;

import com.app.clisist.Models.NotaEnfermeriaModel;
import com.app.clisist.Models.PlanesPojo;
import com.app.clisist.Services.NotaEnfermeriaService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/v1/enfermeria"})
public class NotaEnfermeriaController {
    private final NotaEnfermeriaService service;

    @Autowired
    public NotaEnfermeriaController(NotaEnfermeriaService service) {
        this.service = service;
    }

    @GetMapping(value={"/planes/{idingreso}"})
    ResponseEntity<List<PlanesPojo>> obtenerPlanes(@PathVariable int idingreso) {
        Optional model = this.service.obtenerPlanes(idingreso);
        return model.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build());
    }

    @GetMapping(value={"/nota/{idingreso}"})
    ResponseEntity<List<NotaEnfermeriaModel>> getNotaEnfermeriaByIdPaciente(@PathVariable int idingreso) {
        Optional model = this.service.getNotasByIdIngreso(idingreso);
        return model.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build());
    }

    @PostMapping(value={"/insertar"})
    ResponseEntity<NotaEnfermeriaModel> insertarNota(@RequestBody NotaEnfermeriaModel model) {
        return ResponseEntity.ok((Object)((NotaEnfermeriaModel)this.service.save((Object)model)));
    }

    @PutMapping(value={"/update"})
    public ResponseEntity<NotaEnfermeriaModel> EditarNota(@RequestBody NotaEnfermeriaModel model) {
        try {
            this.service.updateNotaEnfermeria(model.getIdnotaenfermeria(), model.getObservacion(), model.getExploracion(), model.getTurno(), model.getTemp(), model.getFc(), model.getPa(), model.getFr(), model.getOximetria(), model.getGlucosa());
            return ResponseEntity.ok((Object)model);
        }
        catch (Exception e) {
            return ResponseEntity.status((int)500).body(null);
        }
    }
}

