/*
 * Decompiled with CFR 0.152.
 */
package com.app.clisist.controllers;

import com.app.clisist.Models.MedicamentoDTO;
import com.app.clisist.Services.MedicamentosService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/v1/medicamentos"})
public class MedicamentoController {
    private final MedicamentosService service;

    @Autowired
    public MedicamentoController(MedicamentosService service) {
        this.service = service;
    }

    @GetMapping(value={"/obtener/{activo}"})
    ResponseEntity<List<MedicamentoDTO>> getMedicamentosActivos(@PathVariable int activo) {
        Optional model = this.service.getMedicamentosWithConfig(activo);
        return model.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build());
    }
}

