/*
 * Decompiled with CFR 0.152.
 */
package com.app.clisist.controllers;

import com.app.clisist.Models.LaboratorioModel;
import com.app.clisist.Services.LaboratoriosService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"api/v1/laboratorios"})
public class LaboratorioController {
    private final LaboratoriosService service;

    @Autowired
    public LaboratorioController(LaboratoriosService service) {
        this.service = service;
    }

    @GetMapping(value={"/nota/{idingreso}"})
    ResponseEntity<List<LaboratorioModel>> getinformeByIdIngreso(@PathVariable int idingreso) {
        Optional model = this.service.getLaboratoriobyIdingreso(idingreso);
        return model.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build());
    }

    @PostMapping(value={"/insertar"})
    ResponseEntity<LaboratorioModel> insertarCarpeta(@RequestBody LaboratorioModel model) {
        return ResponseEntity.ok((Object)((LaboratorioModel)this.service.save((Object)model)));
    }
}

