/*
 * Decompiled with CFR 0.152.
 */
package com.app.clisist.controllers;

import com.app.clisist.Models.InstruccionesModel;
import com.app.clisist.Services.InstruccionesService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/v1/instrucciones"})
public class InstruccionesController {
    private final InstruccionesService service;

    @Autowired
    public InstruccionesController(InstruccionesService service) {
        this.service = service;
    }

    @PostMapping(value={"/insertar/instrucciones"})
    ResponseEntity<InstruccionesModel> insertarInstrucciones(@RequestBody InstruccionesModel model) {
        return ResponseEntity.ok((Object)((InstruccionesModel)this.service.save((Object)model)));
    }

    @DeleteMapping(value={"/delete/{idinstruccion}"})
    @ResponseStatus(value=HttpStatus.OK)
    void deleteInstruccion(@PathVariable(value="idinstruccion") int idinstruccion) {
        this.service.delete(Integer.valueOf(idinstruccion));
    }

    @PutMapping(value={"/update/instrucciones"})
    ResponseEntity<InstruccionesModel> modificarInstrucciones(@RequestBody InstruccionesModel model) {
        return ResponseEntity.ok((Object)((InstruccionesModel)this.service.save((Object)model)));
    }

    @GetMapping(value={"/obtener/instrucciones/{idmedico}"})
    ResponseEntity<List<InstruccionesModel>> getinstrucciones(@PathVariable int idmedico) {
        Optional consentModel = this.service.getConsentimientos(idmedico);
        return consentModel.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build());
    }

    @GetMapping(value={"/obtener/instrucciones/{idmedico}/{titulo}"})
    ResponseEntity<List<InstruccionesModel>> getInstrucciones(@PathVariable int idmedico, @PathVariable String titulo) {
        Optional consentModel = this.service.getConsentimientosByTittle(idmedico, titulo);
        return consentModel.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build());
    }
}

