/*
 * Decompiled with CFR 0.152.
 */
package com.app.clisist.controllers;

import com.app.clisist.Models.InformeQuirurgicoModel;
import com.app.clisist.Services.InformeQuirurgicoService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"api/v1/informe"})
public class InformeQuirurgicoController {
    private final InformeQuirurgicoService service;

    @Autowired
    public InformeQuirurgicoController(InformeQuirurgicoService service) {
        this.service = service;
    }

    @PostMapping(value={"/insertar"})
    ResponseEntity<InformeQuirurgicoModel> insertarNota(@RequestBody InformeQuirurgicoModel model) {
        return ResponseEntity.ok((Object)((InformeQuirurgicoModel)this.service.save((Object)model)));
    }

    @GetMapping(value={"/nota/{idingreso}"})
    ResponseEntity<List<InformeQuirurgicoModel>> getinformeByIdIngreso(@PathVariable int idingreso) {
        Optional model = this.service.getInformeByIdIngreso(idingreso);
        return model.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build());
    }

    @PutMapping(value={"/update"})
    public ResponseEntity<InformeQuirurgicoModel> EditarInformeQuirurgico(@RequestBody InformeQuirurgicoModel model) {
        try {
            this.service.updateInformeQuirurgico(model.getIdinforme_quirurgico(), model.getCirujano(), model.getAyudante_1(), model.getAyudante_2(), model.getAyudante_3(), model.getAnestesiologo(), model.getOtro(), model.getPreoperatorio(), model.getPostoperatorio(), model.getFecha_realizada(), model.getHorainicio(), model.getHorafinal(), model.getIntervencion(), model.getTipo_anestesia(), model.getHallazgo(), model.getTejido(), model.getEstado().intValue());
            return ResponseEntity.ok((Object)model);
        }
        catch (Exception e) {
            return ResponseEntity.status((int)500).body(null);
        }
    }
}

