/*
 * Decompiled with CFR 0.152.
 */
package com.app.clisist.controllers;

import com.app.clisist.Models.FotoModel;
import com.app.clisist.Services.FotoService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.apache.tomcat.util.codec.binary.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/v1/images"})
public class ImageController {
    private FotoService service;
    @Value(value="${upload.directory}")
    private String uploadDirectory;

    @Autowired
    public ImageController(FotoService service) {
        this.service = service;
    }

    @RequestMapping(value={"/upload"}, method={RequestMethod.POST}, headers={"content-type=multipart/*"}, produces={"application/json"}, consumes={"image/*"})
    public ResponseEntity<FotoModel> SubirImagen(@RequestParam(value="base64") MultipartFile base64Image, @RequestParam(value="idpaciente") int idpaciente, @RequestParam(value="extension") String extension, @RequestParam(value="model") String modelJson) {
        ObjectMapper objectMapper = new ObjectMapper();
        FotoModel model = null;
        try {
            model = (FotoModel)objectMapper.readValue(modelJson, FotoModel.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        int count = this.service.getCountByIdPaciente(idpaciente);
        model.setNombre("imagen" + ++count + "." + extension);
        if (!base64Image.isEmpty()) {
            try {
                byte[] imageBytes = base64Image.getBytes();
                String directorioBase = this.uploadDirectory + "/imagenes";
                String nombreCarpeta = String.valueOf(idpaciente);
                String ruta = directorioBase + "/" + nombreCarpeta + "/imagen" + count + "." + extension;
                File file = new File(directorioBase + "/" + nombreCarpeta);
                if (!file.exists()) {
                    file.mkdirs();
                }
                Path pathGuardar = Paths.get(ruta, new String[0]);
                Files.write(pathGuardar, imageBytes, StandardOpenOption.CREATE);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return ResponseEntity.ok((Object)((FotoModel)this.service.save((Object)model)));
    }

    @RequestMapping(value={"/upload/perfil"}, method={RequestMethod.POST}, headers={"content-type=multipart/*"}, produces={"application/json"}, consumes={"image/*"})
    public ResponseEntity<Void> SubirImagenPerfil(@RequestParam(value="base64") MultipartFile base64Image, @RequestParam(value="idmedico") int idmedico, @RequestParam(value="carpeta") String carpeta, @RequestParam(value="extension") String extension) {
        if (!base64Image.isEmpty()) {
            try {
                byte[] imageBytes = base64Image.getBytes();
                String directorioBase = this.uploadDirectory + "/" + carpeta;
                String nombreCarpeta = String.valueOf(idmedico);
                String ruta = directorioBase + "/" + nombreCarpeta + "/imagen0.jpg";
                File file = new File(directorioBase + "/" + nombreCarpeta);
                if (!file.exists()) {
                    file.mkdirs();
                }
                Path pathGuardar = Paths.get(ruta, new String[0]);
                Files.write(pathGuardar, imageBytes, StandardOpenOption.CREATE);
            }
            catch (IOException e) {
                e.printStackTrace();
                return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
            }
        }
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/upload/perfil"})
    public ResponseEntity<Void> SubirImagenPerfil(@RequestParam(value="base64") String base64Image, @RequestParam(value="idmedico") int idmedico, @RequestParam(value="carpeta") String carpeta, @RequestParam(value="extension") String extension) {
        try {
            byte[] imageBytes = Base64.decodeBase64((String)base64Image);
            String directorioBase = this.uploadDirectory + "/" + carpeta;
            String nombreCarpeta = String.valueOf(idmedico);
            String ruta = directorioBase + "/" + nombreCarpeta + "/imagen0.jpg";
            File file = new File(directorioBase + "/" + nombreCarpeta);
            if (!file.exists()) {
                file.mkdirs();
            }
            Path pathGuardar = FileSystems.getDefault().getPath(ruta, new String[0]);
            try (FileOutputStream stream = new FileOutputStream(pathGuardar.toFile());){
                stream.write(imageBytes);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/{raiz}/{folder}/{fileName:.+}"})
    public ResponseEntity<Resource> getFile(@PathVariable(value="raiz") String raiz, @PathVariable(value="folder") String folder, @PathVariable String fileName) throws MalformedURLException {
        String filePath = this.uploadDirectory + "/" + raiz + "/" + folder + "/" + fileName;
        Path file = Paths.get(filePath, new String[0]);
        UrlResource resource = new UrlResource(file.toUri());
        if (resource.exists() && resource.isReadable()) {
            MediaType mediaType = this.determineMediaType(fileName);
            return ResponseEntity.ok().contentType(mediaType).body((Object)resource);
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/obtener/archivo/{idpaciente}/{idcarpeta}"})
    ResponseEntity<List<FotoModel>> getConsentimientos(@PathVariable int idpaciente, @PathVariable int idcarpeta) {
        Optional fotoModel = this.service.getFotosByIdPacientaAndIdCarpeta(idpaciente, idcarpeta);
        return fotoModel.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build());
    }

    private MediaType determineMediaType(String fileName) {
        String fileExtension;
        switch (fileExtension = FilenameUtils.getExtension((String)fileName.toLowerCase())) {
            case "pdf": {
                return MediaType.APPLICATION_PDF;
            }
            case "jpeg": 
            case "jpg": {
                return MediaType.IMAGE_JPEG;
            }
            case "png": {
                return MediaType.IMAGE_PNG;
            }
        }
        return MediaType.APPLICATION_OCTET_STREAM;
    }
}

