/*
 * Decompiled with CFR 0.152.
 */
package com.app.clisist.controllers;

import com.app.clisist.Models.HospitalModel;
import com.app.clisist.Services.HospitalService;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/v1/hospital"})
public class HospitalController {
    private final HospitalService service;

    @Autowired
    public HospitalController(HospitalService service) {
        this.service = service;
    }

    @GetMapping(value={"/obtener/{idmedico}"})
    ResponseEntity<HospitalModel> getHospitalByIdMedico(@PathVariable int idmedico) {
        Optional hospitalModel = this.service.getHospitalByIdmedico(idmedico);
        return hospitalModel.map(hospital -> ResponseEntity.ok().body(hospital)).orElseGet(() -> ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build());
    }

    @PutMapping(value={"/update/perfil"})
    public void actualizarPefil(@RequestBody HospitalModel hospitalModel) {
        this.service.save((Object)hospitalModel);
    }
}

