/*
 * Decompiled with CFR 0.152.
 */
package com.app.clisist.controllers;

import com.app.clisist.Models.HabitacionModel;
import com.app.clisist.Services.HabitacionService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/v1/habitaciones"})
public class HabitacionController {
    private final HabitacionService service;

    @Autowired
    public HabitacionController(HabitacionService service) {
        this.service = service;
    }

    @GetMapping(value={"/{tipo}"})
    ResponseEntity<List<HabitacionModel>> getHabitacionByTipo(@PathVariable String tipo) {
        Optional model = this.service.getHabitacionesByTipo(tipo);
        return model.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build());
    }

    @PutMapping(value={"/update/{estado}"})
    public ResponseEntity<HabitacionModel> EditarNota(@RequestBody HabitacionModel model, @PathVariable String estado) {
        try {
            this.service.updateHabitacion(model.getIdhab(), estado);
            return ResponseEntity.ok((Object)model);
        }
        catch (Exception e) {
            return ResponseEntity.status((int)500).body(null);
        }
    }
}

