/*
 * Decompiled with CFR 0.152.
 */
package com.app.clisist.controllers;

import com.app.clisist.Models.GlucometriaModel;
import com.app.clisist.Services.GlucometriaService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/v1/glucometrias"})
public class GlucometriaController {
    private final GlucometriaService service;

    @Autowired
    public GlucometriaController(GlucometriaService service) {
        this.service = service;
    }

    @PostMapping(value={"/insertar"})
    ResponseEntity<GlucometriaModel> insertarNota(@RequestBody GlucometriaModel model) {
        return ResponseEntity.ok((Object)((GlucometriaModel)this.service.save((Object)model)));
    }

    @GetMapping(value={"/nota/{idingreso}"})
    ResponseEntity<List<GlucometriaModel>> getNotaGlucometriaByIdPaciente(@PathVariable int idingreso) {
        Optional model = this.service.getGlucometriasByIdIngreso(idingreso);
        return model.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build());
    }

    @PutMapping(value={"/update"})
    public ResponseEntity<GlucometriaModel> EditarNota(@RequestBody GlucometriaModel model) {
        try {
            this.service.updateGlucometria(model.getIdglucometrias(), model.getObservaciones(), model.getGlucometria(), model.getTurno(), model.getNph(), model.getCristalina());
            return ResponseEntity.ok((Object)model);
        }
        catch (Exception e) {
            return ResponseEntity.status((int)500).body(null);
        }
    }
}

