/*
 * Decompiled with CFR 0.152.
 */
package com.app.clisist.controllers;

import com.app.clisist.Models.ConsultaByIdPacienteModel;
import com.app.clisist.Models.ConsultaReducidaModel;
import com.app.clisist.Services.ConsultaInterrogatorioService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/v1/consultaInterrogatorio"})
public class ConsultaInterrogatorioController {
    private final ConsultaInterrogatorioService service;

    @Autowired
    public ConsultaInterrogatorioController(ConsultaInterrogatorioService service) {
        this.service = service;
    }

    @GetMapping(value={"/obtener/fecha/{idmedico}/{desde}/{hasta}"})
    ResponseEntity<List<ConsultaReducidaModel>> getConsultaByFecha(@PathVariable int idmedico, @PathVariable String desde, @PathVariable String hasta) {
        Optional resultados = this.service.getConsultaReducidaByFecha(idmedico, desde, hasta);
        return resultados.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build());
    }

    @GetMapping(value={"/obtener/hoy/{idmedico}/{fecha}"})
    ResponseEntity<List<ConsultaReducidaModel>> getConsultaByHoy(@PathVariable int idmedico, @PathVariable String fecha) {
        Optional resultados = this.service.getConsultaReducidaByHoy(idmedico, fecha);
        return resultados.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build());
    }

    @GetMapping(value={"/obtener/consulta/{idpaciente}"})
    ResponseEntity<List<ConsultaByIdPacienteModel>> getConsultaByHoy(@PathVariable int idpaciente) {
        Optional resultados = this.service.getConsultaByIdPaciente(idpaciente);
        return resultados.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build());
    }
}

