/*
 * Decompiled with CFR 0.152.
 */
package com.app.clisist.controllers;

import com.app.clisist.Models.ConsentimientoOriginalModel;
import com.app.clisist.Services.ConsentimientoOriginalService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"api/v1/consent_original"})
public class ConsentimientoOriginalController {
    private final ConsentimientoOriginalService service;
    @Value(value="${upload.directory}")
    private String uploadDirectory;

    @Autowired
    public ConsentimientoOriginalController(ConsentimientoOriginalService service) {
        this.service = service;
    }

    @GetMapping(value={"/nota/{idingreso}"})
    ResponseEntity<List<ConsentimientoOriginalModel>> getNotaEvolucionByIdPaciente(@PathVariable int idingreso) {
        Optional model = this.service.getConsentimientoByIdingreso(idingreso);
        return model.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build());
    }

    @RequestMapping(value={"/upload_firma"}, method={RequestMethod.POST}, headers={"content-type=multipart/*"}, produces={"application/json"}, consumes={"image/*"})
    public ResponseEntity<ConsentimientoOriginalModel> SubirFirmaPac(@RequestParam(value="base64") MultipartFile base64Image, @RequestParam(value="idpaciente") int idpaciente, @RequestParam(value="extension") String extension, @RequestParam(value="model") String modelJson) {
        ObjectMapper objectMapper = new ObjectMapper();
        ConsentimientoOriginalModel model = null;
        try {
            model = (ConsentimientoOriginalModel)objectMapper.readValue(modelJson, ConsentimientoOriginalModel.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        if (!base64Image.isEmpty()) {
            try {
                byte[] imageBytes = base64Image.getBytes();
                String directorioBase = this.uploadDirectory + "/imagenes";
                String nombreCarpeta = String.valueOf(idpaciente);
                String ruta = directorioBase + "/" + nombreCarpeta + "/firma." + extension;
                File file = new File(directorioBase + "/" + nombreCarpeta);
                if (!file.exists()) {
                    file.mkdirs();
                }
                Path pathGuardar = Paths.get(ruta, new String[0]);
                Files.write(pathGuardar, imageBytes, StandardOpenOption.CREATE);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return ResponseEntity.ok((Object)((ConsentimientoOriginalModel)this.service.save((Object)model)));
    }

    @PostMapping(value={"/insertar"})
    ResponseEntity<ConsentimientoOriginalModel> insertarConsent(@RequestBody ConsentimientoOriginalModel model) {
        return ResponseEntity.ok((Object)((ConsentimientoOriginalModel)this.service.save((Object)model)));
    }
}

