/*
 * Decompiled with CFR 0.152.
 */
package com.app.clisist.controllers;

import com.app.clisist.Models.ConsentModel;
import com.app.clisist.Services.ConsentService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/v1/consent"})
public class ConsentController {
    private final ConsentService service;

    @Autowired
    public ConsentController(ConsentService service) {
        this.service = service;
    }

    @PostMapping(value={"/insertar/consentimiento"})
    ResponseEntity<ConsentModel> insertarConsentimiento(@RequestBody ConsentModel model) {
        return ResponseEntity.ok((Object)((ConsentModel)this.service.save((Object)model)));
    }

    @DeleteMapping(value={"/delete/{idconsent}"})
    void deleteConsentimiento(@PathVariable(value="idconsent") int idconsent) {
        this.service.delete(Integer.valueOf(idconsent));
    }

    @GetMapping(value={"/obtener/consentimiento/{idmedico}"})
    ResponseEntity<List<ConsentModel>> getConsentimientos(@PathVariable int idmedico) {
        Optional consentModel = this.service.getConsentimientos(idmedico);
        return consentModel.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build());
    }

    @GetMapping(value={"/obtener/consentimiento/{idmedico}/{titulo}"})
    ResponseEntity<List<ConsentModel>> getConsentimientos(@PathVariable int idmedico, @PathVariable String titulo) {
        Optional consentModel = this.service.getConsentimientosByTittle(idmedico, titulo);
        return consentModel.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build());
    }
}

