/*
 * Decompiled with CFR 0.152.
 */
package com.app.clisist.controllers;

import com.app.clisist.Models.CitaPojo;
import com.app.clisist.Services.CitaService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/v1/cita"})
public class CitaController {
    private final CitaService service;

    @Autowired
    public CitaController(CitaService service) {
        this.service = service;
    }

    @GetMapping(value={"/obtener/{idmedico}/{fecha}"})
    ResponseEntity<List<CitaPojo>> getConsultaByHoy(@PathVariable int idmedico, @PathVariable(value="fecha") String fecha) {
        Optional resultados = this.service.getCitasByIdMedico(idmedico, fecha);
        return resultados.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build());
    }

    @GetMapping(value={"/obtener_fecha/{idmedico}/{fecha}"})
    ResponseEntity<List<CitaPojo>> getFechasByIdMedico(@PathVariable int idmedico, @PathVariable(value="fecha") String fecha) {
        Optional resultados = this.service.getFechasByIdMedico(idmedico, fecha);
        return resultados.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build());
    }

    @PutMapping(value={"/actualizar/{idestado}/{horainicio}/{idcita}"})
    public boolean actualizarCita(@PathVariable(value="idestado") int idestado, @PathVariable(value="horainicio") String horainicio, @PathVariable(value="idcita") int idcita) {
        int filas = this.service.actualizarCita(idestado, horainicio, idcita);
        return filas > 0;
    }
}

