/*
 * Decompiled with CFR 0.152.
 */
package com.app.clisist.controllers;

import com.app.clisist.Models.CarpetaModel;
import com.app.clisist.Services.CarpetaService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/v1/carpeta"})
public class CarpetaController {
    private final CarpetaService service;

    @Autowired
    public CarpetaController(CarpetaService service) {
        this.service = service;
    }

    @GetMapping(value={"/obtener/{idpaciente}"})
    ResponseEntity<List<CarpetaModel>> getCarpetasByIdPaciente(@PathVariable int idpaciente) {
        Optional carpetaModel = this.service.getCarpetasByIdPaciente(idpaciente);
        return carpetaModel.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build());
    }

    @PostMapping(value={"/insertar"})
    ResponseEntity<CarpetaModel> insertarCarpeta(@RequestBody CarpetaModel model) {
        return ResponseEntity.ok((Object)((CarpetaModel)this.service.save((Object)model)));
    }
}

