/*
 * Decompiled with CFR 0.152.
 */
package com.app.clisist.controllers;

import com.app.clisist.Models.AnestesiaModel;
import com.app.clisist.Services.AnestesiaService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/v1/anestesia"})
public class AnestesiaController {
    private final AnestesiaService service;

    @Autowired
    public AnestesiaController(AnestesiaService service) {
        this.service = service;
    }

    @PostMapping(value={"/insertar"})
    ResponseEntity<AnestesiaModel> insertarNota(@RequestBody AnestesiaModel model) {
        return ResponseEntity.ok((Object)((AnestesiaModel)this.service.save((Object)model)));
    }

    @GetMapping(value={"/nota/{idingreso}"})
    ResponseEntity<List<AnestesiaModel>> getNotaAnestesiaByIdPaciente(@PathVariable int idingreso) {
        Optional model = this.service.getAnestesiaByIdIngreso(idingreso);
        return model.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build());
    }

    @PutMapping(value={"/update"})
    public ResponseEntity<AnestesiaModel> EditarAnestesia(@RequestBody AnestesiaModel model) {
        try {
            this.service.updateAnestesia(model.getIdanestesia(), model.getCadena_raza(), model.getPeso(), model.getTalla(), model.getImportante(), model.getPreoperatorio(), model.getIntervencion(), model.getHistoria_anestesia(), model.getRecomendaciones(), model.getCadena_fisico(), model.getCadena_riesgo(), model.getCadena_interrogatorio(), model.getTa(), model.getPulso(), model.getCaracter(), model.getAuscultacion_1(), model.getEcg(), model.getFrecuencia(), model.getAuscultacion_2(), model.getRayosx(), model.getP_funcionales(), model.getHemoglobina(), model.getHematocrito(), model.getGlicemia(), model.getUrea(), model.getSerologia(), model.getTrans_previa(), model.getGrupo_sanguineo(), model.getPre_anestesia(), model.getAnestesia_indicada(), model.getMetodo(), model.getAgente(), model.getCadena_toxicos(), model.getFosas(), model.getBoca(), model.getTraquea(), model.getColumna(), model.getEsteroides(), model.getMedicacion(), model.getObservaciones());
            return ResponseEntity.ok((Object)model);
        }
        catch (Exception e) {
            return ResponseEntity.status((int)500).body(null);
        }
    }
}

