/*
 * Decompiled with CFR 0.152.
 */
package com.app.clisist.controllers;

import com.app.clisist.Models.AnestesiaAplicadaModel;
import com.app.clisist.Services.AnestesiaAplicadaService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/v1/anestesia_aplicada"})
public class AnestesiaAplicadaController {
    private final AnestesiaAplicadaService service;

    @Autowired
    public AnestesiaAplicadaController(AnestesiaAplicadaService service) {
        this.service = service;
    }

    @PostMapping(value={"/insertar"})
    ResponseEntity<AnestesiaAplicadaModel> insertarNota(@RequestBody AnestesiaAplicadaModel model) {
        return ResponseEntity.ok((Object)((AnestesiaAplicadaModel)this.service.save((Object)model)));
    }

    @GetMapping(value={"/nota/{idingreso}"})
    ResponseEntity<List<AnestesiaAplicadaModel>> getNotaAnestesiaByIdPaciente(@PathVariable int idingreso) {
        Optional model = this.service.getAnestesiaByIdIngreso(idingreso);
        return model.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build());
    }

    @PutMapping(value={"/update"})
    public ResponseEntity<AnestesiaAplicadaModel> EditarNota(@RequestBody AnestesiaAplicadaModel model) {
        try {
            this.service.updateAnestesiaAplicada(model.getIdAnestesiaAplicada(), model.getMetodo(), model.getPosicion(), model.getAgente(), model.getNivel(), model.getVia(), model.getTecnica(), model.getDescripcion());
            System.out.println(model.getIdAnestesiaAplicada() + " pepazo");
            return ResponseEntity.ok((Object)model);
        }
        catch (Exception e) {
            return ResponseEntity.status((int)500).body(null);
        }
    }
}

