/*
 * Decompiled with CFR 0.152.
 */
package com.app.clisist.Services;

import com.app.clisist.Models.PacienteModel;
import com.app.clisist.Models.SalaEspera;
import com.app.clisist.Repositories.PacienteRepository;
import com.app.clisist.Services.GenericServiceImp;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class PacienteService
extends GenericServiceImp<PacienteModel> {
    private final PacienteRepository pacienteRepository;

    @Autowired
    public PacienteService(PacienteRepository pacienteRepository) {
        super((JpaRepository)pacienteRepository);
        this.pacienteRepository = pacienteRepository;
    }

    public List<PacienteModel> retornarPacientesConLimite(int limit) {
        return this.pacienteRepository.retornarPacientesConLimite(limit);
    }

    public List<PacienteModel> buscarPacientePorNombre(String nombre) {
        return this.pacienteRepository.buscarPacientePorNombre(nombre);
    }

    public Optional<List<SalaEspera>> getSalaEsperaByidMedico(int idmedico) {
        Optional salaespera = this.pacienteRepository.getSalaEsperaByMedico(idmedico);
        if (salaespera.isPresent()) {
            ArrayList<SalaEspera> resultadoFinal = new ArrayList<SalaEspera>();
            for (Object[] resultado : (List)salaespera.get()) {
                SalaEspera sala = new SalaEspera();
                sala.setNombre(resultado[0].toString());
                sala.setEdad(((Integer)resultado[1]).intValue());
                sala.setActivo(((Integer)resultado[2]).intValue());
                sala.setIdpaciente(((Integer)resultado[3]).intValue());
                sala.setIdentidad(resultado[4].toString());
                sala.setTelefono(resultado[5].toString());
                sala.setIdsala(((Integer)resultado[6]).intValue());
                resultadoFinal.add(sala);
            }
            return Optional.of(resultadoFinal);
        }
        return Optional.empty();
    }
}

