/*
 * Decompiled with CFR 0.152.
 */
package com.app.clisist.Services;

import com.app.clisist.Models.NotaEvolucionModel;
import com.app.clisist.Models.PlanesPojo;
import com.app.clisist.Repositories.NotaEvolucionRepository;
import com.app.clisist.Services.GenericServiceImp;
import jakarta.transaction.Transactional;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class NotaEvolucionService
extends GenericServiceImp<NotaEvolucionModel> {
    private final NotaEvolucionRepository repository;

    @Autowired
    public NotaEvolucionService(NotaEvolucionRepository repository) {
        super((JpaRepository)repository);
        this.repository = repository;
    }

    public Optional<List<NotaEvolucionModel>> getNotasByIdIngreso(int idingreso) {
        return this.repository.getNotaEvolucionByIdIngreso(idingreso);
    }

    public Optional<List<PlanesPojo>> obtenerPlanes(int idingreso) {
        Optional planes = this.repository.obtenerPlanes(idingreso);
        if (planes.isPresent()) {
            ArrayList<PlanesPojo> resultadoFinal = new ArrayList<PlanesPojo>();
            for (Object[] resultado : (List)planes.get()) {
                PlanesPojo pojo = new PlanesPojo();
                pojo.setFecha(resultado[0].toString());
                pojo.setPlan(resultado[1].toString());
                pojo.setHora(resultado[2].toString());
                resultadoFinal.add(pojo);
            }
            return Optional.of(resultadoFinal);
        }
        return Optional.empty();
    }

    @Transactional
    public void updateNotaEvolucion(int idNotaEvolucion, String subjetivo, String objetivo, String analisis, String plan, String pronostico, String laboratorios, String temp, String fc, String pa, String fr, String oximetria, String glucosa, int alta) {
        this.repository.updateNotaEvolucion(idNotaEvolucion, subjetivo, objetivo, analisis, plan, pronostico, laboratorios, temp, fc, pa, fr, oximetria, glucosa, alta);
    }
}

