/*
 * Decompiled with CFR 0.152.
 */
package com.app.clisist.Services;

import com.app.clisist.Models.NotaEnfermeriaModel;
import com.app.clisist.Models.PlanesPojo;
import com.app.clisist.Repositories.NotaEnfermeriaRepository;
import com.app.clisist.Services.GenericServiceImp;
import jakarta.transaction.Transactional;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class NotaEnfermeriaService
extends GenericServiceImp<NotaEnfermeriaModel> {
    private final NotaEnfermeriaRepository repository;

    @Autowired
    public NotaEnfermeriaService(NotaEnfermeriaRepository repository) {
        super((JpaRepository)repository);
        this.repository = repository;
    }

    public Optional<List<NotaEnfermeriaModel>> getNotasByIdIngreso(int idingreso) {
        return this.repository.getnotaenfermeriaByIdIngreso(idingreso);
    }

    public Optional<List<PlanesPojo>> obtenerPlanes(int idingreso) {
        Optional planes = this.repository.obtenerPlanes(idingreso);
        if (planes.isPresent()) {
            ArrayList<PlanesPojo> resultadoFinal = new ArrayList<PlanesPojo>();
            for (Object[] resultado : (List)planes.get()) {
                PlanesPojo pojo = new PlanesPojo();
                pojo.setFecha(resultado[0].toString());
                pojo.setPlan(resultado[1].toString());
                pojo.setHora(resultado[2].toString());
                resultadoFinal.add(pojo);
            }
            return Optional.of(resultadoFinal);
        }
        return Optional.empty();
    }

    @Transactional
    public void updateNotaEnfermeria(int idNotaEvolucion, String observacion, String exploracion, String turno, String temp, String fc, String pa, String fr, String oximetria, String glucosa) {
        this.repository.updatenotaenfermeria(idNotaEvolucion, observacion, exploracion, turno, temp, fc, pa, fr, oximetria, glucosa);
    }
}

