/*
 * Decompiled with CFR 0.152.
 */
package com.app.clisist.Services;

import com.app.clisist.Models.MedicamentoDTO;
import com.app.clisist.Models.MedicamentoModel;
import com.app.clisist.Repositories.MedicamentoRepository;
import com.app.clisist.Services.GenericServiceImp;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class MedicamentosService
extends GenericServiceImp<MedicamentoModel> {
    private final MedicamentoRepository repository;

    @Autowired
    public MedicamentosService(MedicamentoRepository repository) {
        super((JpaRepository)repository);
        this.repository = repository;
    }

    public Optional<List<MedicamentoModel>> getMedicamentosActivos(int activo) {
        return this.repository.getMedicamentosActivos(activo);
    }

    public Optional<List<MedicamentoDTO>> getMedicamentosWithConfig(int activo) {
        Optional ingresoPojo = this.repository.getMedicamentosWithConfig(activo);
        return ingresoPojo.map(resultados -> {
            ArrayList<MedicamentoDTO> resultadoFinal = new ArrayList<MedicamentoDTO>();
            for (Object[] resultado : resultados) {
                MedicamentoDTO pojo = new MedicamentoDTO();
                pojo.setIdmaterial(((Integer)resultado[0]).intValue());
                pojo.setCodigo((String)resultado[1]);
                pojo.setDescripcion((String)resultado[2]);
                pojo.setCantidad(((Double)resultado[3]).doubleValue());
                pojo.setIdTipoImpuesto(((Integer)resultado[4]).intValue());
                pojo.setPrecio(((Double)resultado[5]).doubleValue());
                pojo.setActivo(1);
                pojo.setContenido((String)resultado[7]);
                pojo.setUnidad((String)resultado[8]);
                resultadoFinal.add(pojo);
            }
            return resultadoFinal;
        });
    }
}

