/*
 * Decompiled with CFR 0.152.
 */
package com.app.clisist.Services;

import com.app.clisist.Models.IngresoPacienteModel;
import com.app.clisist.Models.PacientesInternosPojo;
import com.app.clisist.Repositories.PacientesIngresoRepository;
import com.app.clisist.Services.GenericServiceImp;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class IngresoPacienteService
extends GenericServiceImp<IngresoPacienteModel> {
    private final PacientesIngresoRepository repository;

    @Autowired
    public IngresoPacienteService(PacientesIngresoRepository repository) {
        super((JpaRepository)repository);
        this.repository = repository;
    }

    public void updateGraves(int grave, int idingreso) {
        this.repository.updateGrave(grave, idingreso);
    }

    public Optional<List<PacientesInternosPojo>> getPacientesInternadosByNombre(String nombre, int idtipo) {
        Optional ingresoPojo = this.repository.getPacientesInternamientoByNombre(nombre, idtipo);
        if (ingresoPojo.isPresent()) {
            ArrayList<PacientesInternosPojo> resultadoFinal = new ArrayList<PacientesInternosPojo>();
            for (Object[] resultado : (List)ingresoPojo.get()) {
                PacientesInternosPojo pojo = new PacientesInternosPojo();
                pojo.setNombre((String)resultado[0]);
                pojo.setIdentidad((String)resultado[1]);
                pojo.setEdad(((Integer)resultado[2]).intValue());
                pojo.setFechaIngreso(resultado[3].toString());
                pojo.setHoraIngreso(resultado[4].toString());
                pojo.setNroHab(resultado[5].toString());
                pojo.setTipoHab((String)resultado[6]);
                pojo.setIdArea((String)resultado[7]);
                pojo.setIdIngresoPaciente(((Integer)resultado[8]).intValue());
                pojo.setIdPaciente(((Integer)resultado[9]).intValue());
                pojo.setTelefono((String)resultado[10]);
                pojo.setEmail((String)resultado[11]);
                pojo.setIdgenero(((Integer)resultado[12]).intValue());
                pojo.setGrave(((Integer)resultado[13]).intValue());
                resultadoFinal.add(pojo);
            }
            return Optional.of(resultadoFinal);
        }
        return Optional.empty();
    }

    public Optional<List<PacientesInternosPojo>> getPacientesInternadosHistorialByNombre(String nombre) {
        Optional ingresoPojo = this.repository.getPacientesInternamientoHistorialByNombre(nombre);
        if (ingresoPojo.isPresent()) {
            ArrayList<PacientesInternosPojo> resultadoFinal = new ArrayList<PacientesInternosPojo>();
            for (Object[] resultado : (List)ingresoPojo.get()) {
                PacientesInternosPojo pojo = new PacientesInternosPojo();
                pojo.setNombre((String)resultado[0]);
                pojo.setIdentidad((String)resultado[1]);
                pojo.setEdad(((Integer)resultado[2]).intValue());
                pojo.setFechaIngreso(resultado[3].toString());
                pojo.setHoraIngreso(resultado[4].toString());
                pojo.setNroHab(resultado[5].toString());
                pojo.setTipoHab((String)resultado[6]);
                pojo.setIdArea((String)resultado[7]);
                pojo.setIdIngresoPaciente(((Integer)resultado[8]).intValue());
                pojo.setIdPaciente(((Integer)resultado[9]).intValue());
                pojo.setTelefono((String)resultado[10]);
                pojo.setEmail((String)resultado[11]);
                pojo.setIdgenero(((Integer)resultado[12]).intValue());
                pojo.setGrave(((Integer)resultado[13]).intValue());
                resultadoFinal.add(pojo);
            }
            return Optional.of(resultadoFinal);
        }
        return Optional.empty();
    }

    public Optional<List<PacientesInternosPojo>> getPacientesInternados(int idtipo) {
        Optional ingresoPojo = this.repository.getPacientesInternamiento(idtipo);
        if (ingresoPojo.isPresent()) {
            ArrayList<PacientesInternosPojo> resultadoFinal = new ArrayList<PacientesInternosPojo>();
            for (Object[] resultado : (List)ingresoPojo.get()) {
                PacientesInternosPojo pojo = new PacientesInternosPojo();
                pojo.setNombre((String)resultado[0]);
                pojo.setIdentidad((String)resultado[1]);
                pojo.setEdad(((Integer)resultado[2]).intValue());
                pojo.setFechaIngreso(resultado[3].toString());
                pojo.setHoraIngreso(resultado[4].toString());
                pojo.setNroHab(resultado[5].toString());
                pojo.setTipoHab((String)resultado[6]);
                pojo.setIdArea((String)resultado[7]);
                pojo.setIdIngresoPaciente(((Integer)resultado[8]).intValue());
                pojo.setIdPaciente(((Integer)resultado[9]).intValue());
                pojo.setTelefono((String)resultado[10]);
                pojo.setEmail((String)resultado[11]);
                pojo.setIdgenero(((Integer)resultado[12]).intValue());
                pojo.setGrave(((Integer)resultado[13]).intValue());
                resultadoFinal.add(pojo);
            }
            return Optional.of(resultadoFinal);
        }
        return Optional.empty();
    }
}

