/*
 * Decompiled with CFR 0.152.
 */
package com.app.clisist.Services;

import com.app.clisist.Models.ConsultaByIdPacienteModel;
import com.app.clisist.Models.ConsultaInterrogatorioModel;
import com.app.clisist.Models.ConsultaReducidaModel;
import com.app.clisist.Repositories.ConsultaInterrogatorioRepository;
import com.app.clisist.Services.GenericServiceImp;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class ConsultaInterrogatorioService
extends GenericServiceImp<ConsultaInterrogatorioModel> {
    private final ConsultaInterrogatorioRepository repository;

    @Autowired
    public ConsultaInterrogatorioService(ConsultaInterrogatorioRepository repository) {
        super((JpaRepository)repository);
        this.repository = repository;
    }

    public Optional<List<ConsultaReducidaModel>> getConsultaReducidaByFecha(int idmedico, String startDate, String endDate) {
        Optional consultaResultados = this.repository.getConsultaByFecha(idmedico, startDate, endDate);
        if (consultaResultados.isPresent()) {
            ArrayList<ConsultaReducidaModel> resultadoFinal = new ArrayList<ConsultaReducidaModel>();
            for (Object[] resultado : (List)consultaResultados.get()) {
                ConsultaReducidaModel consultaReducidaModel = new ConsultaReducidaModel();
                consultaReducidaModel.setNroconsulta(((Integer)resultado[0]).intValue());
                consultaReducidaModel.setNombre((String)resultado[1]);
                consultaReducidaModel.setFecha((String)resultado[2]);
                consultaReducidaModel.setIdpaciente(((Integer)resultado[3]).intValue());
                consultaReducidaModel.setIdgenero((int)((Number)resultado[4]).byteValue());
                resultadoFinal.add(consultaReducidaModel);
            }
            return Optional.of(resultadoFinal);
        }
        return Optional.empty();
    }

    public Optional<List<ConsultaReducidaModel>> getConsultaReducidaByHoy(int idmedico, String fecha) {
        Optional consultaResultados = this.repository.getConsultaByHoy(idmedico, fecha);
        if (consultaResultados.isPresent()) {
            ArrayList<ConsultaReducidaModel> resultadoFinal = new ArrayList<ConsultaReducidaModel>();
            for (Object[] resultado : (List)consultaResultados.get()) {
                ConsultaReducidaModel consultaReducidaModel = new ConsultaReducidaModel();
                consultaReducidaModel.setNroconsulta(((Integer)resultado[0]).intValue());
                consultaReducidaModel.setNombre((String)resultado[1]);
                consultaReducidaModel.setFecha((String)resultado[2]);
                consultaReducidaModel.setIdpaciente(((Integer)resultado[3]).intValue());
                consultaReducidaModel.setIdgenero((int)((Number)resultado[4]).byteValue());
                resultadoFinal.add(consultaReducidaModel);
            }
            return Optional.of(resultadoFinal);
        }
        return Optional.empty();
    }

    public Optional<List<ConsultaByIdPacienteModel>> getConsultaByIdPaciente(int idpaciente) {
        Optional consultaResultados = this.repository.getConsultaByIdpaciente(idpaciente);
        if (consultaResultados.isPresent()) {
            ArrayList<ConsultaByIdPacienteModel> resultadoFinal = new ArrayList<ConsultaByIdPacienteModel>();
            for (Object[] resultado : (List)consultaResultados.get()) {
                ConsultaByIdPacienteModel consulta = new ConsultaByIdPacienteModel();
                consulta.setNro(((Integer)resultado[0]).intValue());
                consulta.setPaciente((String)resultado[1]);
                consulta.setMedico((String)resultado[2]);
                consulta.setFecha((String)resultado[3]);
                consulta.setIdpaciente(((Integer)resultado[4]).intValue());
                resultadoFinal.add(consulta);
            }
            return Optional.of(resultadoFinal);
        }
        return Optional.empty();
    }
}

