/*
 * Decompiled with CFR 0.152.
 */
package com.app.clisist.Services;

import com.app.clisist.Models.ConceptoMedicinaModel;
import com.app.clisist.Repositories.ConceptoMedicinaRepository;
import com.app.clisist.Repositories.MedicamentoRepository;
import com.app.clisist.Services.GenericServiceImp;
import jakarta.transaction.Transactional;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class ConceptoMedicinaService
extends GenericServiceImp<ConceptoMedicinaModel> {
    private final ConceptoMedicinaRepository repository;
    @Autowired
    private MedicamentoRepository medicamentoRepository;

    @Autowired
    public ConceptoMedicinaService(ConceptoMedicinaRepository repository) {
        super((JpaRepository)repository);
        this.repository = repository;
    }

    @Transactional
    public List<ConceptoMedicinaModel> saveAllWithInventoryUpdate(List<ConceptoMedicinaModel> modelos) {
        for (ConceptoMedicinaModel model : modelos) {
            this.medicamentoRepository.updateCantidad(model.getCantidad(), model.getIdconcepto());
        }
        return this.repository.saveAll(modelos);
    }
}

