/*
 * Decompiled with CFR 0.152.
 */
package com.app.clisist.Services;

import com.app.clisist.Models.CitaModel;
import com.app.clisist.Models.CitaPojo;
import com.app.clisist.Repositories.CitaMedicaRepository;
import com.app.clisist.Services.GenericServiceImp;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class CitaService
extends GenericServiceImp<CitaModel> {
    private final CitaMedicaRepository repository;

    @Autowired
    public CitaService(CitaMedicaRepository repository) {
        super((JpaRepository)repository);
        this.repository = repository;
    }

    public Optional<List<CitaPojo>> getCitasByIdMedico(int idmedico, String fecha) {
        Optional citaPojo = this.repository.getCitaMedicaByIdMedico(idmedico, fecha);
        if (citaPojo.isPresent()) {
            ArrayList<CitaPojo> resultadoFinal = new ArrayList<CitaPojo>();
            for (Object[] resultado : (List)citaPojo.get()) {
                CitaPojo cita = new CitaPojo();
                cita.setPaciente((String)resultado[0]);
                cita.setFecha(resultado[1].toString());
                cita.setHorainicio(resultado[2].toString());
                cita.setDescripcion((String)resultado[3]);
                cita.setIdcitamedica(((Integer)resultado[4]).intValue());
                cita.setTelefono((String)resultado[5]);
                resultadoFinal.add(cita);
            }
            return Optional.of(resultadoFinal);
        }
        return Optional.empty();
    }

    public int actualizarCita(int idestado, String horainicio, int idcita) {
        return this.repository.updateCitaMedica(idestado, horainicio, idcita);
    }

    public Optional<List<CitaPojo>> getFechasByIdMedico(int idmedico, String fecha) {
        Optional citaPojo = this.repository.getFechasByIdMedico(idmedico, fecha);
        if (citaPojo.isPresent()) {
            ArrayList<CitaPojo> resultadoFinal = new ArrayList<CitaPojo>();
            for (Object[] resultado : (List)citaPojo.get()) {
                CitaPojo cita = new CitaPojo();
                cita.setPaciente("");
                cita.setFecha(resultado[0].toString());
                cita.setHorainicio("");
                cita.setDescripcion("");
                cita.setIdcitamedica(0);
                cita.setTelefono("");
                resultadoFinal.add(cita);
            }
            return Optional.of(resultadoFinal);
        }
        return Optional.empty();
    }
}

