/*
 * Decompiled with CFR 0.152.
 */
package com.app.clisist.Repositories;

import com.app.clisist.Models.MedicamentoModel;
import jakarta.transaction.Transactional;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface MedicamentoRepository
extends JpaRepository<MedicamentoModel, Integer> {
    @Query(value="SELECT idmaterial, codigo, descripcion, cantidad, idTipoImpuesto, precio, activo FROM inv_materiales WHERE activo = :activo AND idinventario = 1 AND descripcion != ''", nativeQuery=true)
    public Optional<List<MedicamentoModel>> getMedicamentosActivos(@Param(value="activo") int var1);

    @Query(value="SELECT i.idmaterial, i.codigo, i.descripcion, i.cantidad, i.idTipoImpuesto, i.precio, i.activo, COALESCE(c.contenido, '') as contenido, COALESCE(c.unidad, '') as unidad FROM inv_materiales i LEFT JOIN conf_medicamento c ON i.idmaterial = c.idmedicamento WHERE i.activo = :activo AND i.idinventario = 1 AND i.descripcion != ''", nativeQuery=true)
    public Optional<List<Object[]>> getMedicamentosWithConfig(@Param(value="activo") int var1);

    @Modifying
    @Transactional
    @Query(value="UPDATE inv_materiales SET cantidad = cantidad - :cantidad WHERE idMaterial = :idMaterial", nativeQuery=true)
    public void updateCantidad(@Param(value="cantidad") double var1, @Param(value="idMaterial") int var3);
}

