/*
 * Decompiled with CFR 0.152.
 */
package com.app.clisist.Repositories;

import com.app.clisist.Models.AnestesiaModel;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface AnestesiaRepository
extends JpaRepository<AnestesiaModel, Integer> {
    @Query(value="SELECT anestesia.*, usuarios.usuario\nFROM anestesia\nINNER JOIN usuarios ON usuarios.idusuario = anestesia.idmedico\nWHERE idingreso = :idingreso\nORDER BY STR_TO_DATE(CONCAT(anestesia.fecha, ' ', anestesia.hora), '%Y-%m-%d %H:%i:%s') DESC;\n", nativeQuery=true)
    public Optional<List<AnestesiaModel>> getAnestesiaByIdIngreso(@Param(value="idingreso") int var1);

    @Modifying
    @Query(value="UPDATE anestesia \n SET \n    cadena_raza = :cadena_raza,\n    peso = :peso,\n    talla = :talla,\n    importante = :importante,\n    preoperatorio = :preoperatorio,\n    intervencion = :intervencion,\n    historia_anestesia = :historia_anestesia,\n    recomendaciones = :recomendaciones,\n    cadena_fisico = :cadena_fisico,\n    cadena_riesgo = :cadena_riesgo,\n    cadena_interrogatorio = :cadena_interrogatorio,\n    ta = :ta,\n    pulso = :pulso,\n    caracter = :caracter,\n    auscultacion_1 = :auscultacion_1,\n    ecg = :ecg,\n    frecuencia = :frecuencia,\n    auscultacion_2 = :auscultacion_2,\n    rayosx = :rayosx,\n    p_funcionales = :p_funcionales,\n    hemoglobina = :hemoglobina,\n    hematocrito = :hematocrito,\n    glicemia = :glicemia,\n    urea = :urea,\n    serologia = :serologia,\n    trans_previa = :trans_previa,\n    grupo_sanguineo = :grupo_sanguineo,\n    pre_anestesia = :pre_anestesia,\n    anestesia_indicada = :anestesia_indicada,\n    metodo = :metodo,\n    agente = :agente,\n    cadena_toxicos = :cadena_toxicos,\n    fosas = :fosas,\n    boca = :boca,\n    traquea = :traquea,\n    columna = :columna,\n    esteroides = :esteroides,\n    medicacion = :medicacion,\n    observaciones = :observaciones \n  WHERE idanestesia =:idanestesia\n", nativeQuery=true)
    public int updateAnestesia(@Param(value="idanestesia") int var1, @Param(value="cadena_raza") String var2, @Param(value="peso") String var3, @Param(value="talla") String var4, @Param(value="importante") String var5, @Param(value="preoperatorio") String var6, @Param(value="intervencion") String var7, @Param(value="historia_anestesia") String var8, @Param(value="recomendaciones") String var9, @Param(value="cadena_fisico") String var10, @Param(value="cadena_riesgo") String var11, @Param(value="cadena_interrogatorio") String var12, @Param(value="ta") String var13, @Param(value="pulso") String var14, @Param(value="caracter") String var15, @Param(value="auscultacion_1") String var16, @Param(value="ecg") String var17, @Param(value="frecuencia") String var18, @Param(value="auscultacion_2") String var19, @Param(value="rayosx") String var20, @Param(value="p_funcionales") String var21, @Param(value="hemoglobina") String var22, @Param(value="hematocrito") String var23, @Param(value="glicemia") String var24, @Param(value="urea") String var25, @Param(value="serologia") String var26, @Param(value="trans_previa") String var27, @Param(value="grupo_sanguineo") String var28, @Param(value="pre_anestesia") String var29, @Param(value="anestesia_indicada") String var30, @Param(value="metodo") String var31, @Param(value="agente") String var32, @Param(value="cadena_toxicos") String var33, @Param(value="fosas") String var34, @Param(value="boca") String var35, @Param(value="traquea") String var36, @Param(value="columna") String var37, @Param(value="esteroides") String var38, @Param(value="medicacion") String var39, @Param(value="observaciones") String var40);
}

