/*
 * Decompiled with CFR 0.152.
 */
import com.app.clisist.Models.MyTelegramBot;
import jakarta.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.telegram.telegrambots.meta.TelegramBotsApi;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;
import org.telegram.telegrambots.meta.generics.LongPollingBot;
import org.telegram.telegrambots.updatesreceivers.DefaultBotSession;

@Configuration
@EnableWebMvc
@EnableJpaRepositories(basePackages={"com.app.clisist.repositories"})
public class GeneralConfig
implements WebMvcConfigurer {
    @Value(value="${spring.datasource.url}")
    private String databaseUrl;
    @Value(value="${spring.datasource.username}")
    private String databaseUsername;
    @Value(value="${spring.datasource.password}")
    private String databasePassword;
    @Autowired
    private MyTelegramBot myTelegramBot;

    @Bean
    public DataSource getDataSource() {
        DriverManagerDataSource dataSource = new DriverManagerDataSource();
        dataSource.setDriverClassName("com.mysql.cj.jdbc.Driver");
        dataSource.setUrl(this.databaseUrl);
        dataSource.setUsername(this.databaseUsername);
        dataSource.setPassword(this.databasePassword);
        return dataSource;
    }

    @Bean
    public JpaTransactionManager transactionManager(EntityManagerFactory factory) {
        return new JpaTransactionManager(factory);
    }

    @Bean
    public CommandLineRunner registerBot() {
        return args -> {
            TelegramBotsApi botsApi = new TelegramBotsApi(DefaultBotSession.class);
            try {
                botsApi.registerBot((LongPollingBot)this.myTelegramBot);
            }
            catch (TelegramApiException e) {
                e.printStackTrace();
            }
        };
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/images/**"}).addResourceLocations(new String[]{"file:/var/www/html/spring/"});
    }

    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**").allowedOrigins(new String[]{"*"}).allowedMethods(new String[]{"*"}).allowedHeaders(new String[]{"*"}).allowedOriginPatterns(new String[]{"*"});
    }
}

